/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.apps._3dt;

import de.jreality.geometry.GeometryUtility;
import de.jreality.geometry.Primitives;
import de.jreality.jogl.Viewer;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.Light;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.tool.Tool;
import de.jreality.softviewer.SoftViewer;
import de.jreality.tools.ClickWheelCameraZoomTool;
import de.jreality.tools.DraggingTool;
import de.jreality.tools.RotateTool;
import de.jreality.toolsystem.ToolSystem;
import de.jreality.util.CameraUtility;
import de.jreality.util.ImageUtility;
import de.jreality.util.Rectangle3D;
import de.jreality.util.RenderTrigger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GLException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.gavrog.box.gui.Invoke;

public class ViewerFrame
extends JFrame {
    private static final long serialVersionUID = -2113428321285684234L;
    private final SceneGraphComponent rootNode = new SceneGraphComponent();
    private final SceneGraphComponent cameraNode = new SceneGraphComponent();
    private final SceneGraphComponent geometryNode = new SceneGraphComponent();
    private final SceneGraphComponent lightNode = new SceneGraphComponent();
    private final SceneGraphComponent contentNode;
    private final Map<String, SceneGraphComponent> lights = new HashMap<String, SceneGraphComponent>();
    private final SoftViewer softwareViewer;
    private final RenderTrigger renderTrigger = new RenderTrigger();
    private de.jreality.scene.Viewer viewer;
    private double[] lastCenter = null;

    public ViewerFrame(SceneGraphComponent content) {
        this.contentNode = content;
        this.rootNode.addChild(this.geometryNode);
        this.rootNode.addChild(this.cameraNode);
        this.rootNode.addChild(this.lightNode);
        this.geometryNode.addChild(this.contentNode);
        this.contentNode.addTool((Tool)new RotateTool());
        this.contentNode.addTool((Tool)new DraggingTool());
        this.contentNode.addTool((Tool)new ClickWheelCameraZoomTool());
        Camera camera = new Camera();
        this.cameraNode.setCamera(camera);
        MatrixBuilder.euclidean().translate(0.0, 0.0, 3.0).assignTo(this.cameraNode);
        Appearance rootApp = new Appearance();
        rootApp.setAttribute("backgroundColor", (Object)Color.DARK_GRAY);
        rootApp.setAttribute("diffuseColor", (Object)Color.RED);
        this.rootNode.setAppearance(rootApp);
        SceneGraphPath camPath = new SceneGraphPath();
        camPath.push((SceneGraphNode)this.rootNode);
        camPath.push((SceneGraphNode)this.cameraNode);
        camPath.push((SceneGraphNode)camera);
        SceneGraphPath emptyPickPath = new SceneGraphPath();
        emptyPickPath.push((SceneGraphNode)this.rootNode);
        emptyPickPath.push((SceneGraphNode)this.geometryNode);
        emptyPickPath.push((SceneGraphNode)this.contentNode);
        this.softwareViewer = new SoftViewer();
        this.softwareViewer.setSceneRoot(this.rootNode);
        this.softwareViewer.setCameraPath(camPath);
        this.setupToolSystem((de.jreality.scene.Viewer)this.softwareViewer, emptyPickPath);
        try {
            this.viewer = new Viewer();
            this.viewer.setSceneRoot(this.rootNode);
            this.viewer.setCameraPath(camPath);
            this.setupToolSystem(this.viewer, emptyPickPath);
        }
        catch (Exception ex) {
            System.err.println("OpenGL viewer could not be initialized.");
            this.viewer = this.softwareViewer;
        }
        this.setViewer(this.viewer);
        this.setViewerSize(new Dimension(640, 400));
        this.pack();
        if (this.viewer instanceof Viewer) {
            Invoke.andWait(new Runnable(){

                public void run() {
                    try {
                        ((Viewer)ViewerFrame.this.viewer).run();
                        System.err.println("OpenGL okay!");
                    }
                    catch (GLException ex) {
                        System.err.println("OpenGL viewer could not render.");
                        ViewerFrame.this.setViewer((de.jreality.scene.Viewer)ViewerFrame.this.softwareViewer);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        this.renderTrigger.addSceneGraphComponent(this.rootNode);
    }

    private void setupToolSystem(de.jreality.scene.Viewer viewer, SceneGraphPath emptyPickPath) {
        ToolSystem ts = ToolSystem.toolSystemForViewer((de.jreality.scene.Viewer)viewer);
        ts.initializeSceneTools();
        ts.setEmptyPickPath(emptyPickPath);
    }

    public Component getViewingComponent() {
        return (Component)this.viewer.getViewingComponent();
    }

    public void setLight(String name, Light light, Transformation t) {
        SceneGraphComponent node;
        if (!this.lights.containsKey(name)) {
            node = new SceneGraphComponent();
            this.lights.put(name, node);
            this.lightNode.addChild(node);
        }
        node = this.lights.get(name);
        node.setLight(light);
        node.setTransformation(t);
    }

    public void removeLight(String name) {
        SceneGraphComponent node = this.lights.get(name);
        if (node != null) {
            this.lightNode.removeChild(node);
        }
        this.lights.remove(name);
    }

    public void startRendering() {
        this.renderTrigger.finishCollect();
    }

    public void pauseRendering() {
        this.renderTrigger.startCollect();
    }

    public void encompass() {
        ToolSystem ts = ToolSystem.toolSystemForViewer((de.jreality.scene.Viewer)this.viewer);
        SceneGraphPath avatarPath = ts.getAvatarPath();
        SceneGraphPath scenePath = ts.getEmptyPickPath();
        SceneGraphPath cameraPath = this.viewer.getCameraPath();
        double aspectRatio = CameraUtility.getAspectRatio((de.jreality.scene.Viewer)this.viewer);
        Matrix toAvatar = new Matrix();
        scenePath.getMatrix(toAvatar.getArray(), 0, scenePath.getLength() - 2);
        toAvatar.multiplyOnRight(avatarPath.getInverseMatrix(null));
        Rectangle3D bounds = GeometryUtility.calculateBoundingBox((double[])toAvatar.getArray(), (SceneGraphComponent)scenePath.getLastComponent());
        if (bounds.isEmpty()) {
            return;
        }
        Camera camera = (Camera)cameraPath.getLastElement();
        Rectangle2D vp = CameraUtility.getViewport((Camera)camera, (double)aspectRatio);
        double[] e = bounds.getExtent();
        double radius = Math.sqrt(e[0] * e[0] + e[2] * e[2] + e[1] * e[1]) / 2.0;
        double front = e[2] / 2.0;
        double xscale = e[0] / vp.getWidth();
        double yscale = e[1] / vp.getHeight();
        double camdist = Math.max(xscale, yscale) * 1.1;
        if (!camera.isPerspective()) {
            camera.setFocus(camdist *= camera.getFocus());
        }
        double[] c = bounds.getCenter();
        c[2] = c[2] + (front + camdist);
        camera.setFar(camdist + front + 5.0 * radius);
        camera.setNear(0.1 * camdist);
        this.lastCenter = null;
        Matrix camMatrix = new Matrix();
        cameraPath.getInverseMatrix(camMatrix.getArray(), avatarPath.getLength());
        SceneGraphComponent avatar = avatarPath.getLastComponent();
        Matrix m = new Matrix(avatar.getTransformation());
        MatrixBuilder.euclidean((Matrix)m).translate(c).translate(camMatrix.getColumn(3)).assignTo(avatar);
    }

    public void rotateScene(double[] axis, double angle) {
        SceneGraphComponent root = this.contentNode;
        if (this.lastCenter == null) {
            Rectangle3D bounds = GeometryUtility.calculateBoundingBox((SceneGraphComponent)root);
            if (bounds.isEmpty()) {
                return;
            }
            this.lastCenter = new Matrix(root.getTransformation()).getInverse().multiplyVector(bounds.getCenter());
        }
        Matrix tOld = new Matrix(root.getTransformation());
        Matrix tNew = MatrixBuilder.euclidean().rotate(angle, axis).times(tOld).getMatrix();
        double[] p = tOld.multiplyVector(this.lastCenter);
        double[] q = tNew.multiplyVector(this.lastCenter);
        MatrixBuilder.euclidean().translateFromTo(q, p).times(tNew).assignTo(root);
    }

    public void screenshot(Dimension size, int antialias, File file) {
        int width = size.width;
        int height = size.height;
        BufferedImage img = this.softwareViewer.renderOffscreen(width * antialias, height * antialias);
        BufferedImage scaledImg = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)scaledImg.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        scaledImg.getGraphics().drawImage(img.getScaledInstance(width, height, 4), 0, 0, null);
        ImageUtility.writeBufferedImage((File)file, (BufferedImage)scaledImg);
    }

    public de.jreality.scene.Viewer getViewer() {
        return this.viewer;
    }

    public void setViewer(de.jreality.scene.Viewer viewer) {
        Dimension d = this.getViewerSize();
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)viewer.getViewingComponent());
        this.renderTrigger.removeViewer(this.viewer);
        this.renderTrigger.addViewer(viewer);
        this.viewer = viewer;
        this.setViewerSize(d);
    }

    public Dimension getViewerSize() {
        if (this.viewer == null) {
            return new Dimension(0, 0);
        }
        return this.viewer.getViewingComponentSize();
    }

    public void setViewerSize(Dimension newSize) {
        ((Component)this.viewer.getViewingComponent()).setPreferredSize(newSize);
        this.pack();
    }

    public static void main(String[] args) {
        SceneGraphComponent content = new SceneGraphComponent();
        IndexedFaceSet ifs = Primitives.icosahedron();
        content.setGeometry((Geometry)ifs);
        ViewerFrame frame = new ViewerFrame(content);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                System.exit(0);
            }
        });
        frame.setJMenuBar(new JMenuBar());
        frame.getJMenuBar().add(new JMenu("File"));
        DirectionalLight l1 = new DirectionalLight();
        l1.setIntensity(0.8);
        Transformation t1 = new Transformation();
        MatrixBuilder.euclidean().rotateX(ViewerFrame.degrees(-30.0)).rotateY(ViewerFrame.degrees(-30.0)).assignTo(t1);
        frame.setLight("Main Light", (Light)l1, t1);
        DirectionalLight l2 = new DirectionalLight();
        l2.setIntensity(0.2);
        Transformation t2 = new Transformation();
        MatrixBuilder.euclidean().rotateX(ViewerFrame.degrees(10.0)).rotateY(ViewerFrame.degrees(20.0)).assignTo(t2);
        frame.setLight("Fill Light", (Light)l2, t2);
        frame.validate();
        frame.setVisible(true);
        frame.startRendering();
        frame.setViewerSize(new Dimension(800, 600));
    }

    private static double degrees(double d) {
        return d / 180.0 * Math.PI;
    }
}

