/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.IndexedContainerDelegate;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

public class ColumnContainer
extends WidgetContainer {
    private ArrayList<Widget> child;
    private ArrayList<LayoutInfo> childLayout;
    private LayoutInfo defaultLayout;

    public ColumnContainer() {
        this.component = new WidgetContainerPanel(this);
        this.child = new ArrayList();
        this.childLayout = new ArrayList();
        this.defaultLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
    }

    @Override
    public JPanel getComponent() {
        return (JPanel)this.component;
    }

    @Override
    public int getChildCount() {
        return this.child.size();
    }

    public Widget getChild(int n) {
        return this.child.get(n);
    }

    @Override
    public Collection<Widget> getChildren() {
        return new ArrayList<Widget>(this.child);
    }

    @Override
    public void layoutChildren() {
        Dimension dimension = this.getComponent().getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, 0);
        for (int i = 0; i < this.child.size(); ++i) {
            Widget widget = this.child.get(i);
            LayoutInfo layoutInfo = this.childLayout.get(i);
            if (layoutInfo == null) {
                layoutInfo = this.defaultLayout;
            }
            Dimension dimension2 = layoutInfo.getPreferredSize(widget);
            rectangle.height = dimension2.height;
            widget.getComponent().setBounds(layoutInfo.getWidgetLayout(widget, rectangle));
            if (widget instanceof WidgetContainer) {
                ((WidgetContainer)widget).layoutChildren();
            }
            rectangle.y += dimension2.height;
        }
    }

    public void add(Widget widget) {
        this.add(widget, null);
    }

    public void add(Widget widget, LayoutInfo layoutInfo) {
        this.add(widget, widget.getParent() == this ? this.getChildCount() - 1 : this.getChildCount(), layoutInfo);
    }

    public void add(Widget widget, int n, LayoutInfo layoutInfo) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child.add(n, widget);
        this.childLayout.add(n, layoutInfo);
        this.getComponent().add(widget.getComponent(), n);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(int n) {
        return this.childLayout.get(n);
    }

    public void setChildLayout(int n, LayoutInfo layoutInfo) {
        this.childLayout.set(n, layoutInfo);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Widget widget) {
        int n = this.child.indexOf(widget);
        if (n == -1) {
            return null;
        }
        return this.childLayout.get(n);
    }

    public void setChildLayout(Widget widget, LayoutInfo layoutInfo) {
        int n = this.child.indexOf(widget);
        if (n == -1) {
            return;
        }
        this.childLayout.set(n, layoutInfo);
        this.invalidateSize();
    }

    public LayoutInfo getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(LayoutInfo layoutInfo) {
        this.defaultLayout = layoutInfo;
        this.invalidateSize();
    }

    @Override
    public void remove(Widget widget) {
        int n = this.child.indexOf(widget);
        if (n > -1) {
            this.remove(n);
        }
    }

    public void remove(int n) {
        Widget widget = this.child.get(n);
        this.getComponent().remove(widget.getComponent());
        this.child.remove(n);
        this.childLayout.remove(n);
        this.removeAsParent(widget);
        this.invalidateSize();
    }

    @Override
    public void removeAll() {
        this.getComponent().removeAll();
        for (int i = 0; i < this.child.size(); ++i) {
            this.removeAsParent(this.child.get(i));
        }
        this.child.clear();
        this.childLayout.clear();
        this.invalidateSize();
    }

    public int getChildIndex(Widget widget) {
        return this.child.indexOf(widget);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < this.child.size(); ++i) {
            Dimension dimension2 = this.child.get(i).getMinimumSize();
            dimension.height += dimension2.height;
            if (dimension.width >= dimension2.width) continue;
            dimension.width = dimension2.width;
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < this.child.size(); ++i) {
            Widget widget = this.child.get(i);
            LayoutInfo layoutInfo = this.childLayout.get(i);
            if (layoutInfo == null) {
                layoutInfo = this.defaultLayout;
            }
            Dimension dimension2 = layoutInfo.getPreferredSize(widget);
            dimension.height += dimension2.height;
            if (dimension.width >= dimension2.width) continue;
            dimension.width = dimension2.width;
        }
        return dimension;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(ColumnContainer.class, new IndexedContainerDelegate(new String[]{"getChild", "getChildLayout"}));
    }
}

