/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.BorderContainerDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;

public class BorderContainer
extends WidgetContainer {
    private Widget[] child;
    private LayoutInfo[] childLayout;
    private LayoutInfo defaultLayout;
    private boolean cornersVertical;
    public static final Position CENTER = new Position(0);
    public static final Position NORTH = new Position(1);
    public static final Position EAST = new Position(2);
    public static final Position SOUTH = new Position(3);
    public static final Position WEST = new Position(4);
    private static final Position[] ALL_POSITIONS = new Position[]{CENTER, NORTH, EAST, SOUTH, WEST};

    public BorderContainer() {
        this.component = new WidgetContainerPanel(this);
        this.child = new Widget[5];
        this.childLayout = new LayoutInfo[5];
        this.defaultLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null);
    }

    @Override
    public JPanel getComponent() {
        return (JPanel)this.component;
    }

    @Override
    public int getChildCount() {
        int n = 0;
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Collection<Widget> getChildren() {
        ArrayList<Widget> arrayList = new ArrayList<Widget>(5);
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] == null) continue;
            arrayList.add(this.child[i]);
        }
        return arrayList;
    }

    public Widget getChild(Position position) {
        return this.child[position.value];
    }

    public Position getChildPosition(Widget widget) {
        for (int i = 0; i < ALL_POSITIONS.length; ++i) {
            if (this.child[BorderContainer.ALL_POSITIONS[i].value] != widget) continue;
            return ALL_POSITIONS[i];
        }
        return null;
    }

    @Override
    public void layoutChildren() {
        int n;
        Dimension dimension = this.getComponent().getSize();
        Rectangle[] rectangleArray = new Rectangle[5];
        Dimension[] dimensionArray = new Dimension[5];
        for (n = 0; n < this.child.length; ++n) {
            rectangleArray[n] = new Rectangle();
            dimensionArray[n] = this.child[n] == null || n == BorderContainer.CENTER.value ? new Dimension() : (this.childLayout[n] == null ? this.defaultLayout.getPreferredSize(this.child[n]) : this.childLayout[n].getPreferredSize(this.child[n]));
        }
        rectangleArray[BorderContainer.WEST.value].width = dimensionArray[BorderContainer.WEST.value].width;
        rectangleArray[BorderContainer.EAST.value].width = dimensionArray[BorderContainer.EAST.value].width;
        rectangleArray[BorderContainer.EAST.value].x = dimension.width - rectangleArray[BorderContainer.EAST.value].width;
        rectangleArray[BorderContainer.NORTH.value].height = dimensionArray[BorderContainer.NORTH.value].height;
        rectangleArray[BorderContainer.SOUTH.value].height = dimensionArray[BorderContainer.SOUTH.value].height;
        rectangleArray[BorderContainer.SOUTH.value].y = dimension.height - rectangleArray[BorderContainer.SOUTH.value].height;
        if (this.cornersVertical) {
            rectangleArray[BorderContainer.WEST.value].height = rectangleArray[BorderContainer.EAST.value].height = dimension.height;
            rectangleArray[BorderContainer.NORTH.value].x = rectangleArray[BorderContainer.SOUTH.value].x = rectangleArray[BorderContainer.WEST.value].width;
            rectangleArray[BorderContainer.NORTH.value].width = rectangleArray[BorderContainer.SOUTH.value].width = rectangleArray[BorderContainer.EAST.value].x - rectangleArray[BorderContainer.NORTH.value].x;
        } else {
            rectangleArray[BorderContainer.NORTH.value].width = rectangleArray[BorderContainer.SOUTH.value].width = dimension.width;
            rectangleArray[BorderContainer.WEST.value].y = rectangleArray[BorderContainer.EAST.value].y = rectangleArray[BorderContainer.NORTH.value].height;
            rectangleArray[BorderContainer.WEST.value].height = rectangleArray[BorderContainer.EAST.value].height = rectangleArray[BorderContainer.SOUTH.value].y - rectangleArray[BorderContainer.WEST.value].y;
        }
        rectangleArray[BorderContainer.CENTER.value].x = rectangleArray[BorderContainer.WEST.value].width;
        rectangleArray[BorderContainer.CENTER.value].y = rectangleArray[BorderContainer.NORTH.value].height;
        rectangleArray[BorderContainer.CENTER.value].width = rectangleArray[BorderContainer.EAST.value].x - rectangleArray[BorderContainer.CENTER.value].x;
        rectangleArray[BorderContainer.CENTER.value].height = rectangleArray[BorderContainer.SOUTH.value].y - rectangleArray[BorderContainer.CENTER.value].y;
        for (n = 0; n < 5; ++n) {
            if (this.child[n] == null) continue;
            LayoutInfo layoutInfo = this.childLayout[n] == null ? this.defaultLayout : this.childLayout[n];
            this.child[n].getComponent().setBounds(layoutInfo.getWidgetLayout(this.child[n], rectangleArray[n]));
            if (!(this.child[n] instanceof WidgetContainer)) continue;
            ((WidgetContainer)this.child[n]).layoutChildren();
        }
    }

    public void add(Widget widget, Position position) {
        this.add(widget, position, null);
    }

    public void add(Widget widget, Position position, LayoutInfo layoutInfo) {
        if (this.child[position.value] != null) {
            this.remove(position);
        }
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child[position.value] = widget;
        this.childLayout[position.value] = layoutInfo;
        this.getComponent().add(widget.getComponent());
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Position position) {
        return this.childLayout[position.value];
    }

    public void setChildLayout(Position position, LayoutInfo layoutInfo) {
        this.childLayout[position.value] = layoutInfo;
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != widget) continue;
            return this.childLayout[i];
        }
        return null;
    }

    public void setChildLayout(Widget widget, LayoutInfo layoutInfo) {
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != widget) continue;
            this.childLayout[i] = layoutInfo;
            return;
        }
        this.invalidateSize();
    }

    public LayoutInfo getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(LayoutInfo layoutInfo) {
        this.defaultLayout = layoutInfo;
        this.invalidateSize();
    }

    @Override
    public void remove(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != widget) continue;
            this.remove(i);
            return;
        }
    }

    public void remove(Position position) {
        this.remove(position.value);
    }

    private void remove(int n) {
        if (this.child[n] == null) {
            return;
        }
        this.getComponent().remove(this.child[n].getComponent());
        this.removeAsParent(this.child[n]);
        this.child[n] = null;
        this.childLayout[n] = null;
        this.invalidateSize();
    }

    @Override
    public void removeAll() {
        for (int i = 0; i < this.child.length; ++i) {
            this.remove(i);
        }
    }

    public boolean getCornersAreVertical() {
        return this.cornersVertical;
    }

    public void setCornersAreVertical(boolean bl) {
        this.cornersVertical = bl;
        this.invalidateSize();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension;
        Dimension dimension2 = dimension = this.child[BorderContainer.CENTER.value] == null ? new Dimension() : this.child[BorderContainer.CENTER.value].getMinimumSize();
        if (this.cornersVertical) {
            Dimension dimension3;
            if (this.child[BorderContainer.NORTH.value] != null) {
                dimension3 = this.child[BorderContainer.NORTH.value].getMinimumSize();
                dimension.height += dimension3.height;
                if (dimension.width < dimension3.width) {
                    dimension.width = dimension3.width;
                }
            }
            if (this.child[BorderContainer.SOUTH.value] != null) {
                dimension3 = this.child[BorderContainer.SOUTH.value].getMinimumSize();
                dimension.height += dimension3.height;
                if (dimension.width < dimension3.width) {
                    dimension.width = dimension3.width;
                }
            }
            if (this.child[BorderContainer.EAST.value] != null) {
                dimension3 = this.child[BorderContainer.EAST.value].getMinimumSize();
                dimension.width += dimension3.width;
                if (dimension.height < dimension3.height) {
                    dimension.height = dimension3.height;
                }
            }
            if (this.child[BorderContainer.WEST.value] != null) {
                dimension3 = this.child[BorderContainer.WEST.value].getMinimumSize();
                dimension.width += dimension3.width;
                if (dimension.height < dimension3.height) {
                    dimension.height = dimension3.height;
                }
            }
        } else {
            Dimension dimension4;
            if (this.child[BorderContainer.EAST.value] != null) {
                dimension4 = this.child[BorderContainer.EAST.value].getMinimumSize();
                dimension.width += dimension4.width;
                if (dimension.height < dimension4.height) {
                    dimension.height = dimension4.height;
                }
            }
            if (this.child[BorderContainer.WEST.value] != null) {
                dimension4 = this.child[BorderContainer.WEST.value].getMinimumSize();
                dimension.width += dimension4.width;
                if (dimension.height < dimension4.height) {
                    dimension.height = dimension4.height;
                }
            }
            if (this.child[BorderContainer.NORTH.value] != null) {
                dimension4 = this.child[BorderContainer.NORTH.value].getMinimumSize();
                dimension.height += dimension4.height;
                if (dimension.width < dimension4.width) {
                    dimension.width = dimension4.width;
                }
            }
            if (this.child[BorderContainer.SOUTH.value] != null) {
                dimension4 = this.child[BorderContainer.SOUTH.value].getMinimumSize();
                dimension.height += dimension4.height;
                if (dimension.width < dimension4.width) {
                    dimension.width = dimension4.width;
                }
            }
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = this.child[BorderContainer.CENTER.value] == null ? new Dimension() : (this.childLayout[BorderContainer.CENTER.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.CENTER.value]) : this.childLayout[BorderContainer.CENTER.value].getPreferredSize(this.child[BorderContainer.CENTER.value]));
        if (this.cornersVertical) {
            Dimension dimension2;
            if (this.child[BorderContainer.NORTH.value] != null) {
                dimension2 = this.childLayout[BorderContainer.NORTH.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.NORTH.value]) : this.childLayout[BorderContainer.NORTH.value].getPreferredSize(this.child[BorderContainer.NORTH.value]);
                dimension.height += dimension2.height;
                if (dimension.width < dimension2.width) {
                    dimension.width = dimension2.width;
                }
            }
            if (this.child[BorderContainer.SOUTH.value] != null) {
                dimension2 = this.childLayout[BorderContainer.SOUTH.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.SOUTH.value]) : this.childLayout[BorderContainer.SOUTH.value].getPreferredSize(this.child[BorderContainer.SOUTH.value]);
                dimension.height += dimension2.height;
                if (dimension.width < dimension2.width) {
                    dimension.width = dimension2.width;
                }
            }
            if (this.child[BorderContainer.EAST.value] != null) {
                dimension2 = this.childLayout[BorderContainer.EAST.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.EAST.value]) : this.childLayout[BorderContainer.EAST.value].getPreferredSize(this.child[BorderContainer.EAST.value]);
                dimension.width += dimension2.width;
                if (dimension.height < dimension2.height) {
                    dimension.height = dimension2.height;
                }
            }
            if (this.child[BorderContainer.WEST.value] != null) {
                dimension2 = this.childLayout[BorderContainer.WEST.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.WEST.value]) : this.childLayout[BorderContainer.WEST.value].getPreferredSize(this.child[BorderContainer.WEST.value]);
                dimension.width += dimension2.width;
                if (dimension.height < dimension2.height) {
                    dimension.height = dimension2.height;
                }
            }
        } else {
            Dimension dimension3;
            if (this.child[BorderContainer.EAST.value] != null) {
                dimension3 = this.childLayout[BorderContainer.EAST.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.EAST.value]) : this.childLayout[BorderContainer.EAST.value].getPreferredSize(this.child[BorderContainer.EAST.value]);
                dimension.width += dimension3.width;
                if (dimension.height < dimension3.height) {
                    dimension.height = dimension3.height;
                }
            }
            if (this.child[BorderContainer.WEST.value] != null) {
                dimension3 = this.childLayout[BorderContainer.WEST.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.WEST.value]) : this.childLayout[BorderContainer.WEST.value].getPreferredSize(this.child[BorderContainer.WEST.value]);
                dimension.width += dimension3.width;
                if (dimension.height < dimension3.height) {
                    dimension.height = dimension3.height;
                }
            }
            if (this.child[BorderContainer.NORTH.value] != null) {
                dimension3 = this.childLayout[BorderContainer.NORTH.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.NORTH.value]) : this.childLayout[BorderContainer.NORTH.value].getPreferredSize(this.child[BorderContainer.NORTH.value]);
                dimension.height += dimension3.height;
                if (dimension.width < dimension3.width) {
                    dimension.width = dimension3.width;
                }
            }
            if (this.child[BorderContainer.SOUTH.value] != null) {
                dimension3 = this.childLayout[BorderContainer.SOUTH.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.SOUTH.value]) : this.childLayout[BorderContainer.SOUTH.value].getPreferredSize(this.child[BorderContainer.SOUTH.value]);
                dimension.height += dimension3.height;
                if (dimension.width < dimension3.width) {
                    dimension.width = dimension3.width;
                }
            }
        }
        return dimension;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BorderContainer.class, new BorderContainerDelegate());
        WidgetEncoder.setPersistenceDelegate(Position.class, new StaticFieldDelegate(BorderContainer.class));
    }

    public static class Position {
        protected int value;

        private Position(int n) {
            this.value = n;
        }
    }
}

