"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceShare = exports.ResourceShareProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const resourcemanager_generated_1 = require("./resourcemanager.generated");
Object.defineProperty(exports, "ResourceShareProperty", { enumerable: true, get: function () { return resourcemanager_generated_1.RosResourceShare; } });
/**
 * A ROS resource type:  `ALIYUN::ResourceManager::ResourceShare`
 */
class ResourceShare extends ros.Resource {
    /**
     * Create a new `ALIYUN::ResourceManager::ResourceShare`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosResourceShare = new resourcemanager_generated_1.RosResourceShare(this, id, {
            resourceShareName: props.resourceShareName,
            targets: props.targets,
            resources: props.resources,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosResourceShare;
        this.attrResourceShareId = rosResourceShare.attrResourceShareId;
    }
}
exports.ResourceShare = ResourceShare;
//# sourceMappingURL=data:application/json;base64,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