"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunnerVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines desired GitHub Actions runner version.
 */
class RunnerVersion {
    constructor(version) {
        this.version = version;
    }
    /**
     * Use the latest version available at the time the runner provider image is built.
     */
    static latest() {
        return new RunnerVersion('latest');
    }
    /**
     * Use a specific version.
     *
     * @see https://github.com/actions/runner/releases
     *
     * @param version GitHub Runner version
     */
    static specific(version) {
        return new RunnerVersion(version);
    }
}
exports.RunnerVersion = RunnerVersion;
_a = JSII_RTTI_SYMBOL_1;
RunnerVersion[_a] = { fqn: "@cloudsnorkel/cdk-github-runners.RunnerVersion", version: "0.0.14" };
//# sourceMappingURL=data:application/json;base64,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