from dataclasses import dataclass
from pollination_dsl.function import Function, command, Inputs, Outputs


@dataclass
class TimeStepData(Function):
    """Write a time step data JSON file to be consumed by the TimeStepImages."""

    time_step_file = Inputs.file(
        description='A file generated by an annual recipe that has all the time steps.'
        ' an example of such a file is sun-up-hours.txt generated by the'
        ' direct-sun-hours recipe.',
        path='time_step_file.txt'
    )

    periods_file = Inputs.file(
        description='A file that contains the periods and color associated with each'
        ' period.',
        path='periods.json'
    )

    @command
    def time_step_data(self):
        return 'honeybee-vtk config time-step-data'\
            ' --time-step-file time_step_file.txt --periods-file periods.json'\
            ' --file-name _time_step_data'

    output_file = Outputs.file(
        description='Created file.',
        path='_time_step_data.json'
    )
