/*
 * Decompiled with CFR 0.152.
 */
package variables.domains;

import java.util.stream.IntStream;
import utility.exceptions.MissingImplementationException;
import variables.Variable;
import variables.domains.DomainHuge;

public final class DomainHugeBounded
extends DomainHuge {
    private static final int ASSIGNED = -3;
    private static final int UNITIALIZED = -2;
    private int currValue;
    private int[] limits;
    private int lastDeletedLevel;
    private boolean singleton;

    @Override
    public void finalizeConstructionWith(int nLevels) {
        this.limits = IntStream.range(0, nLevels).map(i -> -2).toArray();
    }

    public DomainHugeBounded(Variable var, int firstValue, int lastValue) {
        super(var, firstValue, lastValue);
        this.currValue = firstValue;
        this.lastDeletedLevel = -1;
    }

    @Override
    public int toIdx(int v) {
        return v - this.firstValue;
    }

    @Override
    public int toVal(int a) {
        return a + this.firstValue;
    }

    @Override
    public int initSize() {
        return this.lastValue - this.firstValue + 1;
    }

    @Override
    public int size() {
        return this.singleton ? 1 : this.lastValue - this.currValue + 1;
    }

    @Override
    public boolean isPresent(int a) {
        assert (0 <= a && a <= this.last());
        return this.singleton ? a == this.currValue - this.firstValue : a >= this.currValue - this.firstValue;
    }

    @Override
    public int first() {
        assert (this.size() > 0);
        return this.currValue - this.firstValue;
    }

    @Override
    public int next(int a) {
        assert (this.first() <= a && a <= this.last());
        return this.singleton || a == this.lastValue - this.firstValue ? -1 : a + 1;
    }

    @Override
    public int last() {
        assert (this.size() > 0);
        return this.singleton ? this.first() : this.lastValue - this.firstValue;
    }

    @Override
    public int prev(int a) {
        assert (this.first() <= a && a <= this.last());
        return this.singleton || a == this.currValue - this.firstValue ? -1 : a - 1;
    }

    @Override
    public int get(int i) {
        assert (0 <= i && i < this.size());
        return this.currValue - this.firstValue + i;
    }

    @Override
    public int lastRemoved() {
        return this.currValue - this.firstValue - 1;
    }

    @Override
    public int prevRemoved(int a) {
        assert (0 <= a && a < this.first());
        return a - 1;
    }

    @Override
    public int lastRemovedLevel() {
        return this.lastDeletedLevel;
    }

    @Override
    public boolean isRemovedAtLevel(int a, int level) {
        assert (0 <= a && a < this.first());
        int right = this.limits[level];
        if (right == -2 || a < right - this.firstValue) {
            return false;
        }
        int left = -1;
        for (int j = level + 1; left == -1 && j <= this.lastDeletedLevel; ++j) {
            if (this.limits[j] == -2) continue;
            left = this.limits[j];
        }
        if (left == -1) {
            left = this.currValue;
        }
        return a < left - this.firstValue;
    }

    @Override
    public int getRemovedLevelOf(int a) {
        throw new MissingImplementationException();
    }

    @Override
    public void remove(int a, int level) {
        assert (level >= 0 && a + this.firstValue == this.currValue && !this.singleton) : "level = " + level + " present element = " + a;
        if (this.limits[level] == -2) {
            this.limits[level] = this.currValue;
            this.lastDeletedLevel = level;
        }
        ++this.currValue;
    }

    @Override
    public int reduceTo(int a, int level) {
        assert (level >= 0 && a + this.firstValue == this.currValue && !this.singleton);
        if (this.currValue == this.lastValue) {
            return 0;
        }
        if (this.limits[level] == -2) {
            this.limits[level] = -3;
            this.singleton = true;
            this.lastDeletedLevel = level;
        }
        return this.lastValue - this.currValue;
    }

    @Override
    public void restoreBefore(int level) {
        int i;
        if (this.limits[level] == -2) {
            return;
        }
        assert (this.currValue > this.limits[level] && this.lastDeletedLevel == level);
        if (this.limits[level] == -3) {
            this.singleton = false;
        } else {
            this.currValue = this.limits[level];
        }
        this.limits[level] = -2;
        for (i = level - 1; i >= 0 && this.limits[i] == -2; --i) {
        }
        this.lastDeletedLevel = i;
    }

    @Override
    public Object allValues() {
        throw new MissingImplementationException();
    }
}

