/*
 * Decompiled with CFR 0.152.
 */
package variables.domains;

import search.Solver;
import utility.exceptions.UnreachableCodeException;
import variables.Variable;
import variables.domains.Domain;

public abstract class DomainHuge
implements Domain {
    protected Variable var;
    protected Integer typeIdentifier;
    protected Solver solver;
    protected int firstValue;
    protected int lastValue;

    @Override
    public final Variable var() {
        return this.var;
    }

    @Override
    public final int typeIdentifier() {
        return this.typeIdentifier != null ? this.typeIdentifier : (this.typeIdentifier = Integer.valueOf(this.typeIdentifierFor(new int[]{-1, -1, this.firstValue, this.lastValue})));
    }

    @Override
    public final Solver solver() {
        return this.solver;
    }

    @Override
    public final void setSolver(Solver solver) {
        this.solver = solver;
    }

    @Override
    public boolean indexesMatchValues() {
        return this.firstValue == 0;
    }

    public DomainHuge(Variable var, int firstValue, int lastValue) {
        this.var = var;
        this.firstValue = firstValue;
        this.lastValue = lastValue;
    }

    @Override
    public int toIdx(int v) {
        return v - this.firstValue;
    }

    @Override
    public int toVal(int a) {
        return a + this.firstValue;
    }

    @Override
    public int initSize() {
        return this.lastValue - this.firstValue + 1;
    }

    @Override
    public void setMark() {
        throw new UnreachableCodeException();
    }

    @Override
    public void setMark(int level) {
        throw new UnreachableCodeException();
    }

    @Override
    public void restoreAtMark() {
        throw new UnreachableCodeException();
    }

    @Override
    public void restoreAtMark(int level) {
        throw new UnreachableCodeException();
    }

    @Override
    public int indexAtMark() {
        throw new UnreachableCodeException();
    }

    @Override
    public long[] binaryRepresentation() {
        throw new UnreachableCodeException();
    }

    @Override
    public int[] indexes() {
        throw new UnreachableCodeException();
    }

    @Override
    public boolean controlStructures() {
        return true;
    }

    public String toString() {
        return "dom(" + this.var().id() + ")";
    }
}

