/*
 * Decompiled with CFR 0.152.
 */
package utility.sets;

import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import utility.sets.LinkedSet;

public class SetDense {
    public static final int INCREASE_RATIO = 2;
    public static final int UNINITIALIZED = -2;
    public int[] dense;
    public int limit;
    protected int mark = -2;

    public SetDense(int[] dense, boolean initiallyFull) {
        assert (!initiallyFull || IntStream.range(0, dense.length).allMatch(i -> IntStream.range(i + 1, dense.length).allMatch(j -> dense[i] != dense[j])));
        this.dense = dense;
        this.limit = initiallyFull ? dense.length - 1 : -1;
    }

    public SetDense(int capacity, boolean initiallyFull) {
        this(IntStream.range(0, capacity).toArray(), initiallyFull);
    }

    public SetDense(int capacity) {
        this(capacity, false);
    }

    public final int first() {
        assert (this.limit >= 0);
        return this.dense[0];
    }

    public final int last() {
        assert (this.limit >= 0);
        return this.dense[this.limit];
    }

    public final int capacity() {
        return this.dense.length;
    }

    public final int size() {
        return this.limit + 1;
    }

    public final int free() {
        return this.dense.length - this.limit - 1;
    }

    public final int sizeSuchThat(Predicate<Integer> p) {
        return (int)IntStream.rangeClosed(0, this.limit).filter(i -> p.test(this.dense[i])).count();
    }

    public final boolean isEmpty() {
        return this.limit == -1;
    }

    public final boolean isFull() {
        return this.limit == this.dense.length - 1;
    }

    public final void setMark() {
        assert (this.mark == -2);
        this.mark = this.limit;
    }

    public final void restoreAtMark() {
        assert (this.mark != -2);
        this.limit = this.mark;
        this.mark = -2;
    }

    public void increaseCapacity() {
        this.dense = IntStream.range(0, this.capacity() * 2).map(i -> i < this.dense.length ? this.dense[i] : i).toArray();
    }

    public void clear() {
        this.limit = -1;
    }

    public boolean isPresent(int e) {
        for (int i = 0; i <= this.limit; ++i) {
            if (this.dense[i] != e) continue;
            return true;
        }
        return false;
    }

    public boolean add(int e) {
        assert (!this.isPresent(e));
        this.dense[++this.limit] = e;
        return true;
    }

    public void resetTo(int e) {
        this.clear();
        this.add(e);
    }

    public void resetTo(int[] elements, int nb) {
        this.clear();
        for (int i = 0; i < nb; ++i) {
            this.add(elements[i]);
        }
    }

    public final void resetTo(LinkedSet set) {
        assert (set.size() <= this.capacity());
        this.clear();
        int e = set.first();
        while (e != -1) {
            this.add(e);
            e = set.next(e);
        }
    }

    public void removeAtPosition(int i) {
        assert (0 <= i && i <= this.limit);
        int e = this.dense[i];
        this.dense[i] = this.dense[this.limit];
        this.dense[this.limit] = e;
        --this.limit;
    }

    public int shift() {
        assert (this.limit >= 0);
        int e = this.dense[0];
        this.dense[0] = this.dense[this.limit];
        this.dense[this.limit] = e;
        --this.limit;
        return e;
    }

    public int pop() {
        assert (this.limit >= 0);
        --this.limit;
        return this.dense[this.limit + 1];
    }

    public void swapAtPositions(int i, int j) {
        int e = this.dense[i];
        this.dense[i] = this.dense[j];
        this.dense[j] = e;
    }

    public String toString() {
        return "dense={" + IntStream.range(0, this.size()).mapToObj(i -> this.dense[i] + "").collect(Collectors.joining(",")) + "}";
    }

    public static void main(String[] args) {
        int mode = Integer.parseInt(args[0]);
        int nValues = Integer.parseInt(args[1]);
        int nIterations = Integer.parseInt(args[2]);
        SetDense set = new SetDense(nValues, true);
        if (mode == 1) {
            for (int cnt = 0; cnt < nIterations; ++cnt) {
                for (int i = set.limit; i >= 0; --i) {
                    int x = set.dense[i];
                    ++x;
                }
            }
        }
        if (mode == 2) {
            int[] dense = set.dense;
            for (int cnt = 0; cnt < nIterations; ++cnt) {
                for (int i = set.limit; i >= 0; --i) {
                    int x = dense[i];
                    ++x;
                }
            }
        }
        System.out.println(set.dense[0] + " " + set.dense[1]);
    }
}

