/*
 * Decompiled with CFR 0.152.
 */
package utility.sets;

import java.util.Arrays;
import utility.Kit;
import utility.operations.Bit;
import utility.sets.LinkedSet;
import utility.sets.SetSparse;

public class LinkedSetOrdered
implements LinkedSet {
    protected int size;
    protected int first;
    protected int last;
    protected int[] prevs;
    protected int[] nexts;
    protected int lastRemoved;
    protected int[] prevRemoved;
    protected int[] removedLevels;
    protected int mark;
    protected int[] marks;
    protected int nLevels;

    @Override
    public void finalizeConstructionWith(int nLevels) {
        this.nLevels = nLevels;
        this.lastRemoved = -1;
    }

    public LinkedSetOrdered(int initSize) {
        Kit.control(0 < initSize && (long)initSize <= 0x7FFFFFF5L, () -> "capacity=" + initSize);
        this.size = initSize;
        this.first = 0;
        this.last = initSize - 1;
        this.prevs = Kit.range(-1, initSize - 2);
        this.nexts = Kit.range(1, initSize);
        this.nexts[initSize - 1] = -1;
        this.lastRemoved = -1;
        this.prevRemoved = Kit.repeat(-1, initSize);
        this.removedLevels = Kit.repeat(-1, initSize);
        this.mark = -1;
    }

    public LinkedSetOrdered(int initSize, int nLevels) {
        this(initSize);
        this.finalizeConstructionWith(nLevels);
    }

    @Override
    public int initSize() {
        return this.prevs.length;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean isPresent(int a) {
        return this.removedLevels[a] == -1;
    }

    @Override
    public final int first() {
        return this.first;
    }

    @Override
    public int next(int a) {
        if (this.removedLevels[a] == -1) {
            return this.nexts[a];
        }
        if (a < this.first) {
            return this.first;
        }
        int next = this.nexts[a];
        if (next == -1 || next > this.last) {
            return -1;
        }
        while (this.removedLevels[next] != -1) {
            next = this.nexts[next];
        }
        return next;
    }

    @Override
    public final int last() {
        return this.last;
    }

    @Override
    public int prev(int a) {
        if (this.removedLevels[a] == -1) {
            return this.prevs[a];
        }
        if (a > this.last) {
            return this.last;
        }
        int prev = this.prevs[a];
        if (prev < this.first) {
            return -1;
        }
        while (this.removedLevels[prev] != -1) {
            prev = this.prevs[prev];
        }
        return prev;
    }

    @Override
    public int get(int i) {
        assert (0 <= i && i < this.size());
        int e = this.first();
        for (int cnt = 0; cnt < i; ++cnt) {
            e = this.next(e);
        }
        return e;
    }

    @Override
    public int lastRemoved() {
        return this.lastRemoved;
    }

    @Override
    public int lastRemovedLevel() {
        return this.lastRemoved == -1 ? -1 : this.removedLevels[this.lastRemoved];
    }

    @Override
    public int getRemovedLevelOf(int a) {
        return this.removedLevels[a];
    }

    @Override
    public boolean isRemovedAtLevel(int a, int level) {
        return this.removedLevels[a] == level;
    }

    @Override
    public int prevRemoved(int a) {
        return this.prevRemoved[a];
    }

    protected void removeElement(int a) {
        int prev = this.prevs[a];
        int next = this.nexts[a];
        if (prev == -1) {
            this.first = next;
        } else {
            this.nexts[prev] = next;
        }
        if (next == -1) {
            this.last = prev;
        } else {
            this.prevs[next] = prev;
        }
        this.prevRemoved[a] = this.lastRemoved;
        this.lastRemoved = a;
    }

    @Override
    public void remove(int a, int level) {
        assert (this.isPresent(a) && level >= 0) : "level = " + level + " absentLevel = " + this.removedLevels[a];
        this.removedLevels[a] = level;
        --this.size;
        this.removeElement(a);
    }

    @Override
    public int reduceTo(int a, int level) {
        assert (this.isPresent(a) && level >= 0);
        int sizeBefore = this.size;
        int b = this.first;
        while (b != -1) {
            if (b != a) {
                this.remove(b, level);
            }
            b = this.next(b);
        }
        return sizeBefore - this.size;
    }

    protected void addElement(int a) {
        assert (this.lastRemoved == a);
        int prev = this.prevs[a];
        int next = this.nexts[a];
        if (prev == -1) {
            this.first = a;
        } else {
            this.nexts[prev] = a;
        }
        if (next == -1) {
            this.last = a;
        } else {
            this.prevs[next] = a;
        }
        this.lastRemoved = this.prevRemoved[a];
    }

    private void restoreLastDropped() {
        assert (this.lastRemoved != -1 && !this.isPresent(this.lastRemoved));
        this.removedLevels[this.lastRemoved] = -1;
        ++this.size;
        this.addElement(this.lastRemoved);
    }

    @Override
    public void restoreBefore(int level) {
        assert (this.lastRemoved == -1 || this.removedLevels[this.lastRemoved] <= level);
        int a = this.lastRemoved;
        while (a != -1 && this.removedLevels[a] >= level) {
            this.restoreLastDropped();
            a = this.lastRemoved;
        }
    }

    @Override
    public void setMark() {
        assert (this.mark == -1);
        this.mark = this.lastRemoved;
    }

    @Override
    public int indexAtMark() {
        return this.mark;
    }

    @Override
    public void restoreAtMark() {
        int a = this.lastRemoved;
        while (a != this.mark) {
            this.restoreLastDropped();
            a = this.lastRemoved;
        }
        this.mark = -1;
    }

    @Override
    public void setMark(int level) {
        assert (this.marks == null || this.marks[level] == -1);
        if (this.marks == null) {
            this.marks = Kit.repeat(-1, this.nLevels);
        }
        this.marks[level] = this.lastRemoved;
    }

    @Override
    public void restoreAtMark(int level) {
        int a = this.lastRemoved;
        while (a != this.marks[level]) {
            this.restoreLastDropped();
            a = this.lastRemoved;
        }
        this.marks[level] = -1;
    }

    @Override
    public long[] binaryRepresentation() {
        return null;
    }

    @Override
    public int[] indexes() {
        int[] tmp = new int[this.size];
        int i = 0;
        int a = this.first;
        while (a != -1) {
            tmp[i++] = a;
            a = this.nexts[a];
        }
        return tmp;
    }

    @Override
    public String stringOfStructures() {
        String s = LinkedSet.super.stringOfStructures();
        StringBuilder sb = new StringBuilder().append("Levels: ");
        int lastLevel = -1;
        int a = this.lastRemoved();
        while (a != -1) {
            if (this.removedLevels[a] != lastLevel) {
                sb.append(a + "@" + this.removedLevels[a] + " ");
                lastLevel = this.removedLevels[a];
            }
            a = this.prevRemoved(a);
        }
        return s + "\n" + sb.toString();
    }

    @Override
    public boolean controlStructures() {
        int cnt = 0;
        int a = this.first;
        while (a != -1) {
            if (this.removedLevels[a] != -1 || this.nexts[a] != -1 && a >= this.nexts[a]) {
                Kit.log.info("pb forward present : absent = " + this.removedLevels[a] + " i= " + a + " next = " + this.nexts[a]);
                return false;
            }
            ++cnt;
            a = this.nexts[a];
        }
        Kit.control(cnt == this.size(), () -> "pb nb elements " + this.size());
        a = this.last;
        while (a != -1) {
            if (this.removedLevels[a] != -1 || this.prevs[a] != -1 && a <= this.prevs[a]) {
                Kit.log.info("pb backward present : absent = " + this.removedLevels[a] + " i= " + a + " prev = " + this.prevs[a]);
                return false;
            }
            a = this.prevs[a];
        }
        a = this.lastRemoved;
        while (a != -1) {
            Kit.control(this.removedLevels[a] != -1, () -> "bad value of absentLevels");
            if (this.prevRemoved[a] != -1 && this.removedLevels[this.prevRemoved[a]] > this.removedLevels[a]) {
                Kit.log.info("level of " + a + " = " + this.removedLevels[a] + " level of " + this.prevRemoved[a] + " = " + this.removedLevels[this.prevRemoved[a]]);
                return false;
            }
            a = this.prevRemoved[a];
        }
        return true;
    }

    public static final class LinkedSetOrderedWithBits2
    extends LinkedSetOrderedWithBits {
        public final SetSparse sset;

        public LinkedSetOrderedWithBits2(int initSize) {
            super(initSize);
            this.sset = new SetSparse(this.binaryRepresentation.length, true);
        }

        @Override
        protected void addElement(int a) {
            super.addElement(a);
            this.sset.add(a / 64);
        }

        @Override
        protected void removeElement(int a) {
            super.removeElement(a);
            int i = a / 64;
            if (this.binaryRepresentation[i] == 0L) {
                this.sset.remove(i);
            }
        }
    }

    public static class LinkedSetOrderedWithBits
    extends LinkedSetOrdered {
        protected long[] binaryRepresentation;

        @Override
        public long[] binaryRepresentation() {
            return this.binaryRepresentation;
        }

        public LinkedSetOrderedWithBits(int initSize) {
            super(initSize);
            this.binaryRepresentation = new long[initSize / 64 + (initSize % 64 != 0 ? 1 : 0)];
            Arrays.fill(this.binaryRepresentation, -1L);
            this.binaryRepresentation[this.binaryRepresentation.length - 1] = Bit.bitsA1To(initSize - (this.binaryRepresentation.length - 1) * 64);
        }

        public LinkedSetOrderedWithBits(int initSize, int nLevels) {
            this(initSize);
        }

        @Override
        protected void addElement(int e) {
            super.addElement(e);
            int n = e / 64;
            this.binaryRepresentation[n] = this.binaryRepresentation[n] | Bit.ONE_LONG_BIT_TO_1[e % 64];
        }

        @Override
        protected void removeElement(int e) {
            super.removeElement(e);
            int n = e / 64;
            this.binaryRepresentation[n] = this.binaryRepresentation[n] & Bit.ONE_LONG_BIT_TO_0[e % 64];
        }
    }
}

