/*
 * Decompiled with CFR 0.152.
 */
package utility.sets;

import java.util.Arrays;
import utility.sets.LinkedSet;

public class LinkedSetBinary
implements LinkedSet {
    private static final long[] binaryEmpty = new long[]{0L};
    private static final long[] binaryFor0 = new long[]{1L};
    private static final long[] binaryFor1 = new long[]{2L};
    private static final long[] binaryFor01 = new long[]{3L};
    private static final int[] domainEmpty = new int[0];
    private static final int[] domainFor0 = new int[]{0};
    private static final int[] domainFor1 = new int[]{1};
    private static final int[] domainFor01 = new int[]{0, 1};
    protected byte size = (byte)2;
    protected byte lastRemoved = (byte)-1;
    protected int[] removedlevels = new int[]{-1, -1};
    protected byte mark = (byte)-1;
    protected byte[] marks;
    protected int nLevels;

    @Override
    public void finalizeConstructionWith(int nLevels) {
        this.nLevels = nLevels;
    }

    public LinkedSetBinary() {
    }

    public LinkedSetBinary(int nLevels) {
        this();
        this.finalizeConstructionWith(nLevels);
    }

    @Override
    public int initSize() {
        return 2;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public int nRemoved() {
        return 2 - this.size;
    }

    @Override
    public final boolean isPresent(int a) {
        return this.removedlevels[a] == -1;
    }

    @Override
    public int first() {
        return this.removedlevels[0] == -1 ? 0 : (this.removedlevels[1] == -1 ? 1 : -1);
    }

    @Override
    public int next(int a) {
        return a == 1 ? -1 : (this.removedlevels[1] == -1 ? 1 : -1);
    }

    @Override
    public int last() {
        return this.removedlevels[1] == -1 ? 1 : (this.removedlevels[0] == -1 ? 0 : -1);
    }

    @Override
    public int prev(int a) {
        return a == 0 ? -1 : (this.removedlevels[0] == -1 ? 0 : -1);
    }

    @Override
    public int get(int i) {
        int a = this.first();
        for (int cnt = 0; cnt < i; ++cnt) {
            a = this.next(a);
        }
        return a;
    }

    @Override
    public int lastRemoved() {
        return this.lastRemoved;
    }

    @Override
    public int lastRemovedLevel() {
        return this.lastRemoved == -1 ? -1 : this.removedlevels[this.lastRemoved];
    }

    @Override
    public int getRemovedLevelOf(int a) {
        return this.removedlevels[a];
    }

    @Override
    public boolean isRemovedAtLevel(int a, int level) {
        return this.removedlevels[a] == level;
    }

    @Override
    public int prevRemoved(int a) {
        return this.size > 0 || a != this.lastRemoved ? -1 : (this.lastRemoved == 0 ? 1 : 0);
    }

    @Override
    public void remove(int a, int level) {
        assert (level >= 0 && this.removedlevels[a] == -1) : "level = " + level + " level = " + this.removedlevels[a];
        this.removedlevels[a] = level;
        this.size = (byte)(this.size - 1);
        this.lastRemoved = (byte)a;
    }

    @Override
    public int reduceTo(int a, int level) {
        assert (this.isPresent(a) && level >= 0);
        if (this.size == 1) {
            return 0;
        }
        this.remove(a == 0 ? 1 : 0, level);
        return 1;
    }

    private void restoreLastDropped() {
        assert (this.removedlevels[this.lastRemoved] != -1);
        this.removedlevels[this.lastRemoved] = -1;
        this.size = (byte)(this.size + 1);
        this.lastRemoved = (byte)(this.size == 2 ? -1 : (byte)(this.lastRemoved == 0 ? 1 : 0));
    }

    @Override
    public void restoreBefore(int level) {
        if (this.size == 2 || this.removedlevels[this.lastRemoved] < level) {
            return;
        }
        this.restoreLastDropped();
        if (this.size == 2 || this.removedlevels[this.lastRemoved] < level) {
            return;
        }
        this.restoreLastDropped();
    }

    @Override
    public void setMark() {
        assert (this.mark == -1);
        this.mark = this.lastRemoved;
    }

    @Override
    public int indexAtMark() {
        return this.mark;
    }

    @Override
    public void restoreAtMark() {
        byte e = this.lastRemoved;
        while (e != this.mark) {
            this.restoreLastDropped();
            e = this.lastRemoved;
        }
        this.mark = (byte)-1;
    }

    @Override
    public void setMark(int level) {
        assert (this.marks == null || this.marks[level] == -1);
        if (this.marks == null) {
            this.marks = new byte[this.nLevels];
            Arrays.fill(this.marks, (byte)-1);
        }
        this.marks[level] = this.lastRemoved;
    }

    @Override
    public void restoreAtMark(int level) {
        byte e = this.lastRemoved;
        while (e != this.marks[level]) {
            this.restoreLastDropped();
            e = this.lastRemoved;
        }
        this.marks[level] = -1;
    }

    @Override
    public long[] binaryRepresentation() {
        return this.size == 2 ? binaryFor01 : (this.size == 0 ? binaryEmpty : (this.removedlevels[1] == -1 ? binaryFor1 : binaryFor0));
    }

    @Override
    public int[] indexes() {
        if (this.removedlevels[0] == -1) {
            return this.size == 2 ? domainFor01 : domainFor0;
        }
        return this.size == 1 ? domainFor1 : domainEmpty;
    }

    @Override
    public String stringOfStructures() {
        String s = LinkedSet.super.stringOfStructures();
        StringBuilder sb = new StringBuilder().append("Levels: ");
        int lastLevel = -1;
        int i = this.lastRemoved();
        while (i != -1) {
            if (this.removedlevels[i] != lastLevel) {
                sb.append(i + "@" + this.removedlevels[i] + " ");
                lastLevel = this.removedlevels[i];
            }
            i = this.prevRemoved(i);
        }
        return s + "\n" + sb.toString();
    }

    @Override
    public boolean controlStructures() {
        return true;
    }
}

