/*
 * Decompiled with CFR 0.152.
 */
package utility.operations.mining;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.xcsp.common.Utilities;
import utility.Kit;
import utility.operations.mining.Miner;

public class MinerFPTree
extends Miner {
    private static final int SUPPORT_THRESHOLD = 80;

    private int[] computeFrequencyOfValues(int[] domainSizes, int[][] tuples) {
        int[] frequencies = new int[domainSizes.length * (Kit.computeMaxOf(domainSizes) + 1)];
        for (int[] tuple : tuples) {
            for (int i = 0; i < tuple.length; ++i) {
                int n = this.combinator.combinedIntValueFor(i, tuple[i]);
                frequencies[n] = frequencies[n] + 1;
            }
        }
        return frequencies;
    }

    private List<int[]> collectFrequentPatterns(Node node, int[] prefix, List<int[]> patterns) {
        for (Node child : node.childs) {
            if (child.frequencyCounter < 80) continue;
            int[] newPrefix = Utilities.collectInt(prefix, child.value);
            int sizeBefore = patterns.size();
            if (child.childs.size() != 0) {
                if ((patterns = this.collectFrequentPatterns(child, newPrefix, patterns)).size() != sizeBefore) continue;
                patterns.add(newPrefix);
                continue;
            }
            patterns.add(newPrefix);
        }
        return patterns;
    }

    private List<int[]> normalize(List<int[]> patterns) {
        ArrayList<int[]> keepIt = new ArrayList<int[]>();
        for (int i = 0; i < patterns.size(); ++i) {
            int[] pattern = patterns.get(i);
            if (pattern.length == 1) continue;
            boolean subsumed = false;
            for (int j = i + 1; !subsumed && j < patterns.size(); ++j) {
                if (!Kit.isPrefix(pattern, patterns.get(j))) continue;
                subsumed = true;
            }
            if (subsumed) continue;
            keepIt.add(pattern);
        }
        return keepIt;
    }

    public MinerFPTree(int[] domainSizes, int[][] tuples, double minSup) {
        super(domainSizes, minSup);
        final int[] valuesFrequencies = this.computeFrequencyOfValues(domainSizes, tuples);
        Tree tree = new Tree();
        ArrayList<Integer> transaction = new ArrayList<Integer>();
        for (int[] tuple : tuples) {
            for (int i = 0; i < tuple.length; ++i) {
                int value = this.combinator.combinedIntValueFor(i, tuple[i]);
                if (valuesFrequencies[value] < 80) continue;
                transaction.add(value);
            }
            Collections.sort(transaction, new Comparator<Integer>(){

                @Override
                public int compare(Integer value1, Integer value2) {
                    int compare = valuesFrequencies[value2] - valuesFrequencies[value1];
                    return compare == 0 ? value2 - value1 : compare;
                }
            });
            tree.addTransaction(transaction);
            transaction.clear();
        }
        Comparator<int[]> comparator = new Comparator<int[]>(){

            @Override
            public int compare(int[] item1, int[] item2) {
                return item1.length == 0 || item2.length == 0 ? 0 : (item1.length < item2.length ? -1 : 1);
            }
        };
        List<int[]> frequentPatterns = this.collectFrequentPatterns(tree.root, new int[0], new ArrayList<int[]>());
        Collections.sort(frequentPatterns, comparator);
        this.selectedItems = Kit.intArray2D(this.normalize(frequentPatterns));
        Arrays.sort(this.selectedItems, comparator);
    }

    private void printTree(Node node, String prefix) {
        if (node.childs.size() != 0) {
            for (Node child : node.childs) {
                this.printTree(child, prefix + " " + child.value + "(" + child.frequencyCounter + ")");
            }
        } else {
            Kit.log.finest(prefix);
        }
    }

    private class Tree {
        private Node root;

        private Tree() {
            this.root = new Node(-1);
        }

        private void addTransaction(List<Integer> transaction) {
            Node currentNode = this.root;
            for (int value : transaction) {
                Node child = currentNode.getChildWithValue(value);
                if (child == null) {
                    child = new Node(value);
                    currentNode.childs.add(child);
                } else {
                    child.frequencyCounter++;
                }
                currentNode = child;
            }
        }
    }

    private class Node {
        private int value;
        private int frequencyCounter = 1;
        private List<Node> childs = new ArrayList<Node>();

        private Node(int value) {
            this.value = value;
        }

        private Node getChildWithValue(int value) {
            for (Node child : this.childs) {
                if (child.value != value) continue;
                return child;
            }
            return null;
        }
    }
}

