/*
 * Decompiled with CFR 0.152.
 */
package utility.operations.mining;

import java.util.ArrayList;
import utility.Kit;
import utility.operations.mining.Miner;

public class MinerApriori
extends Miner {
    private int minimalItemSize = 1;

    private boolean isMatching(int[] item, int[] tuple) {
        for (int v : item) {
            if (tuple[this.combinator.leftValueIn(v)] == this.combinator.rightValueIn(v)) continue;
            return false;
        }
        return true;
    }

    private int[][] selectFrequentItemsFrom(int[][] currentItems, int[][] tuples) {
        ArrayList<int[]> frequentItems = new ArrayList<int[]>();
        for (int[] item : currentItems) {
            int nbOccurrences = 0;
            for (int[] tuple : tuples) {
                if (!this.isMatching(item, tuple)) continue;
                ++nbOccurrences;
            }
            if (!((double)nbOccurrences / (double)tuples.length >= this.minSup)) continue;
            frequentItems.add(item);
        }
        return Kit.intArray2D(frequentItems);
    }

    private boolean isVariableInvolvedIn(int variablePosition, int[] item) {
        for (int v : item) {
            if (this.combinator.leftValueIn(v) != variablePosition) continue;
            return true;
        }
        return false;
    }

    private int[][] createNewItemsFrom(int[][] items) {
        int newItemSize = items[0].length + 1;
        ArrayList<int[]> newItems = new ArrayList<int[]>();
        for (int i = 0; i < items.length; ++i) {
            for (int j = i + 1; j < items.length; ++j) {
                for (int v : items[j]) {
                    if (this.isVariableInvolvedIn(this.combinator.leftValueIn(v), items[i])) continue;
                    int[] newItem = new int[newItemSize];
                    System.arraycopy(items[i], 0, newItem, 0, newItem.length - 1);
                    newItem[newItem.length - 1] = v;
                    newItems.add(newItem);
                }
            }
        }
        return Kit.intArray2D(newItems);
    }

    private int[][] selectFrequentItems(int[] domainSizes, int[][] tuples) {
        ArrayList<int[]> selectedItems = new ArrayList<int[]>();
        int[][] currentItems = new int[(int)Kit.sum(domainSizes)][1];
        int cnt = 0;
        for (int i = 0; i < domainSizes.length; ++i) {
            for (int j = 0; j < domainSizes[i]; ++j) {
                currentItems[cnt++][0] = this.combinator.combinedIntValueFor(i, j);
            }
        }
        while (currentItems.length >= 1 && currentItems[0].length < domainSizes.length) {
            if ((currentItems = this.selectFrequentItemsFrom(currentItems, tuples)).length <= 0) continue;
            if (currentItems[0].length >= this.minimalItemSize) {
                for (int[] item : currentItems) {
                    selectedItems.add(item);
                }
            }
            currentItems = this.createNewItemsFrom(currentItems);
        }
        return Kit.intArray2D(selectedItems);
    }

    public MinerApriori(int[] domainSizes, int[][] tuples, double minSup) {
        super(domainSizes, minSup);
        this.selectedItems = this.selectFrequentItems(domainSizes, tuples);
    }
}

