/*
 * Decompiled with CFR 0.152.
 */
package utility.operations;

import java.util.Arrays;

public abstract class KMeansClustering {
    private int[] values = new int[this.nValues()];

    public abstract int nValues();

    public abstract int value(int var1);

    private double computeVariance(int from, int to, long sum) {
        double mean = (double)sum / (double)(to - from + 1);
        double variance = 0.0;
        for (int i = from; i <= to; ++i) {
            variance += ((double)this.values[i] - mean) * ((double)this.values[i] - mean);
        }
        return variance;
    }

    public int recluster() {
        double current;
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.value(i);
        }
        Arrays.sort(this.values);
        int frontier = 1;
        long leftSum = this.values[0];
        long rightSum = 0L;
        for (int i = frontier; i < this.values.length; ++i) {
            rightSum += (long)this.values[i];
        }
        double min = current = this.computeVariance(0, frontier - 1, leftSum) + this.computeVariance(frontier, this.values.length - 1, rightSum);
        do {
            min = current;
        } while ((current = this.computeVariance(0, frontier - 1, leftSum += (long)this.values[++frontier]) + this.computeVariance(frontier, this.values.length - 1, rightSum -= (long)this.values[frontier])) < min && frontier < this.values.length - 1);
        return this.values[frontier - 1];
    }
}

