/*
 * Decompiled with CFR 0.152.
 */
package utility.operations;

import utility.Kit;

public final class CombinatorOfTwoInts {
    private final int maxLeftValue;
    private final int maxRightValue;
    private final int offset;

    public long maxPossibleCombinedValue() {
        return this.maxLeftValue * this.offset + this.maxRightValue;
    }

    public int leftValueIn(int combinedValue) {
        assert (0 <= combinedValue && (long)combinedValue <= this.maxPossibleCombinedValue());
        return combinedValue / this.offset;
    }

    public int rightValueIn(int combinedValue) {
        assert (0 <= combinedValue && (long)combinedValue <= this.maxPossibleCombinedValue());
        return combinedValue % this.offset;
    }

    public int leftValueIn(long combinedValue) {
        assert (0L <= combinedValue && combinedValue <= this.maxPossibleCombinedValue());
        return (int)combinedValue / this.offset;
    }

    public int rightValueIn(long combinedValue) {
        assert (0L <= combinedValue && combinedValue <= this.maxPossibleCombinedValue());
        return (int)combinedValue % this.offset;
    }

    public int combinedIntValueFor(int leftValue, int rightValue) {
        assert (0 <= leftValue && leftValue <= this.maxLeftValue && 0 <= rightValue && rightValue <= this.maxRightValue && this.maxPossibleCombinedValue() <= Integer.MAX_VALUE);
        return leftValue * this.offset + rightValue;
    }

    public long combinedLongValueFor(int leftValue, int rightValue) {
        assert (0 <= leftValue && leftValue <= this.maxLeftValue && 0 <= rightValue && rightValue <= this.maxRightValue);
        return leftValue * this.offset + rightValue;
    }

    public long combinedMinMaxLongValueFor(int leftValue, int rightValue) {
        assert (0 <= leftValue && leftValue <= this.maxLeftValue && 0 <= rightValue && rightValue <= this.maxRightValue);
        return (this.maxLeftValue - leftValue) * this.offset + rightValue;
    }

    public long combinedMaxMinLongValueFor(int leftValue, int rightValue) {
        assert (0 <= leftValue && leftValue <= this.maxLeftValue && 0 <= rightValue && rightValue <= this.maxRightValue);
        return leftValue * this.offset + (this.maxRightValue - rightValue);
    }

    public CombinatorOfTwoInts(int maxLeftValue, int maxRightValue) {
        this.maxLeftValue = maxLeftValue;
        this.maxRightValue = maxRightValue;
        this.offset = maxRightValue + 1;
        Kit.control(0 < maxLeftValue && 0 < maxRightValue && (double)maxLeftValue * (double)this.offset + (double)maxRightValue <= 9.223372036854776E18);
    }

    public CombinatorOfTwoInts(int maxRightValue) {
        this(0x7FFFFFFE, maxRightValue);
    }

    public CombinatorOfTwoInts() {
        this(0x7FFFFFFE, 0x7FFFFFFE);
    }
}

