/*
 * Decompiled with CFR 0.152.
 */
package tools.random;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import utility.Kit;
import utility.operations.Base;
import utility.sets.SetSparse;

public abstract class RandomGeneration {
    protected final int[] nValues;
    protected final long seed;
    protected final Random random;
    protected int[] fixedTuple;
    protected boolean fixedTupleIsSupport;

    public RandomGeneration(int[] nValues, long seed) {
        this.nValues = nValues;
        this.seed = seed;
        this.random = new Random(seed);
    }

    public RandomGeneration(int nValues, int arity, long seed) {
        this(Kit.repeat(nValues, arity), seed);
    }

    public int arity() {
        return this.nValues.length;
    }

    private static BigInteger nPermutableCombinations(SetSparse takenValues, int[] nValues, int j) {
        int[] freeValues = IntStream.range(0, nValues[j]).filter(v -> !takenValues.isPresent(v)).toArray();
        if (j == nValues.length - 1) {
            return BigInteger.valueOf(freeValues.length);
        }
        BigInteger sum = BigInteger.ZERO;
        for (int v2 : freeValues) {
            takenValues.add(v2);
            sum = sum.add(RandomGeneration.nPermutableCombinations(takenValues, nValues, j + 1));
            takenValues.remove(v2);
        }
        return sum;
    }

    private static BigInteger nPermutableCombinationsFor(int[] nValues) {
        if (IntStream.range(1, nValues.length).allMatch(i -> nValues[i] == nValues[0])) {
            BigInteger k = Utilities.binomialBig(nValues[0], nValues.length);
            return k.multiply(Utilities.factorialBig(nValues.length));
        }
        return RandomGeneration.nPermutableCombinations(new SetSparse(IntStream.of(nValues).max().getAsInt()), nValues, 0);
    }

    protected BigInteger nDistinctTuples(boolean valueRepetition) {
        return valueRepetition ? Utilities.nArrangementsFor(this.nValues) : RandomGeneration.nPermutableCombinationsFor(this.nValues);
    }

    public static void main(String[] args) {
        int[] t = IntStream.of(2, 2, 6, 10, 23).toArray();
        System.out.println("Combinations = " + RandomGeneration.nPermutableCombinationsFor(t) + "\nArrangements = " + Utilities.nArrangementsFor(t));
    }

    public static final class RandomGenerationProp
    extends RandomGeneration {
        private static final int OCCURENCES_LIMIT = 100;
        private static final int RANDOMS_LIMIT = 4;
        private static final int OVERFLOWS_LIMIT = 35;
        protected boolean valueRepetition;
        protected boolean tupleRepetition;
        protected int lowerbound;
        protected int upperbound;
        protected int nAllowedOverflows;
        private int nOverflows;
        private int nOverflowsBis;
        private final int[] nOccurences;
        private final int[] nOccurencesBis;

        public RandomGenerationProp(int[] nValues, long seed) {
            super(nValues, seed);
            this.nOccurences = new int[IntStream.of(nValues).max().orElse(-1)];
            this.nOccurencesBis = new int[this.nOccurences.length];
        }

        public RandomGenerationProp(int nValues, int arity, long seed) {
            this(Kit.repeat(nValues, arity), seed);
        }

        protected void storeNbOccurrences() {
            System.arraycopy(this.nOccurences, 0, this.nOccurencesBis, 0, this.nOccurences.length);
            this.nOverflowsBis = this.nOverflows;
        }

        protected void restoreNbOccurrences() {
            System.arraycopy(this.nOccurencesBis, 0, this.nOccurences, 0, this.nOccurences.length);
            this.nOverflows = this.nOverflowsBis;
        }

        protected final void setLimits(int nTuples, TypeList type) {
            int size = this.arity() * nTuples;
            if (type == TypeList.UNSTRUCTURED) {
                this.lowerbound = Integer.MAX_VALUE;
                this.upperbound = Integer.MAX_VALUE;
                this.nAllowedOverflows = 0;
            }
            if (type == TypeList.CONNECTED) {
                this.lowerbound = 1;
                this.upperbound = Integer.MAX_VALUE;
                this.nAllowedOverflows = size - this.lowerbound * this.nOccurences.length;
            }
            if (type == TypeList.BALANCED) {
                this.lowerbound = size / this.nOccurences.length;
                this.upperbound = this.lowerbound + 1;
                this.nAllowedOverflows = size % this.nOccurences.length;
                Kit.control(this.lowerbound > 0);
            }
        }

        private boolean isValidValue(int[] tuple, int position) {
            int value = tuple[position];
            if (!this.valueRepetition) {
                for (int i = 0; i < position; ++i) {
                    if (tuple[i] != value) continue;
                    return false;
                }
            }
            if (this.nOccurences[value] + 1 > this.upperbound || this.nOccurences[value] + 1 > this.lowerbound && this.nOverflows + 1 > this.nAllowedOverflows) {
                assert (this.nOccurences[value] <= this.upperbound && this.nOverflows <= this.nAllowedOverflows);
                return false;
            }
            int n = value;
            this.nOccurences[n] = this.nOccurences[n] + 1;
            if (this.nOccurences[value] > this.lowerbound) {
                ++this.nOverflows;
            }
            return true;
        }

        private boolean canBeInserted(int[][] tuples, int i) {
            if (this.fixedTuple != null && !this.fixedTupleIsSupport && Arrays.equals(tuples[i], this.fixedTuple)) {
                return false;
            }
            if (i > 0) {
                int position = Arrays.binarySearch(tuples, 0, i, tuples[i], Utilities.lexComparatorInt);
                if (position >= 0 && !this.tupleRepetition) {
                    return false;
                }
                position = position >= 0 ? position : -position - 1;
                int[] tmp = tuples[i];
                for (int j = i - 1; j >= position; --j) {
                    tuples[j + 1] = tuples[j];
                }
                tuples[position] = tmp;
            }
            return true;
        }

        private void doPotentialRelaxation(int nTrials) {
            if (nTrials % 100 == 0) {
                ++this.upperbound;
            } else if (nTrials % 35 == 0) {
                ++this.nAllowedOverflows;
            }
        }

        protected int[][] makeSelection(int nTuples, TypeList type) {
            int i2;
            this.setLimits(nTuples, type);
            int[][] tuples = new int[nTuples][this.arity()];
            if (this.fixedTuple != null && this.fixedTupleIsSupport) {
                Kit.control(IntStream.range(0, this.fixedTuple.length).allMatch(i -> this.isValidValue(this.fixedTuple, i)), () -> " keep absolutely in order to update counters");
                System.arraycopy(this.fixedTuple, 0, tuples[0], 0, this.fixedTuple.length);
            }
            int n = i2 = this.fixedTuple != null && this.fixedTupleIsSupport ? 1 : 0;
            while (i2 < tuples.length) {
                this.storeNbOccurrences();
                int nTrials = 0;
                do {
                    boolean valid = false;
                    while (!valid) {
                        this.restoreNbOccurrences();
                        valid = true;
                        for (int j = 0; valid && j < tuples[i2].length; ++j) {
                            int nRandomAttempts = 0;
                            do {
                                tuples[i2][j] = this.random.nextInt(this.nValues[j]);
                            } while (!this.isValidValue(tuples[i2], j) && nRandomAttempts++ < 4 * this.nValues[j]);
                            if (nRandomAttempts < 4 * this.nValues[j]) continue;
                            valid = false;
                        }
                        if (!valid) {
                            this.doPotentialRelaxation(++nTrials);
                            continue;
                        }
                        if (this.valueRepetition) continue;
                        Arrays.sort(tuples[i2]);
                    }
                } while (!this.canBeInserted(tuples, i2));
                ++i2;
            }
            return tuples;
        }

        public int[][] selectTuples(int nTuples, TypeList type, boolean tupleRepetition, boolean valueRepetition, int[] fixedTuple, boolean fixedTupleIsSupport) {
            this.tupleRepetition = tupleRepetition;
            this.valueRepetition = valueRepetition;
            this.fixedTuple = fixedTuple;
            this.fixedTupleIsSupport = fixedTupleIsSupport;
            BigInteger nDistinctTuples = Utilities.nArrangementsFor(this.nValues);
            Kit.control(nDistinctTuples.compareTo(BigInteger.ZERO) > 0, () -> "The number of distinct tuples is equal to 0 " + valueRepetition);
            Kit.control(tupleRepetition || BigInteger.valueOf(nTuples).compareTo(nDistinctTuples) <= 0, () -> "The number of tuples " + nTuples + " is greater than the maximum possible number ");
            Kit.control(fixedTuple == null || valueRepetition || IntStream.range(0, fixedTuple.length - 1).allMatch(i -> fixedTuple[i] < fixedTuple[i + 1]), () -> "The fixed tuple must be ordered");
            int[][] tuples = this.makeSelection(nTuples, type);
            return Kit.sort(tuples, Utilities.lexComparatorInt);
        }

        public final int[][] selectTuples(int nTuples, TypeList type, boolean tupleRepetition, boolean valueRepetition) {
            return this.selectTuples(nTuples, type, tupleRepetition, valueRepetition, null, false);
        }

        public final int[][] selectSets(int nSets, TypeList type, boolean repetition) {
            return this.selectTuples(nSets, type, repetition, false);
        }

        public static enum TypeList {
            UNSTRUCTURED,
            CONNECTED,
            BALANCED;


            public static TypeList get(int i) {
                return i == 0 ? UNSTRUCTURED : (i == 1 ? CONNECTED : BALANCED);
            }
        }
    }

    public static final class RandomGenerationProb
    extends RandomGeneration {
        private static BigInteger N_TUPLES_LIMIT = BigInteger.valueOf(1000000000L);

        public RandomGenerationProb(int[] nValues, long seed) {
            super(nValues, seed);
            BigInteger nDistinctTuples = Utilities.nArrangementsFor(nValues);
            Kit.control(nDistinctTuples.compareTo(BigInteger.ZERO) > 0 && nDistinctTuples.compareTo(N_TUPLES_LIMIT) < 0, () -> "The number of distinct tuples is not valid ");
        }

        public int[][] selectTuples(double selectionLimit, int[] fixedTuple, boolean fixedTupleIsSupport) {
            int nDistinctTuples = Utilities.nArrangementsFor(this.nValues).intValueExact();
            LinkedList<Object> list = new LinkedList<Object>();
            long fixedIndex = fixedTuple == null ? -1L : Base.decimalValueFor(fixedTuple, this.nValues);
            int[] tuple = new int[this.arity()];
            for (int i = 0; i < nDistinctTuples; ++i) {
                Base.valueFor(i, tuple, this.nValues);
                if ((Base.decimalValueFor(tuple, this.nValues) != fixedIndex || !fixedTupleIsSupport) && (Base.decimalValueFor(tuple, this.nValues) == fixedIndex || !(this.random.nextDouble() <= selectionLimit))) continue;
                list.add(tuple.clone());
            }
            return Kit.sort(list.toArray((T[])new int[0][]), Utilities.lexComparatorInt);
        }
    }
}

