/*
 * Decompiled with CFR 0.152.
 */
package tools.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xcsp.common.Utilities;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import utility.XMLManager;

public class CreateCampagnDataFile {
    private Metric cpu = new MetricDouble(Enums.TypeOutput.GLOBAL, "cpu", 1000);
    private Metric pcpu = new MetricDouble(Enums.TypeOutput.PREPROCESSING, "cpu", 1000);
    private Metric scpu = new MetricDouble(Enums.TypeOutput.SEARCH, "cpu", 1000);
    private Metric mem = new MetricLongMem(Enums.TypeOutput.GLOBAL, "mem");
    private Metric pmem = new MetricLongMem(Enums.TypeOutput.PREPROCESSING, "mem");
    private Metric smem = new MetricLongMem(Enums.TypeOutput.SEARCH, "mem");
    private Metric nbVariables = new MetricLong(Enums.TypeOutput.VARIABLES, "nVariables");
    private Metric nbDomainTypes = new MetricLong(Enums.TypeOutput.VARIABLES, "nDomainTypes");
    private Metric nbTotalValues = new MetricLong(Enums.TypeOutput.VARIABLES, "nTotalValues");
    private Metric nbConstraints = new MetricLong(Enums.TypeOutput.CONSTRAINTS, "nConstraints");
    private Metric nbGenerators = new MetricLong(Enums.TypeOutput.CONSTRAINTS, "nGenerators");
    private Metric symmetryCpuTime = new MetricDouble(Enums.TypeOutput.CONSTRAINTS, "symmetryCpuTime");
    private Metric nbAcRemovals = new MetricLong(Enums.TypeOutput.PREPROCESSING, "nACRemovals");
    private Metric nbRemovedValues = new MetricLong(Enums.TypeOutput.PREPROCESSING, "nRemovedValues");
    private Metric nbSubRemovals = new MetricLong(Enums.TypeOutput.PREPROCESSING, "nSUBRemovals");
    private Metric nbRemovedTuples = new MetricLong(Enums.TypeOutput.PREPROCESSING, "nRemovedTuples");
    private Metric nbAddedConstraints = new MetricLong(Enums.TypeOutput.PREPROCESSING, "nAddedConstraints");
    private Metric nbSingletonTests = new MetricLong(Enums.TypeOutput.PREPROCESSING, "nSingletonTests");
    private Metric nbEffectiveSingletonTests = new MetricLong(Enums.TypeOutput.PREPROCESSING, "nEffectiveSingletonTests");
    private Metric nbFoundSingletons = new MetricLong(Enums.TypeOutput.PREPROCESSING, "nFoundSingletons");
    private Metric nbBuiltBranches = new MetricLong(Enums.TypeOutput.PREPROCESSING, "nBuiltBranches");
    private Metric sumBranchSizes = new MetricLong(Enums.TypeOutput.PREPROCESSING, "sumBranchSizes");
    private Metric detectedInconsistency = new MetricEquals(Enums.TypeOutput.PREPROCESSING, "detectedInconsistency", "yes");
    private Metric nbWrong = new MetricLong(Enums.TypeOutput.GLOBAL, "wrong");
    private Metric mapSize = new MetricLong(Enums.TypeOutput.SEARCH, "mapSize");
    private Metric nbInferences = new MetricLong(Enums.TypeOutput.SEARCH, "nInferences");
    private Metric nbSEliminables = new MetricDouble(Enums.TypeOutput.SEARCH, "nSEliminables");
    private Metric nbREliminables = new MetricDouble(Enums.TypeOutput.SEARCH, "nREliminables");
    private Metric nbDEliminables = new MetricDouble(Enums.TypeOutput.SEARCH, "nDEliminables");
    private Metric nbIEliminables = new MetricDouble(Enums.TypeOutput.SEARCH, "nIEliminables");
    private Metric nbPEliminables = new MetricDouble(Enums.TypeOutput.SEARCH, "nPEliminables");
    private Metric nbSolutions = new MetricLong(Enums.TypeOutput.GLOBAL, "foundSolutions");
    private Metric nbConstraintChecks = new MetricLong(Enums.TypeOutput.GLOBAL, "nConstraintChecks");
    private Metric bestBound = new MetricLong(Enums.TypeOutput.GLOBAL, "bestBound");
    private Metric bestBoundCpuTime = new MetricDouble(Enums.TypeOutput.GLOBAL, "bestBoundCpu", 1000);
    private Metric expiredTime = new MetricEquals(Enums.TypeOutput.GLOBAL, "expiredTime", "yes");
    private Metric nbEffectivePropagations = new MetricLong(Enums.TypeOutput.GLOBAL, "nEffectivePFilterings");
    private Metric avgSubRemovals = new MetricDouble(Enums.TypeOutput.GLOBAL, "avgSUBRemovals");
    private Metric nbFilterCalls = new MetricLong(Enums.TypeOutput.GLOBAL, "nFilterCalls");
    private Metric avgTableProportion = new MetricDouble(Enums.TypeOutput.GLOBAL, "avgTableProportion", 1000);
    private Metric avgTableSize = new MetricDouble(Enums.TypeOutput.GLOBAL, "avgTableSize");
    private Metric totalInitialSpace = new MetricLong(Enums.TypeOutput.GLOBAL, "totalInitialSpace");
    private Metric totalReducedSpace = new MetricLong(Enums.TypeOutput.GLOBAL, "totalReducedSpace");
    private Metric wckMining = new MetricLong(Enums.TypeOutput.GLOBAL, "wckMining");
    private Metric exceededTime = new MetricEquals(Enums.TypeOutput.GLOBAL, "Stop", Enums.EStopping.EXCEEDED_TIME.toString());
    private Metric global_nbSingletonTests = new MetricLong(Enums.TypeOutput.GLOBAL, "nSingletonTests");
    private Metric global_nbEffectiveSingletonTests = new MetricLong(Enums.TypeOutput.GLOBAL, "nEffectiveSingletonTests");
    private Metric all_cpu = new MetricDouble(Enums.TypeOutput.ALL, "cpu", 1000);
    private Metric all_wckPREPROCESSING = new MetricDouble(Enums.TypeOutput.ALL, "preproWckTime", 1000);
    private Metric all_wckSearch = new MetricDouble(Enums.TypeOutput.ALL, "searchWckTime", 1000);
    private Metric all_mem = new MetricLong(Enums.TypeOutput.ALL, "mem");
    private Metric all_nbAssignments = new MetricDouble(Enums.TypeOutput.ALL, "nAssignments");
    private Metric all_nbSolutions = new MetricDouble(Enums.TypeOutput.ALL, "foundSolutions");
    private Metric all_nbFilterCalls = new MetricDouble(Enums.TypeOutput.ALL, "nFilterCalls");
    private Metric all_avgTableProportion = new MetricDouble(Enums.TypeOutput.ALL, "avgTableProportion", 1000);
    private Metric all_avgTableSize = new MetricDouble(Enums.TypeOutput.ALL, "avgTableSize");
    private Metric all_nbRemovedValues = new MetricDouble(Enums.TypeOutput.ALL, "nRemovedValues");
    private Metric all_nbRemovedTuples = new MetricDouble(Enums.TypeOutput.ALL, "nRemovedTuples");
    private Metric all_nbValidSupports = new MetricDouble(Enums.TypeOutput.ALL, "nValidSupports");
    private Metric all_nbInstances = new MetricLong(Enums.TypeOutput.ALL, "nInstances");
    private Metric all_nbVals = new MetricDouble(Enums.TypeOutput.ALL, "nbVals");
    private Metric all_nbUnks = new MetricDouble(Enums.TypeOutput.ALL, "nbUnks");
    private Metric all_nbUnksAfterAC = new MetricDouble(Enums.TypeOutput.ALL, "nbUnksAfterAC");
    private Metric all_nbTests = new MetricDouble(Enums.TypeOutput.ALL, "nbTests");
    private Metric nbCrashes = new MetricLong(Enums.TypeOutput.CRASHED, "nInstances");
    private Element[] storedElements = new Element[Enums.TypeOutput.values().length];
    private List<Metric> selectedMetrics;
    private Map<String, Map<String, String>> globalMap;
    private Set<String> keys;
    private boolean seriesExtraction;
    private boolean kernelExtraction;
    private String error;
    private Map<String, Long> nbSolutionsControl = new HashMap<String, Long>();
    private final boolean mustReachGoal;
    private int cnt = 0;

    private void insert(String instance, String method, String s) {
        this.keys.add(method);
        Map instanceMap = this.globalMap.computeIfAbsent(instance, k -> new TreeMap());
        String value = (String)instanceMap.get(method);
        if (value == null || value.equals(this.error)) {
            instanceMap.put(method, s);
        }
    }

    private void selectMetrics(Metric ... metrics) {
        this.selectedMetrics = new ArrayList<Metric>();
        for (int i = 0; i < metrics.length; ++i) {
            this.selectedMetrics.add(metrics[i]);
        }
    }

    private Element firstComponentOf(Element element, Enums.TypeOutput outputElement) {
        return (Element)element.getElementsByTagName(outputElement.toString()).item(0);
    }

    private Element firstComponentInstanceNameOf(Element element) {
        Element elt = this.firstComponentOf(element, Enums.TypeOutput.INSTANCE);
        if (elt != null) {
            return elt;
        }
        return (Element)element.getElementsByTagName("Instance").item(0);
    }

    private Element lastComponentOf(Element element, Enums.TypeOutput outputElement) {
        NodeList nodeList = element.getElementsByTagName(outputElement.toString());
        return nodeList.getLength() == 0 ? null : (Element)nodeList.item(nodeList.getLength() - 1);
    }

    private void dealWithInstance(Element resolution, String instanceName, String configurationFileName) {
        boolean timeout;
        boolean csp = this.firstComponentOf(resolution, Enums.TypeOutput.INSTANCE).getAttribute("framework").startsWith("CSP");
        this.storedElements[Enums.TypeOutput.VARIABLES.ordinal()] = this.firstComponentOf(resolution, Enums.TypeOutput.VARIABLES);
        this.storedElements[Enums.TypeOutput.CONSTRAINTS.ordinal()] = this.firstComponentOf(resolution, Enums.TypeOutput.CONSTRAINTS);
        Element solver = this.lastComponentOf(resolution, Enums.TypeOutput.SOLVER);
        if (solver != null) {
            this.storedElements[Enums.TypeOutput.PREPROCESSING.ordinal()] = this.lastComponentOf(solver, Enums.TypeOutput.PREPROCESSING);
            this.storedElements[Enums.TypeOutput.SEARCH.ordinal()] = this.lastComponentOf(solver, Enums.TypeOutput.SEARCH);
            this.storedElements[Enums.TypeOutput.GLOBAL.ordinal()] = this.firstComponentOf(solver, Enums.TypeOutput.GLOBAL);
        }
        StringBuilder selectedMetricsValues = new StringBuilder();
        boolean bl = timeout = this.exceededTime.getValue().longValue() == 1L;
        if (solver == null || this.firstComponentOf(resolution, Enums.TypeOutput.ERROR) != null) {
            for (int i = 0; i < this.selectedMetrics.size(); ++i) {
                selectedMetricsValues.append(-2).append(" ");
            }
        } else if (this.mustReachGoal && timeout) {
            for (int i = 0; i < this.selectedMetrics.size(); ++i) {
                selectedMetricsValues.append(-1).append(" ");
            }
        } else {
            for (Metric metric : this.selectedMetrics) {
                selectedMetricsValues.append(metric.getValue()).append(" ");
                if (metric != this.nbSolutions || !csp) continue;
                if (!this.nbSolutionsControl.containsKey(instanceName)) {
                    if (timeout) continue;
                    this.nbSolutionsControl.put(instanceName, this.nbSolutions.getValue().longValue());
                    continue;
                }
                long nb = this.nbSolutionsControl.get(instanceName);
                if ((timeout || nb == this.nbSolutions.getValue().longValue()) && (!timeout || this.nbSolutions.getValue().longValue() <= nb)) continue;
                System.out.println("************** Bug with " + instanceName + " " + this.exceededTime.getValue().longValue() + " " + configurationFileName);
            }
        }
        this.insert(instanceName, configurationFileName, selectedMetricsValues.toString());
    }

    private void dealWithSeries(Element resolutions, String instanceName, String configurationFileName) {
        this.storedElements[Enums.TypeOutput.CRASHED.ordinal()] = this.firstComponentOf(resolutions, Enums.TypeOutput.CRASHED);
        this.storedElements[Enums.TypeOutput.ALL.ordinal()] = this.firstComponentOf(resolutions, Enums.TypeOutput.ALL);
        StringBuilder selectedMetricsValues = new StringBuilder();
        if (this.firstComponentOf(resolutions, Enums.TypeOutput.ALL) == null) {
            for (int i = 0; i < this.selectedMetrics.size(); ++i) {
                selectedMetricsValues.append(-1).append(" ");
            }
        } else if (this.nbCrashes.getValue().longValue() > 0L) {
            selectedMetricsValues.append(-this.nbCrashes.getValue().longValue()).append(" ");
            for (int i = 1; i < this.selectedMetrics.size(); ++i) {
                selectedMetricsValues.append(-5).append(" ");
            }
        } else {
            for (Metric metric : this.selectedMetrics) {
                selectedMetricsValues.append(metric.getValue()).append(" ");
            }
        }
        this.insert(instanceName, configurationFileName, selectedMetricsValues.toString());
    }

    private void dealWithKernel(Element kernel, String instanceName, String configurationFileName) {
        String cpu = kernel.getAttribute("globalTime");
        String nbRuns = kernel.getAttribute("nRuns");
        String vAvg = kernel.getAttribute("nVAvg");
        String cAvg = kernel.getAttribute("nCAvg");
        String result = cpu + " " + nbRuns + " " + vAvg + " " + cAvg;
        this.insert(instanceName, configurationFileName, result);
    }

    private void dealWithFile(File file) {
        Document document;
        if (this.cnt++ % 200 == 0) {
            System.out.println("loading " + file.getName() + " cpt = " + this.cnt);
        }
        Kit.control((document = XMLManager.load(file)) != null, () -> "Unloaded document");
        Element resolutions = (Element)document.getElementsByTagName(Enums.TypeOutput.RESOLUTIONS.toString()).item(0);
        String configurationFileName = Kit.getXMLBaseNameOf(resolutions.getAttribute("configurationFileName"));
        if (this.kernelExtraction) {
            Element resolution = this.firstComponentOf(resolutions, Enums.TypeOutput.RESOLUTION);
            String instanceName = Kit.getXMLBaseNameOf(this.firstComponentInstanceNameOf(resolution).getAttribute("name"));
            Element kernel = (Element)document.getElementsByTagName(Enums.TypeOutput.KERNEL.toString()).item(0);
            this.dealWithKernel(kernel, instanceName, configurationFileName);
        } else if (this.seriesExtraction) {
            Element resolution = this.firstComponentOf(resolutions, Enums.TypeOutput.RESOLUTION);
            String instanceName = Kit.getXMLBaseNameOf(this.firstComponentInstanceNameOf(resolution).getAttribute("name"));
            this.dealWithSeries(resolutions, instanceName + "all", configurationFileName);
        } else {
            NodeList resolutionList = document.getElementsByTagName(Enums.TypeOutput.RESOLUTION.toString());
            for (int i = 0; i < resolutionList.getLength(); ++i) {
                Element resolution = (Element)resolutionList.item(i);
                String instanceName = Kit.getXMLBaseNameOf(this.firstComponentInstanceNameOf(resolution).getAttribute("name"));
                this.dealWithInstance(resolution, instanceName, configurationFileName);
            }
        }
    }

    private void dealWith(File file) {
        block8: {
            block7: {
                if (!file.isDirectory()) break block7;
                for (File f : file.listFiles()) {
                    this.dealWith(f);
                }
                break block8;
            }
            if (!file.isFile()) break block8;
            if (file.length() == 0L) {
                System.out.println("skipping " + file.getName() + " as it is an empty file");
            } else if (!file.getName().toLowerCase().endsWith("xml")) {
                System.out.println("skipping " + file.getName() + " as it is not an XML file");
            } else {
                try {
                    this.dealWithFile(file);
                }
                catch (Exception e) {
                    System.out.println("skipping " + file.getName() + " as a problem occurs " + e);
                }
            }
        }
    }

    private void fillHolesInGlobalMap() {
        String stringForAbsentMethod = this.repeat(-3, this.selectedMetrics.size());
        for (Map.Entry<String, Map<String, String>> entry : this.globalMap.entrySet()) {
            Map<String, String> instanceMap = entry.getValue();
            for (String key : this.keys) {
                if (instanceMap.containsKey(key)) continue;
                instanceMap.put(key, stringForAbsentMethod);
            }
        }
    }

    private String createAlgoHeader(String algo) {
        StringBuilder sb = new StringBuilder();
        for (Metric metric : this.selectedMetrics) {
            sb.append(algo).append("-").append(Reflector.findFieldName(this, metric)).append(" ");
        }
        return sb.toString();
    }

    private String createHeader() {
        StringBuilder sb = new StringBuilder("instance ");
        for (String s : this.globalMap.get(this.globalMap.keySet().iterator().next()).keySet()) {
            sb.append(this.createAlgoHeader(s));
        }
        return sb.toString();
    }

    private String createLine(String instanceName, Map<String, String> instanceMap) {
        StringBuilder sb = new StringBuilder(instanceName).append(' ');
        for (String s : instanceMap.values()) {
            sb.append(s).append(' ');
        }
        return sb.toString();
    }

    private void save(String outputFileName) {
        Kit.control(!new File(outputFileName).isDirectory(), () -> outputFileName + " is a directory");
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(new File(outputFileName))));
            out.println(this.createHeader());
            System.out.println("creating header of " + outputFileName);
            for (Map.Entry<String, Map<String, String>> entry : this.globalMap.entrySet()) {
                out.println(this.createLine(entry.getKey(), entry.getValue()));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String repeat(int v, int nbOccurrences) {
        return Stream.generate(() -> v + "").limit(nbOccurrences).collect(Collectors.joining(" "));
    }

    public CreateCampagnDataFile(String inputFileName, String outputFileName, int mode, int metricsMode, boolean mustReachGoal) {
        if (mode == 1 || mode == 3 || mode == 4) {
            this.seriesExtraction = true;
        }
        if (mode == 2) {
            this.kernelExtraction = true;
        }
        this.mustReachGoal = mustReachGoal;
        if (metricsMode == 1) {
            this.selectMetrics(this.cpu);
        } else if (metricsMode == 2) {
            this.selectMetrics(this.cpu, this.mem);
        } else if (metricsMode == 3) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong);
        } else if (metricsMode == 4) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions);
        } else if (metricsMode == 5) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.pcpu);
        } else if (metricsMode == 6) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.bestBound, this.bestBoundCpuTime);
        } else if (metricsMode == 7) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.pcpu, this.symmetryCpuTime, this.nbGenerators);
        } else if (metricsMode == 8) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.pcpu, this.nbTotalValues, this.nbRemovedValues, this.nbAcRemovals);
        } else if (metricsMode == 9) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.pcpu, this.nbSingletonTests, this.nbEffectiveSingletonTests, this.nbBuiltBranches, this.sumBranchSizes);
        } else if (metricsMode == 10) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.pcpu, this.nbTotalValues, this.nbRemovedValues, this.nbAcRemovals, this.nbRemovedTuples, this.nbAddedConstraints);
        } else if (metricsMode == 11) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.pcpu, this.nbSEliminables, this.nbREliminables, this.nbDEliminables, this.nbIEliminables, this.nbPEliminables);
        } else if (metricsMode == 12) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.nbFilterCalls, this.avgTableProportion, this.avgTableSize);
        } else if (metricsMode == 13) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.totalInitialSpace, this.totalReducedSpace, this.wckMining);
        } else if (metricsMode == 14) {
            this.selectMetrics(this.cpu, this.mem, this.nbWrong, this.nbSolutions, this.pcpu, this.nbTotalValues, this.nbRemovedValues, this.nbAcRemovals, this.nbSubRemovals, this.bestBound, this.avgSubRemovals, this.nbEffectivePropagations);
        } else if (metricsMode == 15) {
            this.selectMetrics(this.pcpu, this.mem, this.nbTotalValues, this.nbRemovedValues, this.detectedInconsistency);
        } else if (metricsMode == 101) {
            this.selectMetrics(this.all_cpu);
        } else if (metricsMode == 102) {
            this.selectMetrics(this.all_cpu, this.all_mem);
        } else if (metricsMode == 103) {
            this.selectMetrics(this.all_wckPREPROCESSING, this.all_wckSearch, this.all_nbAssignments);
        } else if (metricsMode == 104) {
            this.selectMetrics(this.all_cpu, this.all_mem, this.all_nbAssignments, this.all_nbSolutions, this.all_nbRemovedValues, this.all_nbRemovedTuples, this.all_nbValidSupports, this.all_nbInstances);
        } else if (metricsMode == 112) {
            this.selectMetrics(this.all_cpu, this.all_mem, this.all_nbAssignments, this.all_nbSolutions, this.all_nbFilterCalls, this.all_avgTableProportion, this.all_avgTableSize);
        } else if (metricsMode == 120) {
            this.selectMetrics(this.all_cpu, this.all_mem, this.all_nbVals, this.all_nbUnks, this.all_nbUnksAfterAC, this.all_nbTests);
        }
        this.error = this.repeat(-2, this.selectedMetrics.size());
        this.globalMap = new TreeMap<String, Map<String, String>>();
        this.keys = new TreeSet<String>();
        this.dealWith(new File(inputFileName));
        this.fillHolesInGlobalMap();
        this.save(outputFileName);
    }

    public static void main(String[] args) {
        if (args.length != 3 && args.length != 4) {
            System.out.println("Usage: " + CreateCampagnDataFile.class.getName() + " <inputFileName | directoryName> <mode> <metricsMode> {<mustReachGoal>}");
            System.out.println("Mode = 0 : extraction for each instance");
            System.out.println("Mode = 1 : extraction for each series (element all)");
            System.out.println("Mode = 2 : extraction for kernels");
            System.out.println("Mode = 3 : extraction for each series (elements all, median)");
            System.out.println("NB: the name of the file containing the extracted results is built by appending .dat to the string denoting first argument");
        } else {
            new CreateCampagnDataFile(args[0], args[0] + ".dat", Integer.parseInt(args[1]), Integer.parseInt(args[2]), args.length == 3 ? true : Utilities.toBoolean(args[3]));
        }
    }

    private class MetricEquals
    extends Metric {
        private String value;

        private MetricEquals(Enums.TypeOutput elementType, String attribute, String value) {
            super(elementType, attribute);
            this.value = value;
        }

        @Override
        protected Number getValue() {
            Element element = CreateCampagnDataFile.this.storedElements[this.elementType.ordinal()];
            return element == null ? -3 : (element.getAttribute(this.attribute).equals(this.value) ? 1 : 0);
        }
    }

    private class MetricDouble
    extends Metric {
        private int multiplier;

        private MetricDouble(Enums.TypeOutput elementType, String attribute, int multiplier) {
            super(elementType, attribute);
            this.multiplier = multiplier;
        }

        private MetricDouble(Enums.TypeOutput elementType, String attribute) {
            this(elementType, attribute, 1);
        }

        @Override
        protected Number getValue() {
            Element element = CreateCampagnDataFile.this.storedElements[this.elementType.ordinal()];
            return element == null ? -3.0 : Double.parseDouble("0" + element.getAttribute(this.attribute)) * (double)this.multiplier;
        }
    }

    private class MetricLongMem
    extends Metric {
        private MetricLongMem(Enums.TypeOutput elementType, String attribute) {
            super(elementType, attribute);
        }

        @Override
        protected Number getValue() {
            Element element = CreateCampagnDataFile.this.storedElements[this.elementType.ordinal()];
            if (element == null) {
                return -3;
            }
            StringTokenizer st = new StringTokenizer(element.getAttribute(this.attribute), "M");
            return Long.parseLong(st.nextToken()) * 1000000L + Long.parseLong(st.nextToken()) * 1000L;
        }
    }

    private class MetricLong
    extends Metric {
        private MetricLong(Enums.TypeOutput elementType, String attribute) {
            super(elementType, attribute);
        }

        @Override
        protected Number getValue() {
            Element element = CreateCampagnDataFile.this.storedElements[this.elementType.ordinal()];
            return element == null ? -3L : Long.parseLong("0" + element.getAttribute(this.attribute));
        }
    }

    private abstract class Metric {
        protected Enums.TypeOutput elementType;
        protected String attribute;

        protected Metric(Enums.TypeOutput elementType, String attribute) {
            this.elementType = elementType;
            this.attribute = attribute;
        }

        protected abstract Number getValue();
    }
}

