/*
 * Decompiled with CFR 0.152.
 */
package search.statistics;

import interfaces.ObserverRuns;
import interfaces.ObserverSearch;
import java.text.NumberFormat;
import learning.LearnerStatesEquivalence;
import learning.ReductionOperator;
import org.xcsp.common.Types;
import problem.ProblemStuff;
import propagation.order1.AC;
import propagation.order1.PropagationForward;
import propagation.order1.singleton.SACGreedy;
import propagation.order1.singleton.SingletonConsistency;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public abstract class Statistics
implements ObserverRuns,
ObserverSearch {
    private static NumberFormat nformat = NumberFormat.getInstance();
    public final Solver solver;
    public final Kit.Stopwatch stopwatch = new Kit.Stopwatch();
    public long nVisitedNodes = 1L;
    public long nDecisions;
    public long nWrongDecisions;
    public long nBacktracks;
    public long nAssignments;
    public long nFailedAssignments;
    public long nPreproRemovedValues;
    public long nPreproRemovedTuples;
    public long nPreproAddedCtrs;
    public long nPreproAddedNogoods;
    public long nPreproInconsistencies;
    public long solvingWck;
    public long preproWck;
    public long searchWck;
    public long firstSolWck;
    public long firstSolCpu;
    public long lastSolWck;
    public long lastSolCpu;
    private long tmpNbAssignments;
    private long tmpNbBacktracks;
    private long tmpNbFailedAssignments;

    @Override
    public final void beforePreprocessing() {
        this.stopwatch.start();
        if (this.solver instanceof SolverBacktrack && ((SolverBacktrack)this.solver).learnerNogoods != null) {
            this.nPreproAddedNogoods = ((SolverBacktrack)this.solver).learnerNogoods.nNogoods;
        }
        this.nPreproAddedCtrs = this.solver.pb.constraints.length;
    }

    @Override
    public final void afterPreprocessing() {
        this.preproWck += this.stopwatch.getWckTime();
        if (this.solver instanceof SolverBacktrack && ((SolverBacktrack)this.solver).learnerNogoods != null) {
            this.nPreproAddedNogoods = (long)((SolverBacktrack)this.solver).learnerNogoods.nNogoods - this.nPreproAddedNogoods;
        }
        this.nPreproAddedCtrs = (long)this.solver.pb.constraints.length - this.nPreproAddedCtrs;
        this.nPreproRemovedValues = Variable.nRemovedValuesFor(this.solver.pb.variables);
        this.nPreproRemovedTuples = this.solver.pb.nTuplesRemoved;
        this.nPreproInconsistencies = this.solver.stoppingType == Enums.EStopping.FULL_EXPLORATION ? 1L : 0L;
    }

    @Override
    public final void beforeSolving() {
        this.stopwatch.start();
    }

    @Override
    public final void afterSolving() {
        this.solvingWck += this.stopwatch.getWckTime();
    }

    @Override
    public void afterRun() {
        this.searchWck = this.stopwatch.getWckTime();
    }

    public Statistics(Solver solver) {
        this.solver = solver;
    }

    public long numberSafe() {
        return this.nVisitedNodes + this.nAssignments + this.nBacktracks;
    }

    public void store() {
        this.tmpNbAssignments = this.nAssignments;
        this.tmpNbFailedAssignments = this.nFailedAssignments;
        this.tmpNbBacktracks = this.nBacktracks;
    }

    public void restore() {
        this.nAssignments = this.tmpNbAssignments;
        this.nFailedAssignments = this.tmpNbFailedAssignments;
        this.nBacktracks = this.tmpNbBacktracks;
    }

    public final long nCcks() {
        return this.solver.pb.stuff.nCcks;
    }

    public final long nEffectiveFilterings() {
        return this.solver.pb.stuff.nEffectiveFilterings;
    }

    public final long nRevisions() {
        return this.solver.propagation instanceof PropagationForward ? ((PropagationForward)this.solver.propagation).reviser.nRevisions : 0L;
    }

    public final long nUselessRevisions() {
        return this.solver.propagation instanceof PropagationForward ? ((PropagationForward)this.solver.propagation).reviser.nUselessRevisions : 0L;
    }

    public final long nSingletonTests() {
        return this.solver.propagation.nSingletonTests;
    }

    public final long nEffectiveSingletonTests() {
        return this.solver.propagation.nEffectiveSingletonTests;
    }

    public void manageSolution() {
        long cpu = this.solver.rs.stopwatch.getCpuTime();
        long wck = this.solver.rs.instanceStopwatch.getWckTime();
        if (this.solver.solManager.nSolutionsFound == 1L) {
            this.firstSolCpu = cpu;
            this.firstSolWck = wck;
        }
        this.lastSolCpu = cpu;
        this.lastSolWck = wck;
    }

    public final ProblemStuff.MapAtt preproAttributes() {
        ProblemStuff.MapAtt m = new ProblemStuff.MapAtt("Preprocessing");
        m.put("filters", this.nEffectiveFilterings());
        m.put("revisions", "(" + this.nRevisions() + ",useless=" + this.nUselessRevisions() + ")", this.nRevisions() > 0L);
        m.putPositive("ccks", this.nCcks());
        if (this.solver.propagation instanceof AC) {
            m.put("nACremovedValues", ((AC)this.solver.propagation).nPreproRemovals);
        }
        m.put("nTotalRemovedValues", this.nPreproRemovedValues);
        m.put("inconsistency", this.nPreproInconsistencies > 0L);
        m.separator();
        if (this.nPreproRemovedTuples > 0L || this.nPreproAddedNogoods > 0L || this.nPreproAddedCtrs > 0L) {
            m.put("nRemovedTuples", this.nPreproRemovedTuples);
            m.put("nNogoods", this.nPreproAddedNogoods);
            m.put("nAddedCtrs", this.nPreproAddedCtrs);
            m.separator();
        }
        if (this.nSingletonTests() > 0L) {
            m.put("nSingletonTests", this.nSingletonTests());
            m.put("nEffectiveSingletonTests", this.nEffectiveSingletonTests());
            if (this.solver.propagation instanceof SingletonConsistency) {
                m.put("nFoundSingletons", ((SingletonConsistency)this.solver.propagation).nFoundSingletons);
            }
            if (this.solver.propagation instanceof SACGreedy) {
                m.put("nBuiltBranches", ((SACGreedy)this.solver.propagation).nBranchesBuilt);
                m.put("sumBranchSizes", ((SACGreedy)this.solver.propagation).sumBranchSizes);
            }
            m.separator();
        }
        if (this.solver.solManager.nSolutionsFound > 0L) {
            m.put("foundSolutions", this.solver.solManager.nSolutionsFound);
            m.put("firstSolCpu", (double)this.firstSolCpu / 1000.0);
            m.separator();
        }
        m.put("wck", (double)this.preproWck / 1000.0);
        m.put("cpu", this.solver.rs.stopwatch.getCpuTimeInSeconds());
        m.put("mem", Kit.getFormattedUsedMemorySize());
        return m;
    }

    public abstract ProblemStuff.MapAtt runAttributes();

    public abstract ProblemStuff.MapAtt cumulatedAttributes();

    public ProblemStuff.MapAtt globalAttributes() {
        ProblemStuff.MapAtt m = this.cumulatedAttributes();
        m.put("Stop", this.solver.stoppingType == null ? "no" : this.solver.stoppingType.toString());
        m.put("wrong", this.solver.stats.nWrongDecisions);
        if (this.solver.solManager.nSolutionsFound > 0L) {
            if (this.solver.pb.framework != Types.TypeFramework.CSP) {
                m.put("bestBound", this.solver.solManager.bestBound);
                m.put("bestBoundWck", (double)this.lastSolWck / 1000.0);
                m.put("bestBoundCpu", (double)this.lastSolCpu / 1000.0);
            }
            m.put("foundSolutions", this.solver.solManager.nSolutionsFound);
            m.put("firstSolCpu", (double)this.firstSolCpu / 1000.0);
            m.separator();
        }
        m.put("wck", (double)this.solver.rs.instanceStopwatch.getWckTime() / 1000.0);
        m.put("cpu", this.solver.rs.stopwatch.getCpuTimeInSeconds());
        m.put("mem", Kit.getFormattedUsedMemorySize());
        return m;
    }

    public static final class StatisticsLocal
    extends Statistics {
        public StatisticsLocal(Solver solver) {
            super(solver);
        }

        @Override
        public ProblemStuff.MapAtt runAttributes() {
            ProblemStuff.MapAtt m = new ProblemStuff.MapAtt("Run");
            m.put("number", this.solver.restarter.numRun == -1 ? "all" : Integer.valueOf(this.solver.restarter.numRun));
            m.put("ccks", this.nCcks());
            m.put("nAssignments", this.nAssignments);
            m.put("wck", (double)this.searchWck / 1000.0);
            m.put("cpu", this.solver.rs.stopwatch.getCpuTimeInSeconds());
            m.put("mem", Kit.getFormattedUsedMemorySize());
            return m;
        }

        @Override
        public ProblemStuff.MapAtt cumulatedAttributes() {
            ProblemStuff.MapAtt m = new ProblemStuff.MapAtt("Global");
            m.put("ccks", this.nCcks());
            m.put("nAssignments", this.nAssignments);
            return m;
        }
    }

    public static final class StatisticsBacktrack
    extends Statistics {
        protected SolverBacktrack solver;

        public StatisticsBacktrack(SolverBacktrack solver) {
            super(solver);
            this.solver = solver;
        }

        @Override
        public ProblemStuff.MapAtt runAttributes() {
            ProblemStuff.MapAtt m = new ProblemStuff.MapAtt("Run");
            if (this.solver.rs.cp.competitionMode) {
                m.put("run", this.solver.restarter.numRun);
                m.put("depth", this.solver.minDepth + ".." + this.solver.maxDepth);
                m.put("#filters", this.nEffectiveFilterings());
                m.put("#wrong", this.nWrongDecisions);
                m.put("mem", Kit.getFormattedUsedMemorySize());
                m.put("wck", (double)this.stopwatch.getWckTime() / 1000.0);
                if (this.solver.learnerNogoods != null) {
                    m.putPositive("#nogoods", this.solver.learnerNogoods.nNogoods);
                }
                if (this.solver.solManager.nSolutionsFound > 0L) {
                    m.put("#sols", this.solver.solManager.nSolutionsFound);
                    if (this.solver.pb.framework != Types.TypeFramework.CSP) {
                        m.put("bound", nformat.format(this.solver.solManager.bestBound));
                    }
                }
                return m;
            }
            m.put("num", this.solver.restarter.numRun);
            m.put("depth", this.solver.minDepth + ".." + this.solver.maxDepth);
            m.put("filters", this.nEffectiveFilterings());
            m.put("revisions", "(" + this.nRevisions() + ",useless=" + this.nUselessRevisions() + ")", this.nRevisions() > 0L);
            m.putPositive("ccks", this.nCcks());
            if (this.nSingletonTests() > 0L) {
                m.put("nSingletonTests", this.nSingletonTests());
                m.put("nEffectiveSingletonTests", this.nEffectiveSingletonTests());
            }
            m.put("wck", (double)this.stopwatch.getWckTime() / 1000.0);
            m.put("mem", Kit.getFormattedUsedMemorySize());
            m.separator();
            m.put("decisions", this.nDecisions);
            m.put("wrong", this.nWrongDecisions);
            m.put("backtracks", this.nBacktracks);
            m.put("failedAssignments", this.nFailedAssignments);
            if (this.solver.learnerNogoods != null) {
                m.putPositive("nogoods", this.solver.learnerNogoods.nNogoods);
            }
            if (this.solver.solManager.nSolutionsFound > 0L) {
                m.put("foundSolutions", this.solver.solManager.nSolutionsFound);
                if (this.solver.pb.framework != Types.TypeFramework.CSP) {
                    m.put("bestBound", this.solver.solManager.bestBound);
                }
            }
            m.separator();
            if (this.solver.pb.stuff.nFilterCallsSTR > 0) {
                m.put("nFilterCalls", this.solver.pb.stuff.nFilterCallsSTR);
                m.put("avgTableProportion", (int)(this.solver.pb.stuff.sumTableProportionsSTR / (double)this.solver.pb.stuff.nFilterCallsSTR * 100.0));
                m.put("avgTableSize", (int)(this.solver.pb.stuff.sumTableSizesSTR / (double)this.solver.pb.stuff.nFilterCallsSTR));
                m.separator();
            }
            if (this.solver.learnerStates != null && this.solver.learnerStates instanceof LearnerStatesEquivalence && !this.solver.learnerStates.isStopped()) {
                LearnerStatesEquivalence learner = (LearnerStatesEquivalence)this.solver.learnerStates;
                m.put("mapSize", learner.getMapSize());
                m.put("nInferences", learner.nbInferences);
                m.put("nTooLargeKeys", learner.nbTooLargeKeys);
                m.separator();
            }
            if (this.solver.learnerStates != null) {
                ReductionOperator ro = this.solver.learnerStates.reductionOperator;
                m.put("nSEliminables", Kit.decimalFormat.format(ro.getProportionOfNbSEliminableVariables()));
                m.put("nREliminables", Kit.decimalFormat.format(ro.getProportionOfNbREliminableVariables()));
                m.put("nIEliminables", Kit.decimalFormat.format(ro.getProportionOfNbIEliminableVariables()));
                m.put("nDEliminables", Kit.decimalFormat.format(ro.getProportionOfNbDEliminableVariables()));
                m.put("nPEliminables", Kit.decimalFormat.format(ro.getProportionOfNbPEliminableVariables()));
                m.separator();
            }
            return m;
        }

        @Override
        public ProblemStuff.MapAtt cumulatedAttributes() {
            ProblemStuff.MapAtt m = new ProblemStuff.MapAtt("Global");
            m.put("filters", this.nEffectiveFilterings());
            m.put("revisions", "(" + this.nRevisions() + ",useless=" + this.nUselessRevisions() + ")", this.nRevisions() > 0L);
            m.putPositive("ccks", this.nCcks());
            if (this.nSingletonTests() > 0L) {
                m.put("nSingletonTests", this.nSingletonTests());
                m.put("nEffectiveSingletonTests", this.nEffectiveSingletonTests());
            }
            if (this.solver.learnerNogoods != null) {
                m.putPositive("nogoods", this.solver.learnerNogoods.nNogoods);
            }
            m.separator();
            return m;
        }
    }
}

