/*
 * Decompiled with CFR 0.152.
 */
package search.local;

import search.local.SolverLocal;
import variables.Variable;

public abstract class TabuManager {
    public abstract void push(Variable var1, int var2);

    public abstract boolean isTabu(Variable var1, int var2);

    public static class TabuManagerVariableValue
    extends TabuManager {
        private boolean[][] tabus;
        private int[] t1;
        private int[] t2;
        private int head;

        public TabuManagerVariableValue(SolverLocal solver, int tabuListSize) {
            if (tabuListSize > 0) {
                this.tabus = Variable.litterals(solver.pb.variables).booleanArray();
                this.t1 = new int[tabuListSize];
                this.t2 = new int[tabuListSize];
            }
        }

        @Override
        public void push(Variable x, int a) {
            if (!this.tabus[x.num][a]) {
                this.tabus[this.t1[this.head]][this.t2[this.head]] = false;
                this.tabus[x.num][a] = true;
                this.t1[this.head] = x.num;
                this.t2[this.head] = a;
                this.head = (this.head + 1) % this.t1.length;
            }
        }

        @Override
        public boolean isTabu(Variable x, int a) {
            return this.tabus != null && this.tabus[x.num][a];
        }
    }

    public static class TabuManagerVariable
    extends TabuManager {
        private boolean[] tabus;
        private int[] t1;
        private int head;

        public TabuManagerVariable(SolverLocal solver, int tabuListSize) {
            if (tabuListSize > 0) {
                this.tabus = new boolean[solver.pb.variables.length];
                this.t1 = new int[tabuListSize];
            }
        }

        @Override
        public void push(Variable x, int a) {
            if (!this.tabus[x.num]) {
                this.tabus[this.t1[this.head]] = false;
                this.tabus[x.num] = true;
                this.t1[this.head] = x.num;
                this.head = (this.head + 1) % this.t1.length;
            }
        }

        @Override
        public boolean isTabu(Variable x, int a) {
            return this.tabus != null && this.tabus[x.num];
        }
    }
}

