/*
 * Decompiled with CFR 0.152.
 */
package search.local;

import executables.Resolution;
import interfaces.ObserverBacktracking;
import org.xcsp.common.Types;
import problems.rand.ExplicitRandomQuestion;
import search.Solver;
import search.local.ConflictManager;
import search.local.HeuristicNeighbors;
import search.local.functionalPropagators.FunctionalPropagator;
import search.statistics.Statistics;
import utility.Kit;
import utility.Reflector;
import variables.Variable;

public final class SolverLocal
extends Solver {
    protected final HeuristicNeighbors neighborHeuristic;
    public final ConflictManager conflictManager;
    protected Statistics.StatisticsLocal localStatistics;
    public long nMinViolatedCtrs = Long.MAX_VALUE;
    public long nIterations;
    public int[] forcedInstantiation;
    public Variable[] decisionVars;
    private int[] num2DecisionVarsIndex;
    private int[][] successors;
    private int[][] predecessors;
    protected FunctionalPropagator[] propagators;
    private boolean[] forced;
    private int[] tmp;
    private double initialBiasForForcedSolution = 0.0;

    public SolverLocal(Resolution resolution) {
        super(resolution);
        this.neighborHeuristic = Reflector.buildObject(resolution.cp.nghh.classForNeighborHeuristic, HeuristicNeighbors.class, this);
        this.conflictManager = new ConflictManager(this);
        this.localStatistics = new Statistics.StatisticsLocal(this);
        this.stats = this.localStatistics;
        this.nIterations = resolution.cp.restarting.cutoff == -2L ? (long)(10 * this.pb.variables.length) : resolution.cp.restarting.cutoff;
    }

    private int[] buildNewCompleteInstantiationFrom(int[] initialCompleteInstantiation, double bias) {
        assert (this.pb.variables.length == initialCompleteInstantiation.length);
        Variable[] variables = this.pb.variables;
        if (this.forced == null) {
            this.forced = new boolean[variables.length];
            this.tmp = new int[variables.length];
        }
        long nPreservedValues = Math.round(bias * (double)variables.length);
        int i = 0;
        while ((long)i < nPreservedValues) {
            int position = this.rs.random.nextInt(variables.length);
            while (this.forced[position]) {
                position = this.rs.random.nextInt(variables.length);
            }
            this.tmp[position] = initialCompleteInstantiation[position];
            this.forced[position] = true;
            ++i;
        }
        for (i = 0; i < variables.length; ++i) {
            if (this.forced[i]) continue;
            if (variables[i].dom.size() == 1) {
                this.tmp[i] = variables[i].dom.unique();
                continue;
            }
            int a = variables[i].dom.random();
            while (a == initialCompleteInstantiation[i]) {
                a = variables[i].dom.random();
            }
            this.tmp[i] = a;
        }
        return this.tmp;
    }

    protected void buildInitialCompleteInstantiation() {
        if (this.forcedInstantiation == null && this.pb.api instanceof ExplicitRandomQuestion && ((ExplicitRandomQuestion)this.pb.api).forcedSolution != null) {
            this.forcedInstantiation = ((ExplicitRandomQuestion)this.pb.api).forcedSolution;
        }
        if (this.forcedInstantiation != null) {
            this.forcedInstantiation = this.initialBiasForForcedSolution > 0.0 ? this.buildNewCompleteInstantiationFrom(this.forcedInstantiation, this.initialBiasForForcedSolution) : this.forcedInstantiation;
        }
        this.propagateDependentVariables();
        this.conflictManager.initializeConflictingConstraints();
    }

    public void propagateDependentVariables() {
        for (FunctionalPropagator propagator : this.propagators) {
            propagator.propagate();
        }
    }

    @Override
    public Solver doRun() {
        this.buildInitialCompleteInstantiation();
        int cnt = 1;
        while ((long)cnt <= this.nIterations) {
            if (this.conflictManager.nConflictingConstraints() == 0) {
                if (this.pb.framework != Types.TypeFramework.COP || this.pb.optimizationPilot.value() < this.solManager.bestBound) {
                    this.solManager.handleNewSolution(true);
                }
                if (!this.finished() && this.pb.framework == Types.TypeFramework.CSP) {
                    this.buildInitialCompleteInstantiation();
                }
            }
            if (this.finished()) break;
            this.neighborHeuristic.setBestNeighbor();
            ++this.localStatistics.nAssignments;
            if (this.conflictManager.nConflictingConstraints() == 0) {
                Kit.log.fine("Current cost : " + this.pb.optimizationPilot.value());
            }
            if ((long)this.conflictManager.nConflictingConstraints() < this.nMinViolatedCtrs) {
                this.nMinViolatedCtrs = this.conflictManager.nConflictingConstraints();
            }
            if (cnt % 100 == 0) {
                Kit.log.fine("\tconflicts=" + this.conflictManager.nConflictingConstraints() + "(" + this.conflictManager.currEvaluation() + "), upperBound=" + this.nMinViolatedCtrs + " time=" + this.rs.instanceStopwatch.getWckTime() + " nbIterations=" + cnt);
            }
            ++cnt;
        }
        return this;
    }

    @Override
    public void pushVariable(ObserverBacktracking.ObserverBacktrackingUnsystematic variable) {
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void assign(Variable x, int a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void backtrack(Variable x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void backtrack() {
        throw new UnsupportedOperationException();
    }

    public int[] getSuccessors(int num) {
        return this.successors[this.num2DecisionVarsIndex[num]];
    }

    public int[] getPredecessors(int num) {
        return this.predecessors[num];
    }
}

