/*
 * Decompiled with CFR 0.152.
 */
package search.local;

import java.util.Random;
import org.xcsp.common.Types;
import search.local.SolverLocal;
import search.local.TabuManager;
import utility.Reflector;
import variables.Variable;
import variables.domains.Domain;

public abstract class HeuristicNeighbors {
    protected final SolverLocal solver;
    protected final TabuManager tabuManager;
    protected final int[] counters;
    protected final Random random;
    protected Variable bestVariable;
    protected int bestIndex;
    protected int bestEvolution;
    protected int localBestEvolution;
    protected Long currentCost = new Long(0L);
    protected long bestCost;
    protected Variable lastAssignedVariable;
    protected int bestEvaluationEverSeen = Integer.MAX_VALUE;
    protected double bestCostEverSeen = Double.MAX_VALUE;

    public HeuristicNeighbors(SolverLocal solver) {
        this.solver = solver;
        this.tabuManager = Reflector.buildObject(solver.rs.cp.nghh.classForTabu, TabuManager.class, solver, solver.rs.cp.nghh.tabuListSize);
        this.counters = new int[solver.pb.variables.length];
        this.random = solver.rs.random;
    }

    protected int selectIndexWithLowestEvolution(Variable x, int evolutionLimit) {
        int tieSize = 0;
        int bestIndex = -1;
        this.localBestEvolution = evolutionLimit;
        this.bestCost = Long.MAX_VALUE;
        Domain dom = x.dom;
        int a = dom.first();
        while (a != -1) {
            block15: {
                int evolution;
                block17: {
                    block16: {
                        evolution = this.solver.conflictManager.computeEvolutionFor(x, a, this.localBestEvolution, this.currentCost);
                        if (evolution > this.localBestEvolution) break block15;
                        if (this.solver.conflictManager.currEvaluation() + evolution >= this.bestEvaluationEverSeen) break block16;
                        this.bestEvaluationEverSeen = this.solver.conflictManager.currEvaluation() + evolution;
                        break block17;
                    }
                    if (this.tabuManager.isTabu(x, a)) break block15;
                }
                if (evolution < this.localBestEvolution) {
                    tieSize = 1;
                    bestIndex = a;
                    this.localBestEvolution = evolution;
                    if (this.solver.pb.framework == Types.TypeFramework.COP) {
                        this.bestCost = this.currentCost;
                    }
                } else {
                    assert (evolution == this.localBestEvolution);
                    if (this.solver.pb.framework == Types.TypeFramework.COP) {
                        if (this.currentCost <= this.bestCost) {
                            if (this.currentCost < this.bestCost) {
                                this.bestCost = this.currentCost;
                                tieSize = 1;
                                bestIndex = a;
                                this.localBestEvolution = evolution;
                            } else {
                                ++tieSize;
                                if (this.random.nextDouble() < 1.0 / (double)tieSize) {
                                    bestIndex = a;
                                }
                            }
                        }
                    } else {
                        ++tieSize;
                        if (this.random.nextDouble() < 1.0 / (double)tieSize) {
                            bestIndex = a;
                        }
                    }
                }
            }
            a = dom.next(a);
        }
        this.currentCost = this.bestCost;
        return bestIndex;
    }

    public abstract void selectNeighbor();

    public void setBestNeighbor() {
        this.selectNeighbor();
        this.solver.propagateDependentVariables();
        this.tabuManager.push(this.bestVariable, this.bestIndex);
        this.lastAssignedVariable = this.bestVariable;
        int n = this.bestVariable.num;
        this.counters[n] = this.counters[n] + 1;
        this.solver.conflictManager.recomputeEvaluations();
        assert (this.solver.conflictManager.checkConflictingConstraints());
    }

    public static class BestLocal
    extends HeuristicNeighbors {
        public BestLocal(SolverLocal solver) {
            super(solver);
        }

        private Variable selectVariableWithLowestEvaluation() {
            int tieSize = 0;
            Variable bestVariable = null;
            int bestEvaluation = Integer.MAX_VALUE;
            for (Variable x : this.solver.pb.variables) {
                if (x == this.lastAssignedVariable) continue;
                int evaluation = this.solver.conflictManager.currEvaluationOf(x);
                if (evaluation < bestEvaluation) {
                    tieSize = 1;
                    bestVariable = x;
                    bestEvaluation = evaluation;
                    continue;
                }
                if (evaluation != bestEvaluation) continue;
                ++tieSize;
                if (!(this.random.nextDouble() < 1.0 / (double)tieSize)) continue;
                bestVariable = x;
            }
            return bestVariable;
        }

        private boolean randomlySelectNeighbor() {
            if ((double)this.random.nextFloat() < this.solver.rs.cp.nghh.thresholdForRandomVariableSelection) {
                Variable[] variables = this.solver.pb.variables;
                this.bestVariable = variables[this.random.nextInt(variables.length)];
                if ((double)this.random.nextFloat() < this.solver.rs.cp.nghh.thresholdForRandomValueSelection) {
                    this.bestIndex = this.bestVariable.dom.random();
                    int evaluation = this.solver.conflictManager.currEvaluation() + this.solver.conflictManager.computeEvolutionFor(this.bestVariable, this.bestIndex);
                    if (evaluation < this.bestEvaluationEverSeen) {
                        this.bestEvaluationEverSeen = evaluation;
                    }
                    return !this.tabuManager.isTabu(this.bestVariable, this.bestIndex);
                }
                this.bestIndex = this.selectIndexWithLowestEvolution(this.bestVariable, Integer.MAX_VALUE);
                return true;
            }
            return false;
        }

        @Override
        public void selectNeighbor() {
            if (!this.randomlySelectNeighbor()) {
                this.bestVariable = this.selectVariableWithLowestEvaluation();
                this.bestIndex = this.selectIndexWithLowestEvolution(this.bestVariable, Integer.MAX_VALUE);
            }
        }
    }

    public static class BestGlobal
    extends HeuristicNeighbors {
        private int evaluationLimit = 0;

        public BestGlobal(SolverLocal solver) {
            super(solver);
        }

        private void assess(Variable x, boolean b) {
            if (x == this.lastAssignedVariable || x.dom.size() == 1) {
                return;
            }
            int variableEvaluation = this.solver.conflictManager.currEvaluationOf(x);
            if (this.bestEvolution < -variableEvaluation || variableEvaluation < this.evaluationLimit == b) {
                return;
            }
            int idx = this.selectIndexWithLowestEvolution(x, this.bestEvolution);
            if (idx == -1) {
                return;
            }
            assert (this.localBestEvolution <= this.bestEvolution);
            if (this.localBestEvolution < this.bestEvolution) {
                this.bestVariable = x;
                this.bestIndex = idx;
                this.bestEvolution = this.localBestEvolution;
            } else {
                assert (this.localBestEvolution == this.bestEvolution);
                if (this.counters[x.num] < this.counters[this.bestVariable.num]) {
                    this.bestVariable = x;
                    this.bestIndex = idx;
                }
            }
        }

        @Override
        public void selectNeighbor() {
            int position;
            int i;
            this.bestVariable = null;
            this.bestIndex = -1;
            this.bestEvolution = Integer.MAX_VALUE;
            Variable[] variables = this.solver.decisionVars;
            for (i = position = this.random.nextInt(variables.length); i < variables.length; ++i) {
                this.assess(variables[i], true);
            }
            for (i = 0; i < position; ++i) {
                this.assess(variables[i], true);
            }
            if (this.evaluationLimit != 0 && this.bestEvolution > -this.evaluationLimit) {
                for (i = position; i < variables.length; ++i) {
                    this.assess(variables[i], false);
                }
                for (i = 0; i < position; ++i) {
                    this.assess(variables[i], false);
                }
            }
        }
    }
}

