/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.decomposers;

import executables.Resolution;
import interfaces.TagExperimental;
import search.backtrack.SolverBacktrack;
import search.backtrack.decomposers.Decomposer;
import utility.Reflector;
import variables.Variable;

public final class SolverBacktrackDecomposing
extends SolverBacktrack
implements TagExperimental {
    public Decomposer[] decomposers;
    public int top = -1;

    public void setDomainsMarks(int level) {
        for (Variable x : this.pb.variables) {
            x.dom.setMark(level);
        }
    }

    public void restoreDomainsAtMarks(int level) {
        for (Variable x : this.pb.variables) {
            x.dom.restoreAtMark(level);
        }
    }

    public void pushVariable(Variable var) {
    }

    @Override
    protected void manageEmptyDomainBeforeBacktracking() {
        ++this.backtrackStatistics.nBacktracks;
    }

    public SolverBacktrackDecomposing(Resolution resolution) {
        super(resolution);
        this.decomposers = new Decomposer[Variable.nValidValuesFor(resolution.problem.variables) + 1];
    }

    private void branchingFor(Variable x) {
        ++this.top;
        if (this.decomposers[this.top] == null) {
            this.decomposers[this.top] = Reflector.buildObject(this.rs.cp.hardCoding.classForDecompositionSolver, Decomposer.class, this);
        }
        Decomposer decomposer = this.decomposers[this.top];
        decomposer.initialize(x);
        int a = x.heuristicVal.bestIndex();
        assert (!(decomposer instanceof Decomposer.DecomposerRDAC2) || x.dom.size() == 1 || a == ((Decomposer.DecomposerRDAC2)decomposer).getIndex());
        if (this.tryAssignment(x, a)) {
            this.explore();
        }
        this.backtrack(x);
        if (!this.finished() && !this.restarter.currRunFinished() && this.tryRefutation(x, a)) {
            decomposer.split();
            if (decomposer.getNbPieces() == 1) {
                this.explore();
            } else {
                int res;
                this.setDomainsMarks(this.top);
                for (int num = 0; num < decomposer.getNbPieces() && (res = decomposer.buildPiece(num)) != -1; ++num) {
                    if (res == 1) {
                        this.explore();
                    }
                    if (num >= decomposer.getNbPieces() - 1) continue;
                    this.restoreDomainsAtMarks(this.top);
                }
            }
        }
        --this.top;
    }

    @Override
    public void explore() {
        if (this.futVars.size() == 0) {
            this.solManager.handleNewSolutionAndPossiblyOptimizeIt();
        } else if (!this.finished() && !this.restarter.currRunFinished()) {
            this.branchingFor(this.heuristicVars.bestVar());
        }
    }
}

