/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack.decomposers;

import constraints.Constraint;
import constraints.CtrHard;
import heuristics.values.HeuristicValuesDynamic;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import propagation.soft.pfc.RDAC;
import search.backtrack.decomposers.SolverBacktrackDecomposing;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public abstract class Decomposer {
    protected SolverBacktrackDecomposing solver;

    public Decomposer(SolverBacktrackDecomposing solver) {
        this.solver = solver;
    }

    protected BigInteger nMaxValidTuples() {
        return Stream.of(this.solver.pb.constraints).map(c -> Variable.nValidTuples(c.scp, false)).max(BigInteger::compareTo).get();
    }

    public abstract int getNbPieces();

    public abstract void initialize(Variable var1);

    public abstract void split();

    public abstract int buildPiece(int var1);

    public class DecomposerRDAC2
    extends Decomposer {
        private RDAC rdac;
        private Variable var;
        private int a;
        private int k;
        private int nbConstraintsToBeViolated;
        private Constraint[] constraintsToBeViolated;
        private boolean active;
        private int offset;

        public int getIndex() {
            return this.a;
        }

        public DecomposerRDAC2(SolverBacktrackDecomposing solver) {
            super(solver);
            Problem problem = solver.pb;
            this.rdac = (RDAC)solver.propagation;
            Kit.control(problem.variables[0].heuristicVal instanceof HeuristicValuesDynamic.Aic);
            this.constraintsToBeViolated = new Constraint[problem.stuff.maxVarDegree()];
        }

        @Override
        public int getNbPieces() {
            return 1;
        }

        private int getAicOf(Variable x) {
            int[] aic = this.rdac.aic[x.num];
            this.offset = Integer.MAX_VALUE;
            Domain dom = x.dom;
            int bestIndex = dom.first();
            int idx = dom.next(bestIndex);
            while (idx != -1) {
                if (aic[idx] < aic[bestIndex]) {
                    bestIndex = idx;
                    this.offset = aic[bestIndex] - aic[idx];
                } else {
                    this.offset = Math.min(this.offset, aic[idx] - aic[bestIndex]);
                }
                idx = dom.next(idx);
            }
            return bestIndex;
        }

        @Override
        public void initialize(Variable x) {
            assert (!x.isAssigned() && this.rdac.control());
            this.var = x;
            this.active = false;
            if (x.dom.size() == 1) {
                return;
            }
            this.a = this.getAicOf(x);
            assert (this.a == x.heuristicVal.bestIndex());
            this.k = this.offset + 1;
            long[][][] minCosts = this.rdac.minCosts;
            this.nbConstraintsToBeViolated = 0;
            for (Constraint c : x.ctrs) {
                if (c.futvars.size() == 1) continue;
                int i = c.num;
                int j = c.positionOf(x);
                assert (((CtrHard)c).seekFirstSupportWith(j, this.a) != minCosts[i][j][this.a] > 0L);
                if (minCosts[i][j][this.a] > 0L) continue;
                this.constraintsToBeViolated[this.nbConstraintsToBeViolated++] = c;
            }
        }

        @Override
        public void split() {
            this.active = true;
        }

        @Override
        public int buildPiece(int num) {
            return 1;
        }

        public boolean isSatisfied() {
            if (!this.active) {
                return true;
            }
            int cnt = 0;
            for (int i = 0; cnt < this.k && i < this.nbConstraintsToBeViolated; ++i) {
                if (!((CtrHard)this.constraintsToBeViolated[i]).seekFirstConflictWith(this.constraintsToBeViolated[i].positionOf(this.var), this.a)) continue;
                if (cnt < i) {
                    Kit.swap(this.constraintsToBeViolated, cnt, i);
                }
                ++cnt;
            }
            return cnt >= this.k;
        }
    }

    public static class DecomposerRDAC1
    extends Decomposer {
        private RDAC rdac;
        private int[] idOfACNeighbors;
        private int[] nbConsistentValuesOfACNeighbors;
        private int[][] consistentValuesOfACNeighbors;
        private int nbPieces;

        public DecomposerRDAC1(SolverBacktrackDecomposing solver) {
            super(solver);
            Problem problem = solver.pb;
            this.idOfACNeighbors = new int[problem.stuff.maxVarDegree()];
            this.nbConsistentValuesOfACNeighbors = new int[problem.stuff.maxVarDegree()];
            this.consistentValuesOfACNeighbors = new int[problem.stuff.maxVarDegree()][this.nMaxValidTuples().intValueExact()];
            this.rdac = (RDAC)solver.propagation;
            Kit.control(problem.variables[0].heuristicVal instanceof HeuristicValuesDynamic.Aic);
        }

        @Override
        public int getNbPieces() {
            return this.nbPieces;
        }

        @Override
        public void initialize(Variable x) {
            int a = x.heuristicVal.bestIndex();
            this.rdac.init(false);
            assert (this.rdac.control());
            long[][][] minCosts = this.rdac.minCosts;
            assert (this.rdac.control());
            int nbACNeighbors = 0;
            Constraint[] constraintArray = x.ctrs;
            int n = constraintArray.length;
            for (int i = 0; i < n; ++i) {
                int neighborPosition;
                Variable neighbor;
                Constraint c;
                int i2 = c.num;
                c = constraintArray[i];
                int j = c.positionOf(x);
                if (minCosts[i2][j][a] > 0L || (neighbor = c.scp[neighborPosition = j == 0 ? 1 : 0]).isAssigned()) continue;
                this.idOfACNeighbors[nbACNeighbors] = neighbor.num;
                int cnt = 0;
                int[] t = this.consistentValuesOfACNeighbors[nbACNeighbors];
                int[] tmp = c.tupleManager.localTuple;
                tmp[j] = a;
                Domain dom = neighbor.dom;
                int b = dom.first();
                while (b != -1) {
                    tmp[neighborPosition] = b;
                    if (((CtrHard)c).checkIndexes(tmp)) {
                        t[cnt++] = b;
                    }
                    b = dom.next(b);
                }
                this.nbConsistentValuesOfACNeighbors[nbACNeighbors] = cnt;
                ++nbACNeighbors;
            }
            this.nbPieces = nbACNeighbors;
        }

        @Override
        public void split() {
        }

        @Override
        public int buildPiece(int num) {
            int i2;
            Domain dom;
            int[] t;
            int limit;
            Variable neighbor;
            Variable[] variables = this.solver.pb.variables;
            if (num > 0) {
                neighbor = variables[this.idOfACNeighbors[num - 1]];
                limit = this.nbConsistentValuesOfACNeighbors[num - 1];
                t = this.consistentValuesOfACNeighbors[num - 1];
                assert (IntStream.range(1, limit).allMatch(i -> t[i - 1] < t[i]));
                dom = neighbor.dom;
                i2 = 0;
                int neighborIndex = dom.first();
                while (neighborIndex != -1) {
                    while (i2 < limit && t[i2] < neighborIndex) {
                        ++i2;
                    }
                    assert ((i2 == limit || t[i2] > neighborIndex) == Arrays.binarySearch(t, 0, limit, neighborIndex) < 0);
                    if (i2 == limit || t[i2] > neighborIndex) {
                        neighbor.dom.removeElementary(neighborIndex);
                    }
                    neighborIndex = dom.next(neighborIndex);
                }
                if (dom.size() == 0 || !this.rdac.go(false)) {
                    return -1;
                }
                this.solver.setDomainsMarks(this.solver.top);
            }
            neighbor = variables[this.idOfACNeighbors[num]];
            limit = this.nbConsistentValuesOfACNeighbors[num];
            t = this.consistentValuesOfACNeighbors[num];
            dom = neighbor.dom;
            for (i2 = 0; i2 < limit; ++i2) {
                if (!dom.isPresent(t[i2])) continue;
                dom.removeElementary(t[i2]);
            }
            return dom.size() > 0 && this.rdac.go(false) ? 1 : 0;
        }
    }

    public static class DecomposerSplitter
    extends Decomposer {
        private Variable var;
        private int nbPieces;
        private Variable varo;
        private int[] t = new int[this.nMaxValidTuples().intValueExact()];
        private int tlength;

        public DecomposerSplitter(SolverBacktrackDecomposing solver) {
            super(solver);
        }

        @Override
        public int getNbPieces() {
            return this.nbPieces;
        }

        @Override
        public void initialize(Variable var) {
            this.var = var;
        }

        @Override
        public void split() {
            this.varo = this.solver.heuristicVars.bestVar();
            Domain dom = this.varo.dom;
            int size = dom.size();
            if (this.varo == this.var || size == 1) {
                this.nbPieces = 1;
            } else {
                int i = 0;
                int a = dom.first();
                while (a != -1) {
                    this.t[i++] = a;
                    a = dom.next(a);
                }
                this.tlength = i;
                this.nbPieces = 2;
            }
        }

        @Override
        public int buildPiece(int num) {
            if (this.nbPieces == 1) {
                return 1;
            }
            if (num == 0) {
                for (int i = 0; i < this.tlength / 2; ++i) {
                    this.varo.dom.removeElementary(this.t[i]);
                }
            } else {
                for (int i = this.tlength / 2; i < this.tlength; ++i) {
                    this.varo.dom.removeElementary(this.t[i]);
                }
            }
            return this.solver.propagation.runAfterRefutation(this.varo) ? 1 : 0;
        }
    }

    public static class DecomposerVoid
    extends Decomposer {
        @Override
        public int getNbPieces() {
            return 1;
        }

        @Override
        public void initialize(Variable x) {
        }

        @Override
        public void split() {
        }

        @Override
        public int buildPiece(int num) {
            return 1;
        }

        public DecomposerVoid(SolverBacktrackDecomposing solver) {
            super(solver);
        }
    }
}

