/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack;

import constraints.Constraint;
import constraints.hard.global.HammingProximityConstant;
import interfaces.FilteringSpecific;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import objectives.OptimizationPilot;
import org.xcsp.common.IVar;
import org.xcsp.modeler.entities.CtrEntities;
import problem.Problem;
import search.Restarter;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public final class RestarterLocalBranching
extends Restarter {
    private boolean currentlyBranching;
    private int nRestartsSinceActive = 0;
    private int currDistance;
    private LocalBranchingConstraint localBranchingConstraints;

    public RestarterLocalBranching(Solver solver) {
        super(solver);
        this.currDistance = this.solver.rs.cp.lb.baseDistance;
        this.localBranchingConstraints = this.solver.pb.localBranchingConstraints;
        Kit.control(solver instanceof SolverBacktrack, () -> "For local branching, only a SolverBacktrack can be used.");
        Kit.control(solver.pb.optimizationPilot instanceof OptimizationPilot.OptimizationPilotDecreasing, () -> "For local branching, only OptimizationPilotDecreasing can be used.");
    }

    public void enterLocalBranching() {
        this.currentlyBranching = true;
        this.nRestartsSinceActive = 0;
    }

    private void leaveLocalBranching() {
        this.currentlyBranching = false;
        this.localBranchingConstraints.setIgnored(true);
        this.currDistance = this.solver.rs.cp.lb.baseDistance;
    }

    @Override
    public void beforeRun() {
        if (this.currentlyBranching) {
            ++this.nRestartsSinceActive;
        }
        super.beforeRun();
    }

    @Override
    public void afterRun() {
        if (this.currentlyBranching) {
            if (this.solver.stoppingType == Enums.EStopping.FULL_EXPLORATION || this.forceRootPropagation) {
                Kit.control(this.solver.pb.stuff.nValuesRemovedAtConstructionTime == 0, () -> "Not handled for the moment");
                if (this.solver.stoppingType == Enums.EStopping.FULL_EXPLORATION) {
                    this.solver.stoppingType = null;
                    ++this.currDistance;
                    if (this.solver.pb.optimizationPilot.areBoundsConsistent()) {
                        this.forceRootPropagation = true;
                    }
                }
                if (this.forceRootPropagation) {
                    super.afterRun();
                    this.currDistance = this.solver.rs.cp.lb.baseDistance;
                }
                this.localBranchingConstraints.updateWithNewSolution(this.solver.solManager.lastSolution, this.currDistance);
                this.localBranchingConstraints.setIgnored(false);
                ((SolverBacktrack)this.solver).restoreProblem();
                if (((SolverBacktrack)this.solver).learnerNogoods != null) {
                    ((SolverBacktrack)this.solver).learnerNogoods.reset();
                }
                ((FilteringSpecific)((Object)this.solver.pb.optimizationPilot.ctr)).runPropagator(null);
            }
            if (this.nRestartsSinceActive > this.solver.rs.cp.lb.maxRestarts) {
                this.leaveLocalBranching();
            }
        } else {
            super.afterRun();
        }
    }

    public static abstract class LocalBranchingConstraint {
        protected Constraint c;
        protected final Variable[] decisionVars;
        private final int[] decisionVaps;

        public LocalBranchingConstraint(Problem pb) {
            this.decisionVars = (Variable[])Stream.of(pb.variables).toArray(Variable[]::new);
            this.decisionVaps = Kit.range(pb.variables.length);
            for (int i = 0; i < this.decisionVaps.length; ++i) {
                int min = this.decisionVaps[i];
                int minPos = i;
                for (int j = i + 1; j < this.decisionVaps.length; ++j) {
                    if (this.decisionVaps[j] >= min) continue;
                    min = this.decisionVaps[j];
                    minPos = j;
                }
                if (minPos == i) continue;
                this.decisionVaps[minPos] = this.decisionVaps[i];
                this.decisionVaps[i] = min;
                Variable tmp = this.decisionVars[i];
                this.decisionVars[i] = this.decisionVars[minPos];
                this.decisionVars[minPos] = tmp;
            }
        }

        public int[] toDecisionVals(int[] completeInstantiationIdxs) {
            ArrayList<Integer> decisionIdxs = new ArrayList<Integer>();
            for (int i = 0; i < this.decisionVaps.length; ++i) {
                decisionIdxs.add(completeInstantiationIdxs[this.decisionVaps[i]]);
            }
            int[] decisionVals = new int[decisionIdxs.size()];
            for (int i = 0; i < decisionVals.length; ++i) {
                decisionVals[i] = this.decisionVars[i].dom.toVal((Integer)decisionIdxs.get(i));
            }
            return decisionVals;
        }

        public abstract void modifyConstraint(int[] var1, int var2);

        public void updateWithNewSolution(int[] instantiationIdxs, int newDist) {
            this.modifyConstraint(this.toDecisionVals(instantiationIdxs), newDist);
        }

        public boolean isDecisionVap(int vap) {
            return Arrays.binarySearch(this.decisionVaps, vap) >= 0;
        }

        public void setIgnored(boolean b) {
            this.c.ignored = b;
        }

        public static class LBAtMostDistanceSum
        extends LocalBranchingConstraint {
            public LBAtMostDistanceSum(Problem problem) {
                super(problem);
                this.c = (Constraint)((CtrEntities.CtrAlone)problem.tupleProximityDistanceSum((IVar[])this.decisionVars, (int[])new int[this.decisionVars.length], (int)problem.rs.cp.lb.baseDistance)).ctr;
                this.c.ignored = true;
            }

            @Override
            public void modifyConstraint(int[] decisionVals, int newDist) {
                ((HammingProximityConstant.HammingProximityConstantSumLE)this.c).setTarget(decisionVals);
                ((HammingProximityConstant.HammingProximityConstantSumLE)this.c).setK(newDist);
            }
        }

        public static class LBAtLeastEqual
        extends LocalBranchingConstraint {
            public LBAtLeastEqual(Problem problem) {
                super(problem);
                int[] tuple = Stream.of(this.decisionVars).mapToInt(x -> x.dom.firstValue()).toArray();
                this.c = (Constraint)((CtrEntities.CtrAlone)problem.tupleProximityGE((IVar[])this.decisionVars, (int[])tuple, (int)(this.decisionVars.length - problem.rs.cp.lb.baseDistance), (boolean)true)).ctr;
                this.c.ignored = true;
            }

            @Override
            public void modifyConstraint(int[] decisionVals, int newDist) {
                ((HammingProximityConstant.HammingProximityConstantGE)this.c).setTarget(decisionVals);
                ((HammingProximityConstant.HammingProximityConstantGE)this.c).setK(newDist);
            }
        }
    }
}

