/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack;

import dashboard.ControlPanel;
import java.util.Random;
import java.util.stream.IntStream;
import search.Restarter;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;

public class RestarterLNS
extends Restarter {
    private final HeuristicFreezing h;

    public RestarterLNS(Solver solver) {
        super(solver);
        this.h = solver.rs.cp.lns.freezingHeuristic.equals(HeuristicFreezing.Impact.class.getName()) ? new HeuristicFreezing.Impact(this) : new HeuristicFreezing.Rand(this);
        Kit.control(solver instanceof SolverBacktrack, () -> "For LNS, only a SolverBacktrack object can be used.");
    }

    @Override
    public void beforeRun() {
        super.beforeRun();
        int[] solution = this.solver.solManager.lastSolution;
        if (solution != null) {
            this.h.freezeVariables(solution);
            for (int i = 0; i < this.h.freezingSize; ++i) {
                this.solver.assign(this.solver.pb.variables[this.h.freezingShuffled[i]], solution[this.h.freezingShuffled[i]]);
            }
            this.solver.propagation.runInitially();
        }
    }

    @Override
    public void afterRun() {
        ((SolverBacktrack)this.solver).backtrackToTheRoot();
    }

    public static abstract class HeuristicFreezing {
        protected final RestarterLNS restarter;
        public final int[] freezingShuffled;
        public int freezingSize;

        public HeuristicFreezing(RestarterLNS restarter) {
            this.restarter = restarter;
            int n = restarter.solver.pb.variables.length;
            ControlPanel.LargeNeighborhoodSearch setting = restarter.solver.rs.cp.lns;
            this.freezingShuffled = IntStream.range(0, n).toArray();
            if (0 < setting.nVariablesToFreeze && setting.nVariablesToFreeze < n) {
                this.freezingSize = restarter.solver.rs.cp.lns.nVariablesToFreeze;
            } else if (0 < setting.pVariablesToFreeze && setting.pVariablesToFreeze < 100) {
                this.freezingSize = 1 + setting.pVariablesToFreeze * n / 100;
            } else {
                Kit.exit("You must specify the number or percentage of variables to freeze for LNS.");
            }
            Kit.control(0 < this.freezingSize && this.freezingSize < restarter.solver.pb.variables.length, () -> "");
        }

        protected void shuffle() {
            Random random = this.restarter.solver.rs.random;
            for (int i = this.freezingShuffled.length - 1; i > 0; --i) {
                int j = random.nextInt(i + 1);
                int tmp = this.freezingShuffled[i];
                this.freezingShuffled[i] = this.freezingShuffled[j];
                this.freezingShuffled[j] = tmp;
            }
        }

        public abstract void freezeVariables(int[] var1);

        public static class Rand
        extends HeuristicFreezing {
            public Rand(RestarterLNS restarter) {
                super(restarter);
            }

            @Override
            public void freezeVariables(int[] solution) {
                this.shuffle();
            }
        }

        public static class Impact
        extends HeuristicFreezing {
            private final Variable[] variables;
            private int[] domainSizesBeforeFreezing;
            private int[] domainSizesAfterFreezing;

            public Impact(RestarterLNS restarter) {
                super(restarter);
                this.variables = restarter.solver.pb.variables;
                this.domainSizesBeforeFreezing = new int[this.variables.length];
                this.domainSizesAfterFreezing = new int[this.variables.length];
            }

            private void storeDomainSizes(int[] t) {
                for (int i = 0; i < this.variables.length; ++i) {
                    t[i] = this.variables[i].dom.size();
                }
            }

            @Override
            public void freezeVariables(int[] solution) {
                this.shuffle();
                Integer bestImpacted = null;
                for (int i = 0; i < this.freezingSize; ++i) {
                    if (bestImpacted != null) {
                        int tmp = this.freezingShuffled[bestImpacted];
                        this.freezingShuffled[bestImpacted.intValue()] = this.freezingShuffled[i];
                        this.freezingShuffled[i] = tmp;
                    }
                    this.restarter.solver.assign(this.variables[this.freezingShuffled[i]], solution[this.freezingShuffled[i]]);
                    this.storeDomainSizes(this.domainSizesBeforeFreezing);
                    this.restarter.solver.propagation.runInitially();
                    this.storeDomainSizes(this.domainSizesAfterFreezing);
                    bestImpacted = null;
                    int bestImpact = 0;
                    for (int j = i + 1; j < this.freezingShuffled.length; ++j) {
                        int impact = this.domainSizesBeforeFreezing[this.freezingShuffled[j]] - this.domainSizesAfterFreezing[this.freezingShuffled[j]];
                        if (impact <= bestImpact) continue;
                        bestImpacted = j;
                        bestImpact = impact;
                    }
                }
                ((SolverBacktrack)this.restarter.solver).backtrackToTheRoot();
            }
        }
    }
}

