/*
 * Decompiled with CFR 0.152.
 */
package search.backtrack;

import java.util.stream.IntStream;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.operations.Bit;
import utility.sets.SetDense;
import variables.Variable;

public final class DecisionRecorder {
    private final int OFFSET;
    public final SetDense decisions;
    private final byte[] failedAssignments;
    private final Variable[] variables;

    public final int positiveDecisionFor(int num, int idx) {
        return 1 + idx + this.OFFSET * num;
    }

    public final int negativeDecisionFor(int num, int idx) {
        return -(1 + idx + this.OFFSET * num);
    }

    public final int numIn(int dec) {
        return Math.abs(dec) / this.OFFSET;
    }

    public final Variable varIn(int dec) {
        return this.variables[Math.abs(dec) / this.OFFSET];
    }

    public final int idxIn(int dec) {
        return Math.abs(dec) % this.OFFSET - 1;
    }

    public final int valIn(int dec) {
        return this.varIn((int)dec).dom.toVal(this.idxIn(dec));
    }

    public void reset() {
        this.decisions.clear();
    }

    public boolean isFailedAssignment(int i) {
        assert (i < this.decisions.size());
        return Bit.isAt1(this.failedAssignments, i);
    }

    public DecisionRecorder(SolverBacktrack solver) {
        int n1 = (int)Math.ceil(Math.log(solver.pb.variables.length) / Math.log(2.0));
        int n2 = (int)Math.ceil(Math.log(solver.pb.stuff.maxDomSize()) / Math.log(2.0));
        Kit.control(n1 + n2 <= 32);
        this.OFFSET = (int)Math.pow(2.0, n2 + 1);
        int nValues = Variable.nInitValuesFor(solver.pb.variables);
        this.decisions = new SetDense(nValues);
        this.failedAssignments = new byte[nValues / 8 + 1];
        this.variables = solver.pb.variables;
    }

    public Variable varOfLastDecisionIf(boolean positive) {
        return this.decisions.limit >= 0 && this.decisions.last() >= 0 == positive ? this.varIn(this.decisions.last()) : null;
    }

    public boolean isLastButOneDecisionNegative() {
        return this.decisions.limit >= 1 && this.decisions.dense[this.decisions.limit - 1] < 0;
    }

    public void addPositiveDecision(Variable x, int a) {
        this.decisions.add(this.positiveDecisionFor(x.num, a));
        Bit.setTo0(this.failedAssignments, this.decisions.limit);
        assert (this.controlDecisions());
    }

    public void addNegativeDecision(Variable x, int a) {
        this.decisions.add(this.negativeDecisionFor(x.num, a));
        assert (this.controlDecisions());
    }

    public void delPositiveDecision(Variable x) {
        int[] dense = this.decisions.dense;
        int limit = this.decisions.limit;
        if (dense[limit] > 0) {
            Bit.setTo1(this.failedAssignments, limit);
        } else {
            while (dense[limit] < 0) {
                --limit;
            }
        }
        assert (dense[limit] > 0 && this.numIn(dense[limit]) == x.num) : this.toString();
        this.decisions.limit = limit - 1;
    }

    public final String stringOf(int dec) {
        assert (dec != 0);
        return this.varIn(dec) + (dec > 0 ? "=" : "!=") + this.valIn(dec) + (this.valIn(dec) != this.idxIn(dec) ? "(" + this.idxIn(dec) + ")" : "");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.decisions.size()).append(" decisions : ");
        for (int i = 0; i < this.decisions.size(); ++i) {
            sb.append(this.stringOf(this.decisions.dense[i])).append(this.isFailedAssignment(i) ? " x" : "").append("  ");
        }
        return sb.toString();
    }

    private boolean controlDecisions() {
        return IntStream.range(0, this.decisions.size()).allMatch(i -> this.decisions.dense[i] != 0 && IntStream.range(i + 1, this.decisions.size()).allMatch(j -> this.decisions.dense[i] != this.decisions.dense[j] && this.decisions.dense[i] != -this.decisions.dense[j]));
    }
}

