/*
 * Decompiled with CFR 0.152.
 */
package search;

import executables.Resolution;
import interfaces.ObserverBacktracking;
import interfaces.ObserverPropagation;
import interfaces.ObserverRuns;
import interfaces.ObserverSearch;
import interfaces.TagBinaryRelationFiltering;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import problem.Problem;
import propagation.Propagation;
import search.FutureVariables;
import search.Restarter;
import search.SolutionManager;
import search.backtrack.RestarterLNS;
import search.backtrack.RestarterLocalBranching;
import search.statistics.Statistics;
import utility.Enums;
import utility.Kit;
import utility.Reflector;
import variables.Variable;

public abstract class Solver {
    public final List<ObserverSearch> observersSearch;
    public List<ObserverRuns> observersRuns;
    public List<ObserverPropagation> observersPropagation;
    public final Resolution rs;
    public final Problem pb;
    public final FutureVariables futVars;
    public final SolutionManager solManager;
    public final Restarter restarter;
    public Propagation propagation;
    public Enums.EStopping stoppingType;
    public Statistics stats;

    public final boolean isFullExploration() {
        return this.stoppingType == Enums.EStopping.FULL_EXPLORATION;
    }

    public final boolean finished() {
        if (this.stoppingType != null) {
            return true;
        }
        if (this.rs.isTimeExpiredForCurrentInstance()) {
            this.stoppingType = Enums.EStopping.EXCEEDED_TIME;
            return true;
        }
        return false;
    }

    public final void resetNoSolutions() {
        this.stoppingType = null;
        this.solManager.nSolutionsFound = 0L;
    }

    public void reset(boolean preserveWeightedDegrees) {
        Kit.control(this.futVars.nDiscarded() == 0);
        Kit.control(!(this.propagation instanceof TagBinaryRelationFiltering), () -> "for the moment");
        this.propagation.reset();
        this.restarter.reset();
        this.resetNoSolutions();
    }

    public Solver(Resolution resolution) {
        this.rs = resolution;
        this.pb = resolution.problem;
        this.pb.solver = this;
        this.futVars = new FutureVariables(this.pb.variables);
        this.solManager = new SolutionManager(this, resolution.cp.setingGeneral.nSearchedSolutions);
        this.propagation = resolution.cp.solving.enablePrepro || resolution.cp.solving.enableSearch ? Reflector.buildObject(resolution.cp.propagating.clazz, Propagation.class, this) : null;
        Kit.control(!resolution.cp.lns.enabled || !resolution.cp.lb.enabled, () -> "Cannot use LNS and LB (local branching) at the same time.");
        Restarter restarter = resolution.cp.lns.enabled ? new RestarterLNS(this) : (this.restarter = resolution.cp.lb.enabled ? new RestarterLocalBranching(this) : new Restarter(this));
        if (!resolution.cp.propagating.useAuxiliaryQueues) {
            Stream.of(this.pb.constraints).forEach(c -> {
                c.filteringComplexity = 0;
            });
        }
        this.observersSearch = Stream.of(this.pb.constraints).filter(c -> c instanceof ObserverSearch).map(c -> (ObserverSearch)((Object)c)).collect(Collectors.toCollection(ArrayList::new));
        this.observersSearch.add(resolution.output);
    }

    public abstract int depth();

    public abstract void pushVariable(ObserverBacktracking.ObserverBacktrackingUnsystematic var1);

    public abstract void assign(Variable var1, int var2);

    public abstract void backtrack(Variable var1);

    public abstract void backtrack();

    private final void doPrepro() {
        for (ObserverSearch observer : this.observersSearch) {
            observer.beforePreprocessing();
        }
        if (!this.propagation.runInitially()) {
            this.stoppingType = Enums.EStopping.FULL_EXPLORATION;
        }
        for (ObserverSearch observer : this.observersSearch) {
            observer.afterPreprocessing();
        }
        this.pb.saveIntoXCSP(Enums.EExportMoment.PREPROCESSING);
    }

    public abstract Solver doRun();

    protected final void doSearch() {
        for (ObserverSearch observerSearch : this.observersSearch) {
            observerSearch.beforeSearch();
        }
        while (!this.finished() && !this.restarter.allRunsFinished()) {
            for (ObserverRuns observerRuns : this.observersRuns) {
                observerRuns.beforeRun();
            }
            if (this.stoppingType != Enums.EStopping.FULL_EXPLORATION) {
                this.doRun();
            }
            for (ObserverRuns observerRuns : this.observersRuns) {
                observerRuns.afterRun();
            }
        }
        for (ObserverSearch observerSearch : this.observersSearch) {
            observerSearch.afterSearch();
        }
    }

    public void solve() {
        for (ObserverSearch observer : this.observersSearch) {
            observer.beforeSolving();
        }
        if (Variable.firstWipeoutVariableIn(this.pb.variables) != null) {
            this.stoppingType = Enums.EStopping.FULL_EXPLORATION;
        }
        if (!this.finished() && this.rs.cp.solving.enablePrepro) {
            this.doPrepro();
        }
        if (!this.finished() && this.rs.cp.solving.enableSearch) {
            this.doSearch();
        }
        for (ObserverSearch observer : this.observersSearch) {
            observer.afterSolving();
        }
    }

    public void setDomainsMarks() {
        for (Variable x : this.pb.variables) {
            x.dom.setMark();
        }
    }

    public void restoreDomainsAtMarks() {
        for (Variable x : this.pb.variables) {
            x.dom.restoreAtMark();
        }
    }
}

