/*
 * Decompiled with CFR 0.152.
 */
package search;

import constraints.Constraint;
import constraints.CtrHard;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import search.Solver;
import search.backtrack.RestarterLocalBranching;
import search.backtrack.SolverBacktrack;
import search.local.SolutionOptimizer;
import search.local.SolverLocal;
import utility.Enums;
import utility.Kit;
import variables.Variable;

public final class SolutionManager {
    public final Solver solver;
    public long nSolutionsLimit;
    public long nSolutionsFound;
    public long bestBound;
    public int[] lastSolution;
    public int lastSolutionRun = -1;
    public String lastSolutionX;
    public final List<int[]> allSolutions;
    private SolutionOptimizer solutionOptimizer;
    private int h1 = -1;
    private int h2 = -1;

    public SolutionManager(Solver solver, long nSolutionsLimit) {
        this.solver = solver;
        this.nSolutionsLimit = nSolutionsLimit;
        this.bestBound = solver.rs.cp.optimizing.upperBound;
        this.allSolutions = solver.rs.cp.setingGeneral.recordSolutions ? new ArrayList() : null;
        this.solutionOptimizer = new SolutionOptimizer(this);
    }

    public void storeSolution(int[] t) {
        assert (t == null || t.length == this.solver.pb.variables.length);
        this.lastSolution = this.lastSolution == null ? new int[this.solver.pb.variables.length] : this.lastSolution;
        for (int i = 0; i < this.lastSolution.length; ++i) {
            this.lastSolution[i] = t != null ? t[i] : this.solver.pb.variables[i].dom.unique();
        }
    }

    private void solutionHamming() {
        if (this.nSolutionsFound <= 1L) {
            return;
        }
        this.h1 = (int)IntStream.range(0, this.lastSolution.length).filter(i -> this.lastSolution[i] != this.solver.pb.variables[i].dom.unique()).count();
        if (this.solver.pb.optimizationPilot != null) {
            Constraint c = (Constraint)((Object)this.solver.pb.optimizationPilot.ctr);
            this.h2 = (int)IntStream.range(0, this.lastSolution.length).filter(i -> this.lastSolution[i] != this.solver.pb.variables[i].dom.unique() && c.involves(this.solver.pb.variables[i])).count();
        }
    }

    public void handleNewSolution(boolean controlSolution) {
        Kit.control(!controlSolution || this.controlFoundSolution());
        ++this.nSolutionsFound;
        this.lastSolutionRun = this.solver.restarter.numRun;
        this.solutionHamming();
        if (this.nSolutionsFound >= this.nSolutionsLimit) {
            this.solver.stoppingType = Enums.EStopping.REACHED_GOAL;
        }
        this.storeSolution(null);
        if (this.allSolutions != null) {
            this.allSolutions.add((int[])this.lastSolution.clone());
        }
        this.solver.stats.manageSolution();
        if (this.solver.propagation.performingProperSearch) {
            return;
        }
        if (this.solver.pb.framework == Types.TypeFramework.MAXCSP) {
            int z = (int)Stream.of(this.solver.pb.constraints).filter(c -> !((CtrHard)c).checkCurrentInstantiation()).count();
            Kit.control((long)z < this.bestBound, () -> "z=" + z + " bb=" + this.bestBound);
            this.bestBound = z;
        } else if (this.solver.pb.optimizationPilot != null) {
            this.bestBound = this.solver.pb.optimizationPilot.value();
            Kit.control(this.solver.pb.optimizationPilot.isBetterBound(this.bestBound));
            if (this.solver.rs.cp.competitionMode) {
                System.out.println("o " + this.bestBound + "  (hamming: " + this.h1 + ", in_objective: " + this.h2 + ")");
            }
        }
        this.solver.pb.prettyDisplay();
        if (this.nSolutionsFound % 100000L == 0L) {
            Kit.log.fine("    " + this.nSolutionsFound + " solutions found  mem=" + Kit.getFormattedUsedMemorySize());
        }
        if (this.solver.restarter instanceof RestarterLocalBranching) {
            ((RestarterLocalBranching)this.solver.restarter).enterLocalBranching();
        }
    }

    public void handleNewSolutionAndPossiblyOptimizeIt() {
        this.handleNewSolution(true);
        this.solutionOptimizer.optimizeCurrentSolution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayFinalResults() {
        boolean fullExploration;
        boolean bl = fullExploration = this.solver.stoppingType == Enums.EStopping.FULL_EXPLORATION;
        if (this.solver.rs.cp.competitionMode) {
            AtomicBoolean atomicBoolean = this.solver.rs.competitionLock;
            synchronized (atomicBoolean) {
                if (!this.solver.rs.competitionLock.get()) {
                    this.solver.rs.competitionLock.set(true);
                    System.out.println();
                    if (this.lastSolutionX != null) {
                        System.out.println("v " + this.lastSolutionX);
                    }
                    if (this.nSolutionsFound == 0L) {
                        System.out.println(fullExploration ? "s UNSATISFIABLE" : "s UNKNOWN");
                    } else {
                        System.out.println(fullExploration && this.solver.pb.framework == Types.TypeFramework.COP ? "s OPTIMUM FOUND" : "s SATISFIABLE");
                    }
                    System.out.println("\nd WRONG_DECISIONS " + this.solver.stats.nWrongDecisions);
                    if (this.solver.solManager.nSolutionsFound > 1L) {
                        System.out.println("d N_SOLUTIONS " + this.solver.solManager.nSolutionsFound);
                    }
                    System.out.flush();
                }
            }
        } else {
            Kit.log.config("\n<wrong> " + this.solver.stats.nWrongDecisions + " </wrong>");
            if (this.nSolutionsFound == 0L) {
                Kit.log.config(fullExploration ? "<unsatisfiable/>" : "<unknown/>");
            } else {
                Kit.log.config(this.solver.pb.framework == Types.TypeFramework.CSP ? "<satisfiable/>" : (fullExploration ? "<optimum> " + this.bestBound + " </optimum>" : "<bound> " + this.bestBound + " </bound>"));
                if (this.solver.pb.framework == Types.TypeFramework.CSP) {
                    Kit.log.config("<nbSolutions> " + (fullExploration ? "" : "at least ") + this.nSolutionsFound + " </nbSolutions>");
                }
            }
            System.out.flush();
        }
    }

    public Constraint firstUnsatisfiedConstraint(int[] solution) {
        for (Constraint c : this.solver.pb.constraints) {
            if (c.ignored || !(c instanceof CtrHard)) continue;
            int[] tmp = c.tupleManager.localTuple;
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = solution != null ? solution[c.scp[i].num] : c.scp[i].dom.unique();
            }
            if (((CtrHard)c).checkIndexes(tmp)) continue;
            return c;
        }
        return null;
    }

    private boolean controlFoundSolution() {
        if (!(this.solver instanceof SolverLocal)) {
            Variable x = Variable.firstNonSingletonVariableIn(this.solver.pb.variables);
            Kit.control(x == null, () -> "Problem with last solution: variable " + x + " has not a unique value");
        }
        if (this.solver instanceof SolverBacktrack && this.solver.pb.framework == Types.TypeFramework.MAXCSP) {
            return true;
        }
        Constraint c = this.firstUnsatisfiedConstraint(null);
        Kit.control(c == null, () -> "Problem with last solution: constraint " + c + " not satisfied : ");
        return true;
    }
}

