/*
 * Decompiled with CFR 0.152.
 */
package search;

import constraints.hard.global.Extremum;
import constraints.hard.global.ObjVar;
import dashboard.ControlPanel;
import interfaces.ObserverRuns;
import java.util.function.Supplier;
import org.xcsp.common.Types;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Enums;
import utility.Kit;
import utility.exceptions.UnreachableCodeException;

public class Restarter
implements ObserverRuns {
    public Solver solver;
    private ControlPanel.Restarting setting;
    public final Supplier<Long> measureSupplier;
    public int numRun = -1;
    public long baseCutoff;
    public long currCutoff;
    private int nRestartsSinceLastReset = -1;
    public boolean forceRootPropagation;
    private long cnt;

    private long lubyCutoffFor(long i) {
        int k = (int)Math.floor(Math.log(i) / Math.log(2.0)) + 1;
        long pow = (long)Math.pow(2.0, k - 1);
        return i == pow * 2L - 1L ? pow : this.lubyCutoffFor(i - pow + 1L);
    }

    @Override
    public void beforeRun() {
        ++this.numRun;
        ++this.nRestartsSinceLastReset;
        if (this.nRestartsSinceLastReset == this.setting.nRestartsResetPeriod) {
            this.nRestartsSinceLastReset = 0;
            this.baseCutoff *= (long)this.setting.nRestartsResetCoefficient;
            Kit.log.info("BaseCutoff reset to " + this.baseCutoff);
        }
        if (this.currCutoff != Long.MAX_VALUE) {
            long offset = this.setting.luby ? this.lubyCutoffFor(this.numRun + 1) * 100L : (long)((double)this.baseCutoff * Math.pow(this.setting.factor, this.nRestartsSinceLastReset));
            this.currCutoff = this.measureSupplier.get() + offset;
        }
        if (this.forceRootPropagation || this.solver.rs.cp.framework == Types.TypeFramework.COP && this.numRun - 1 == this.solver.solManager.lastSolutionRun) {
            this.forceRootPropagation = false;
            this.nRestartsSinceLastReset = 0;
            if (!this.solver.propagation.runInitially()) {
                this.solver.stoppingType = Enums.EStopping.FULL_EXPLORATION;
            }
        }
    }

    @Override
    public void afterRun() {
        if (this.solver.rs.cp.framework == Types.TypeFramework.COP) {
            this.solver.pb.optimizationPilot.afterRun();
        }
    }

    public void reset() {
        this.numRun = -1;
        this.currCutoff = this.baseCutoff = this.setting.cutoff;
        this.nRestartsSinceLastReset = -1;
    }

    private Supplier<Long> measureSupplier() {
        SolverBacktrack sb = this.solver instanceof SolverBacktrack ? (SolverBacktrack)this.solver : null;
        switch (this.setting.measure) {
            case FAILED: {
                return () -> sb.backtrackStatistics.nFailedAssignments;
            }
            case WRONG: {
                return () -> sb.backtrackStatistics.nWrongDecisions;
            }
            case BACKTRACK: {
                return () -> sb.backtrackStatistics.nBacktracks;
            }
            case MAX_DEPTH: {
                return () -> sb.maxDepth;
            }
            case SOLUTION: {
                return () -> this.solver.solManager.nSolutionsFound;
            }
        }
        throw new UnreachableCodeException();
    }

    public Restarter(Solver solver) {
        this.solver = solver;
        this.setting = solver.rs.cp.restarting;
        this.measureSupplier = this.measureSupplier();
        if (solver.rs.cp.framework == Types.TypeFramework.COP) {
            this.setting.cutoff *= 10L;
        }
        this.reset();
    }

    public boolean currRunFinished() {
        if (this.solver.pb.optimizationPilot != null && this.cnt++ % 5L == 0L) {
            this.solver.pb.optimizationPilot.possiblyUpdateLocalBounds();
        }
        if (this.measureSupplier.get() >= this.currCutoff) {
            return true;
        }
        if (this.solver.rs.cp.framework != Types.TypeFramework.COP || this.numRun != this.solver.solManager.lastSolutionRun) {
            return false;
        }
        if (this.setting.restartAfterSolution) {
            return true;
        }
        return this.solver.pb.optimizationPilot.ctr instanceof Extremum.ExtremumCst.MaximumCst.MaximumCstLE || this.solver.pb.optimizationPilot.ctr instanceof ObjVar;
    }

    public boolean allRunsFinished() {
        return this.numRun + 1 >= this.setting.nRunsLimit;
    }
}

