/*
 * Decompiled with CFR 0.152.
 */
package propagation.structures.revisers;

import constraints.Constraint;
import constraints.CtrHard;
import constraints.hard.extension.structures.Bits;
import interfaces.FilteringSpecific;
import propagation.order1.PropagationForward;
import propagation.structures.revisers.Reviser2;
import utility.Kit;
import utility.sets.LinkedSetOrdered;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public final class Reviser4
extends Reviser2 {
    private short[][][] bitRmResidues;

    public Reviser4(PropagationForward propagation) {
        super(propagation);
        long nbResidues = 0L;
        if (!propagation.solver.rs.cp.propagating.bitResidues) {
            this.bitRmResidues = new short[0][][];
            return;
        }
        this.bitRmResidues = new short[propagation.pb().constraints.length][][];
        for (Constraint c : propagation.pb().constraints) {
            if (c instanceof FilteringSpecific) continue;
            if (c.extStructure() instanceof Bits) {
                int size0 = c.scp[0].dom.initSize();
                int size1 = c.scp[1].dom.initSize();
                this.bitRmResidues[c.num] = new short[2][];
                if (size0 > propagation.cp().propagating.residueLimitForBitRm) {
                    this.bitRmResidues[c.num][1] = new short[size1];
                }
                if (size1 > propagation.cp().propagating.residueLimitForBitRm) {
                    this.bitRmResidues[c.num][0] = new short[size0];
                }
                nbResidues += (long)((size0 > propagation.cp().propagating.residueLimitForBitRm ? size1 : 0) + (size1 > propagation.cp().propagating.residueLimitForBitRm ? size0 : 0));
            }
            if (nbResidues * 2L + Kit.getUsedMemory() <= (long)propagation.cp().propagating.memoryLimitForBitRm) continue;
            Kit.log.info("Stop creating residues for RevisionManagerBitRm");
            break;
        }
    }

    private short seekSupportPosition(long[] bitSup, int[] bitSupDense, long[] bitDom, SetSparse sset) {
        if (sset.size() <= bitSupDense.length) {
            int[] dense = sset.dense;
            for (int i = sset.limit; i >= 0; --i) {
                int j = dense[i];
                if ((bitSup[j] & bitDom[j]) == 0L) continue;
                return (short)j;
            }
        } else {
            for (int i = bitSupDense.length - 1; i >= 0; --i) {
                int j = bitSupDense[i];
                if ((bitSup[j] & bitDom[j]) == 0L) continue;
                return (short)j;
            }
        }
        return -1;
    }

    @Override
    public void applyTo(CtrHard c, Variable x) {
        if (!(c.extStructure() instanceof Bits)) {
            super.applyTo(c, x);
        } else {
            short[][] residues;
            int px = c.positionOf(x);
            Domain dx = x.dom;
            Variable y = c.scp[px == 0 ? 1 : 0];
            LinkedSetOrdered.LinkedSetOrderedWithBits2 sety = (LinkedSetOrdered.LinkedSetOrderedWithBits2)((Object)y.dom);
            long[] bitDom = y.dom.binaryRepresentation();
            long[][] bitSups = ((Bits)c.extStructure()).bitSupsFor(px);
            int[][] bitSupsDense = ((Bits)c.extStructure()).bitSupsDenseFor(px);
            short[][] sArray = residues = c.num < this.bitRmResidues.length ? this.bitRmResidues[c.num] : (short[][])null;
            if (residues != null && residues[px] != null) {
                int a = dx.first();
                while (a != -1) {
                    short i = residues[px][a];
                    if ((bitSups[a][i] & bitDom[i]) == 0L) {
                        i = this.seekSupportPosition(bitSups[a], bitSupsDense[a], bitDom, sety.sset);
                        if (i == -1) {
                            x.dom.removeElementary(a);
                        } else {
                            residues[px][a] = i;
                        }
                    }
                    a = dx.next(a);
                }
            } else {
                int a = dx.first();
                while (a != -1) {
                    if (this.seekSupportPosition(bitSups[a], bitSupsDense[a], bitDom, sety.sset) == -1) {
                        x.dom.removeElementary(a);
                    }
                    a = dx.next(a);
                }
            }
        }
    }
}

