/*
 * Decompiled with CFR 0.152.
 */
package propagation.structures.forSac;

import heuristics.variables.HeuristicVariables;
import heuristics.variables.HeuristicVariablesDynamic;
import heuristics.variables.dynamic.WDegOnDom;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import search.backtrack.SolverBacktrack;
import utility.Reflector;
import variables.Variable;

public final class QueueOfCells {
    private SolverBacktrack solver;
    private boolean priorityToSingletons;
    private Cell head;
    private Cell tail;
    private Cell trash;
    private Cell priorityCell;
    public int size;
    private Cell[][] positions;
    private int[] sizes;
    private CellSelector cellSelector;

    public boolean isPresent(Variable x, int a) {
        return this.positions[x.num][a] != null;
    }

    public void setPriorityTo(Variable x, int a) {
        assert (this.priorityCell == null && this.isPresent(x, a));
        this.priorityCell = this.positions[x.num][a];
    }

    public void setPriorityOf(Variable x) {
        assert (this.priorityCell == null);
        if (this.sizes[x.num] != 0) {
            int a = x.dom.first();
            while (a != -1) {
                Cell cell = this.positions[x.num][a];
                if (cell != null) {
                    this.priorityCell = cell;
                    break;
                }
                a = x.dom.next(a);
            }
        }
    }

    public Cell getFirstValidCell() {
        Cell cell = this.head;
        while (cell != null) {
            if (cell.x.dom.isPresent(cell.a)) {
                return cell;
            }
            cell = cell.next;
        }
        return null;
    }

    public Cell getLastValidCell() {
        Cell cell = this.tail;
        while (cell != null) {
            if (cell.x.dom.isPresent(cell.a)) {
                return cell;
            }
            cell = cell.prev;
        }
        return null;
    }

    private Cell getFirstSingletonCell() {
        Variable x = this.solver.futVars.first();
        while (x != null) {
            Cell cell;
            if (x.dom.size() == 1 && (cell = this.positions[x.num][x.dom.first()]) != null) {
                return cell;
            }
            x = this.solver.futVars.next(x);
        }
        return null;
    }

    public Cell getNextCell() {
        if (this.size == 0) {
            return null;
        }
        if (this.priorityCell != null) {
            Cell cell = this.priorityCell;
            this.priorityCell = null;
            return cell;
        }
        return this.cellSelector.select();
    }

    public Cell pickNextCell() {
        Cell cell = this.getNextCell();
        if (cell != null) {
            this.remove(cell);
        }
        return cell;
    }

    public QueueOfCells(SolverBacktrack solver, boolean priorityToSingletons) {
        this.solver = solver;
        this.priorityToSingletons = priorityToSingletons;
        this.positions = (Cell[][])Stream.of(solver.pb.variables).map(x -> new Cell[x.dom.initSize()]).toArray(x$0 -> new Cell[x$0][]);
        IntStream.range(0, Variable.nInitValuesFor(solver.pb.variables)).forEach(i -> {
            this.trash = new Cell(this.trash);
        });
        this.sizes = new int[solver.pb.variables.length];
        String s = solver.rs.cp.propagating.classForSACSelector.substring(solver.rs.cp.propagating.classForSACSelector.lastIndexOf(36) + 1);
        this.cellSelector = Reflector.buildObject(s, CellSelector.class, this);
    }

    public void clear() {
        this.size = 0;
        for (int i = 0; i < this.positions.length; ++i) {
            for (int j = 0; j < this.positions[i].length; ++j) {
                this.positions[i][j] = null;
            }
        }
        Arrays.fill(this.sizes, 0);
        if (this.head == null) {
            return;
        }
        if (this.trash != null) {
            this.tail.next = this.trash;
            this.trash.prev = this.tail;
        }
        this.trash = this.head;
        this.tail = null;
        this.head = null;
    }

    public void add(Variable x, int a) {
        if (this.positions[x.num][a] != null) {
            return;
        }
        Cell cell = this.trash;
        this.trash = this.trash.next;
        cell.set(x, a, this.tail, null);
        if (this.head == null) {
            this.head = cell;
        } else {
            this.tail.next = cell;
        }
        this.tail = cell;
        this.positions[x.num][a] = cell;
        int n = x.num;
        this.sizes[n] = this.sizes[n] + 1;
        ++this.size;
    }

    public void remove(Cell cell) {
        Variable x = cell.x;
        int a = cell.a;
        Cell prev = cell.prev;
        Cell next = cell.next;
        if (prev == null) {
            this.head = next;
        } else {
            prev.next = next;
        }
        if (next == null) {
            this.tail = prev;
        } else {
            next.prev = prev;
        }
        cell.next = this.trash;
        this.trash = cell;
        this.positions[x.num][a] = null;
        int n = x.num;
        this.sizes[n] = this.sizes[n] - 1;
        --this.size;
    }

    public boolean remove(Variable x, int a) {
        Cell cell = this.positions[x.num][a];
        if (cell == null) {
            return false;
        }
        this.remove(cell);
        return true;
    }

    public void fill(boolean onlyBounds) {
        this.clear();
        this.solver.futVars.execute(x -> {
            if (onlyBounds) {
                this.add((Variable)x, x.dom.first());
                this.add((Variable)x, x.dom.last());
            } else {
                int a = x.dom.first();
                while (a != -1) {
                    this.add((Variable)x, a);
                    a = x.dom.next(a);
                }
            }
        });
    }

    public void fill() {
        this.fill(false);
    }

    public void display() {
        Cell cell = this.head;
        while (cell != null) {
            System.out.print(cell.x + "-" + cell.a + " ");
            cell = cell.next;
        }
        System.out.println();
    }

    public final class WDegOnDomSelector
    extends HeuristicSelector {
        public WDegOnDomSelector() {
            this.varHeuristic = new WDegOnDom(QueueOfCells.this.solver, false);
        }
    }

    public final class DDegOnDomSelector
    extends HeuristicSelector {
        public DDegOnDomSelector() {
            this.varHeuristic = new HeuristicVariablesDynamic.DDegOnDom(QueueOfCells.this.solver, false);
        }
    }

    public final class DomSelector
    extends HeuristicSelector {
        public DomSelector() {
            this.varHeuristic = new HeuristicVariablesDynamic.Dom(QueueOfCells.this.solver, false);
        }
    }

    private abstract class HeuristicSelector
    extends VariableIteratingSelector {
        protected HeuristicVariables varHeuristic;

        private HeuristicSelector() {
        }

        @Override
        protected double evaluate(Variable x) {
            return this.varHeuristic.scoreOptimizedOf(x);
        }
    }

    public final class SizeSelector
    extends VariableIteratingSelector {
        @Override
        protected double evaluate(Variable x) {
            return QueueOfCells.this.sizes[x.num];
        }
    }

    private abstract class VariableIteratingSelector
    implements CellSelector {
        private VariableIteratingSelector() {
        }

        protected abstract double evaluate(Variable var1);

        @Override
        public Cell select() {
            Cell bestCell = null;
            double bestEvaluation = -1.0;
            Variable x = ((QueueOfCells)QueueOfCells.this).solver.futVars.first();
            while (x != null) {
                if (QueueOfCells.this.sizes[x.num] != 0) {
                    if (QueueOfCells.this.priorityToSingletons && x.dom.size() == 1) {
                        Cell cell = QueueOfCells.this.positions[x.num][x.dom.first()];
                        if (cell != null) {
                            return cell;
                        }
                    } else {
                        double evaluation = this.evaluate(x);
                        if (bestCell == null || evaluation > bestEvaluation) {
                            int a = x.dom.first();
                            while (a != -1) {
                                Cell cell = QueueOfCells.this.positions[x.num][a];
                                if (cell != null) {
                                    bestCell = cell;
                                    bestEvaluation = evaluation;
                                    break;
                                }
                                a = x.dom.next(a);
                            }
                        }
                    }
                }
                x = ((QueueOfCells)QueueOfCells.this).solver.futVars.next(x);
            }
            return bestCell;
        }
    }

    public final class LifoSelector
    implements CellSelector {
        @Override
        public Cell select() {
            Cell cell;
            if (QueueOfCells.this.priorityToSingletons && (cell = QueueOfCells.this.getFirstSingletonCell()) != null) {
                return cell;
            }
            return QueueOfCells.this.getLastValidCell();
        }
    }

    public final class FifoSelector
    implements CellSelector {
        @Override
        public Cell select() {
            Cell cell;
            if (QueueOfCells.this.priorityToSingletons && (cell = QueueOfCells.this.getFirstSingletonCell()) != null) {
                return cell;
            }
            return QueueOfCells.this.getFirstValidCell();
        }
    }

    public static interface CellSelector {
        public Cell select();
    }

    public final class Cell {
        public Variable x;
        public int a;
        private Cell prev;
        private Cell next;

        private Cell(Cell next) {
            this.next = next;
        }

        private void set(Variable x, int a, Cell prev, Cell next) {
            this.x = x;
            this.a = a;
            this.prev = prev;
            this.next = next;
        }
    }
}

