/*
 * Decompiled with CFR 0.152.
 */
package propagation.structures.forSac;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import variables.domains.Domain;

public final class InferenceUnit {
    public boolean[] absents;
    public boolean modified;

    public InferenceUnit(int size) {
        this.absents = new boolean[size];
    }

    public void addAbsent(int a) {
        assert (!this.absents[a]);
        this.absents[a] = true;
        this.modified = true;
    }

    public void copy(Domain dom) {
        assert (dom.initSize() == this.absents.length);
        for (int i = 0; i < this.absents.length; ++i) {
            this.absents[i] = !dom.isPresent(i);
        }
        this.modified = false;
    }

    public String toString() {
        return " elements = {" + IntStream.range(0, this.absents.length).filter(i -> this.absents[i]).mapToObj(i -> i + " ").collect(Collectors.joining()) + "}";
    }
}

