/*
 * Decompiled with CFR 0.152.
 */
package propagation.structures.forSac;

import java.util.stream.IntStream;
import propagation.structures.forSac.Branch;
import propagation.structures.forSac.InferenceUnit;
import search.Solver;
import variables.Variable;

public class BranchExtended
extends Branch {
    public final InferenceUnit[] inferenceUnits;
    private boolean modified;
    private boolean inconsistent;

    public boolean isModified() {
        return this.modified;
    }

    public boolean isInconsistent() {
        return this.inconsistent;
    }

    public BranchExtended(Solver solver) {
        super(solver);
        this.inferenceUnits = new InferenceUnit[solver.pb.variables.length];
    }

    public void recordProblemDomain() {
        for (Variable x : this.solver.pb.variables) {
            assert (x.dom.size() > 0);
            if (x.isAssigned()) continue;
            if (this.inferenceUnits[x.num] == null) {
                this.inferenceUnits[x.num] = new InferenceUnit(x.dom.initSize());
            }
            this.inferenceUnits[x.num].copy(x.dom);
        }
        this.modified = false;
        assert (this.controlModified());
    }

    public void updateAfterRemovalOf(Variable x, int a) {
        if (this.has(x)) {
            if (this.idxs[this.positions[x.num]] == a) {
                this.modified = true;
                this.inconsistent = true;
            }
        } else if (!this.inferenceUnits[x.num].absents[a]) {
            this.inferenceUnits[x.num].addAbsent(a);
            this.modified = true;
        }
        assert (this.controlModified());
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this.inferenceUnits.length; ++i) {
            if (this.inferenceUnits[i] == null) continue;
            this.inferenceUnits[i].modified = false;
        }
        this.modified = false;
        this.inconsistent = false;
    }

    public boolean controlModified() {
        boolean b = IntStream.range(0, this.inferenceUnits.length).anyMatch(i -> this.positions[i] == -1 && this.inferenceUnits[i] != null && this.inferenceUnits[i].modified);
        if (b && !this.modified) {
            System.out.println("modified = " + this.modified + " b= " + b);
        }
        return !b || this.modified;
    }
}

