/*
 * Decompiled with CFR 0.152.
 */
package propagation.structures.forSac;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import propagation.structures.forSac.QueueOfCells;
import search.Solver;
import variables.Variable;

public class Branch {
    protected final Solver solver;
    public int size;
    public final Variable[] vars;
    public final int[] idxs;
    protected final int[] positions;

    public Branch(Solver solver) {
        this.solver = solver;
        this.vars = new Variable[solver.pb.variables.length];
        this.idxs = new int[solver.pb.variables.length];
        this.positions = new int[solver.pb.variables.length];
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.positions, -1);
    }

    public boolean has(Variable x) {
        return this.positions[x.num] != -1;
    }

    public void add(Variable x, int a) {
        assert (!this.has(x));
        this.vars[this.size] = x;
        this.idxs[this.size] = a;
        this.positions[x.num] = this.size++;
        assert (IntStream.of(this.positions).filter(v -> v != -1).count() == (long)this.size);
    }

    public boolean controlWrt(QueueOfCells queue) {
        for (int i = 0; i < this.size; ++i) {
            if (!queue.isPresent(this.vars[i], this.idxs[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Branch : " + IntStream.range(0, this.size).mapToObj(i -> this.vars[i] + "<-" + this.idxs[i]).collect(Collectors.joining(" "));
    }
}

