/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.pfc;

import heuristics.variables.HeuristicVariables;
import interfaces.TagExperimental;
import propagation.soft.pfc.PRDAC;
import propagation.structures.forSac.Branch;
import search.Solver;
import utility.operations.CombinatorOfTwoInts;
import variables.Variable;

public class SingletonMaxCSP3Single
extends PRDAC
implements TagExperimental {
    private Branch branch;
    private boolean maximumBranchExtension = false;
    int nbSingletonTests;
    int nbEffectiveSingletonTests;
    protected int nbBuiltBranches;
    protected int cumulBranchSizes;
    private int nbUntestedVariables;
    private boolean[] untestedVariables;
    private Variable lastFailedVariable;
    private int lastFailedIndex;
    protected boolean increment;
    protected HeuristicVariables.BestScoredVariable bestScoredVariable = new HeuristicVariables.BestScoredVariable();
    private CombinatorOfTwoInts combinator;
    private int selectionMode = 0;

    private void setUntested(int position, boolean b) {
        if (this.untestedVariables[position] != b) {
            this.untestedVariables[position] = b;
            this.nbUntestedVariables += b ? 1 : -1;
        }
        assert (this.controlUntested());
    }

    private void initializeSingleton() {
        Variable[] variables = this.solver.pb.variables;
        for (int i = 0; i < this.untestedVariables.length; ++i) {
            this.untestedVariables[i] = variables[i].isFuture();
        }
        this.nbUntestedVariables = this.solver.futVars.size();
        this.lastFailedVariable = null;
        assert (this.controlUntested());
    }

    public SingletonMaxCSP3Single(Solver solver) {
        super(solver);
        this.untestedVariables = new boolean[solver.pb.variables.length];
        this.branch = new Branch(solver);
        this.combinator = new CombinatorOfTwoInts(solver.pb.stuff.maxVarDegree());
    }

    protected void undoAssignmentsFromBranch(Branch branch) {
        for (int i = branch.size - 1; i >= 0; --i) {
            this.solver.backtrack(branch.vars[i]);
        }
    }

    protected boolean manageInconsistentAssignment(Variable var, int idx) {
        ++this.nbEffectiveSingletonTests;
        var.dom.removeElementary(idx);
        if (var.dom.size() == 0) {
            return false;
        }
        assert (this.queue.isEmpty());
        return true;
    }

    protected boolean canTryAnotherExtensionInsteadOf(Variable var, int idx) {
        if (!this.maximumBranchExtension || this.branch.size == 0) {
            return false;
        }
        var.dom.removeElementary(idx);
        if (var.dom.size() == 0) {
            return false;
        }
        boolean b = super.runAfterRefutation(var);
        return b;
    }

    protected void dealWithNewBranch(Branch branch) {
        this.undoAssignmentsFromBranch(branch);
        this.cumulBranchSizes += branch.size;
        ++this.nbBuiltBranches;
    }

    private Variable selectNextVariable(boolean onlyUntested) {
        this.bestScoredVariable.reset(false);
        this.solver.futVars.execute(x -> {
            if (!onlyUntested || this.untestedVariables[x.num]) {
                assert (!onlyUntested || !this.branch.has((Variable)x));
                double result = this.selectionMode == 0 ? x.wdeg() / (double)x.dom.size() : (double)(-this.combinator.combinedMaxMinLongValueFor(x.dom.size(), x.ddeg()));
                this.bestScoredVariable.update((Variable)x, result);
            }
        });
        assert (this.bestScoredVariable.variable != null) : "onlyUntested = " + onlyUntested;
        return this.bestScoredVariable.variable;
    }

    protected boolean buildBranch(Branch branch) {
        branch.clear();
        boolean finished = false;
        while (!finished) {
            Variable var = this.lastFailedVariable != null ? this.lastFailedVariable : this.selectNextVariable(this.nbUntestedVariables > 0);
            int idx = this.lastFailedVariable != null ? this.lastFailedIndex : var.dom.first();
            this.lastFailedVariable = null;
            assert (!var.isAssigned());
            assert (var.dom.isPresent(idx));
            assert (this.queue.isEmpty());
            ++this.nbSingletonTests;
            this.solver.assign(var, idx);
            boolean consistent = super.runAfterAssignment(var);
            if (consistent) {
                this.setUntested(var.num, false);
                branch.add(var, idx);
                if (this.solver.depth() != this.solver.pb.variables.length) continue;
                finished = true;
                continue;
            }
            this.solver.backtrack(var);
            if (branch.size == 0) {
                return this.manageInconsistentAssignment(var, idx);
            }
            finished = !this.canTryAnotherExtensionInsteadOf(var, idx);
            if (!finished) continue;
            this.lastFailedVariable = var;
            this.lastFailedIndex = idx;
        }
        this.dealWithNewBranch(branch);
        return true;
    }

    protected boolean filterBySAC() {
        if (this.solver.futVars.size() == 0) {
            return true;
        }
        this.nbBuiltBranches = 0;
        this.cumulBranchSizes = 0;
        this.initializeSingleton();
        while (this.nbUntestedVariables > 0) {
            boolean consistent = this.buildBranch(this.branch);
            if (!consistent) {
                return false;
            }
            if (!this.solver.finished()) continue;
            return true;
        }
        return super.runAfterRefutation(null);
    }

    @Override
    public boolean runInitially() {
        this.increment = true;
        if (!super.runInitially()) {
            return false;
        }
        return this.filterBySAC();
    }

    @Override
    public boolean runAfterAssignment(Variable var) {
        return super.runAfterAssignment(var);
    }

    @Override
    public boolean runAfterRefutation(Variable var) {
        return super.runAfterRefutation(var);
    }

    private boolean controlUntested() {
        int cpt = 0;
        for (int i = 0; i < this.untestedVariables.length; ++i) {
            if (!this.untestedVariables[i]) continue;
            if (!this.solver.pb.variables[i].isFuture()) {
                return false;
            }
            ++cpt;
        }
        return cpt == this.nbUntestedVariables;
    }
}

