/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.pfc;

import interfaces.TagExperimental;
import propagation.soft.pfc.PRDAC;
import search.Solver;
import variables.Variable;
import variables.domains.Domain;

public class SingletonMaxCSP
extends PRDAC
implements TagExperimental {
    int nbSingletonTests;
    int nbEffectiveSingletonTests;
    protected boolean increment;

    public SingletonMaxCSP(Solver solver) {
        super(solver);
    }

    protected boolean singletonTest(Variable x, int a) {
        ++this.nbSingletonTests;
        this.solver.assign(x, a);
        boolean consistent = super.runAfterAssignment(x);
        if (!consistent) {
            ++this.nbEffectiveSingletonTests;
        }
        this.solver.backtrack(x);
        return consistent;
    }

    private int filteringBySACOf(Variable x) {
        Domain dom = x.dom;
        int sizeBefore = dom.size();
        int a = dom.first();
        while (a != -1) {
            int b = dom.next(a);
            if (!this.singletonTest(x, a)) {
                x.dom.removeElementary(a);
            }
            a = b;
        }
        return sizeBefore - dom.size();
    }

    protected boolean filterBySAC() {
        Variable x = this.solver.futVars.first();
        while (x != null) {
            int nbRemovals = this.filteringBySACOf(x);
            if (nbRemovals > 0 && x.dom.size() == 0) {
                return false;
            }
            x = this.solver.futVars.next(x);
        }
        return super.runAfterRefutation(null);
    }

    @Override
    public boolean runInitially() {
        this.increment = true;
        if (!super.runInitially()) {
            return false;
        }
        this.increment = false;
        return this.filterBySAC();
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        this.increment = true;
        if (!super.runAfterAssignment(x)) {
            return false;
        }
        this.increment = false;
        return this.filterBySAC();
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        this.increment = true;
        if (!super.runAfterRefutation(x)) {
            return false;
        }
        this.increment = false;
        return this.filterBySAC();
    }
}

