/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.pfc;

import constraints.Constraint;
import interfaces.ObserverRuns;
import java.util.stream.Stream;
import learning.LearnerNogoods;
import propagation.soft.pfc.PFC;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.operations.Calculator;
import variables.Variable;
import variables.domains.Domain;

public abstract class RDACAbstract
extends PFC
implements ObserverRuns {
    protected long timestamp;
    public final long[][][] minCosts;

    @Override
    public void beforeRun() {
    }

    public RDACAbstract(Solver solver) {
        super(solver);
        this.minCosts = (long[][][])Stream.of(solver.pb.constraints).map(c -> Variable.litterals(c.scp).longArray()).toArray(x$0 -> new long[x$0][][]);
    }

    @Override
    protected long computeMniOf(Variable x, boolean recomputeNbInconsistencies) {
        long ub = this.solver.solManager.bestBound;
        long[] t = this.sumMinCosts[x.num];
        int argMin = -1;
        int argMax = -1;
        Domain dom = x.dom;
        int a = dom.first();
        while (a != -1) {
            if (t[a] == -this.timestamp) {
                t[a] = ub;
            } else if (recomputeNbInconsistencies) {
                t[a] = this.partitionOfConstraints.computeSumMinCostsOf(x, a);
            }
            if (argMin == -1) {
                argMin = argMax = a;
            } else if (t[a] < t[argMin]) {
                argMin = a;
            } else if (t[a] > t[argMax]) {
                argMax = a;
            }
            a = dom.next(a);
        }
        this.argMinSumMinCosts[x.num] = argMin;
        this.argMaxSumMinCosts[x.num] = argMax;
        return t[argMin];
    }

    protected abstract void updateStructuresFromRemovals();

    protected boolean filterDomains() {
        boolean consistent;
        assert (this.queue.size() == 0 && Kit.withNoNegativeValues(this.sumMinCosts));
        LearnerNogoods nm = ((SolverBacktrack)this.solver).learnerNogoods;
        Variable lastPast = this.solver.futVars.lastPast();
        boolean bl = consistent = lastPast == null || nm == null || nm.checkWatchesOf(lastPast, lastPast.dom.first(), false);
        if (!consistent) {
            Kit.log.info("quick stop with nogood recording from restarts used");
            return false;
        }
        long ub = this.solver.solManager.bestBound;
        do {
            Variable x = this.solver.futVars.first();
            while (x != null) {
                long[] t = this.sumMinCosts[x.num];
                long base = Calculator.add(this.partitionOfConstraints.distance, this.sumMnis, -t[this.argMinSumMinCosts[x.num]]);
                if (Calculator.add(base, t[this.argMaxSumMinCosts[x.num]]) >= ub) {
                    Domain dom = x.dom;
                    int a = dom.first();
                    while (a != -1) {
                        assert (t[a] == ub && this.controlMinCostEqualToUpperBound(x, a) || t[a] == this.partitionOfConstraints.computeSumMinCostsOf(x, a));
                        if (Calculator.add(base, t[a], this.computeOffset(x, a)) >= ub) {
                            dom.removeElementary(a);
                        }
                        a = dom.next(a);
                    }
                    if (dom.size() == 0) {
                        return false;
                    }
                    this.queue.add(x);
                }
                x = this.solver.futVars.next(x);
            }
            if (this.queue.size() == 0) {
                return true;
            }
            this.updateStructuresFromRemovals();
        } while (this.computeSumMnis(false));
        return false;
    }

    public void init(boolean incremental) {
        this.partitionOfConstraints.init(incremental);
        assert (this.control());
    }

    public final boolean go(boolean incremental) {
        boolean consistent;
        ++this.timestamp;
        this.init(incremental && this.solver.depth() > 1);
        boolean bl = consistent = this.computeSumMnis(true) && this.filterDomains();
        assert (!consistent || this.control());
        return consistent;
    }

    @Override
    public boolean runInitially() {
        return this.go(false);
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        return this.go(true);
    }

    @Override
    public boolean runAfterRefutation(Variable x) {
        return this.go(false);
    }

    private boolean controlMinCostEqualToUpperBound(Variable x, int a) {
        return Stream.of(x.ctrs).anyMatch(c -> this.minCosts[c.num][c.positionOf(x)][a] >= this.solver.solManager.bestBound);
    }

    public boolean control() {
        for (Constraint c : this.solver.pb.constraints) {
            for (Variable x : c.scp) {
                if (x.isAssigned()) continue;
                int a = x.dom.first();
                while (a != -1) {
                    Kit.control(Math.min(c.minCostOfTuplesWith(c.positionOf(x), a), this.solver.solManager.bestBound) == this.minCosts[c.num][c.positionOf(x)][a], () -> "Recomputed value is different from stored value");
                    a = x.dom.next(a);
                }
            }
        }
        return true;
    }
}

