/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.pfc;

import constraints.Constraint;
import constraints.CtrHard;
import heuristics.variables.HeuristicVariablesDynamic;
import interfaces.TagExperimental;
import interfaces.TagMaximize;
import java.util.Arrays;
import org.xcsp.common.Types;
import propagation.soft.pfc.PartitionOfConstraints;
import propagation.soft.pfc.RDACAbstract;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.operations.CombinatorOfTwoInts;
import variables.Variable;
import variables.domains.Domain;

public class RDAC
extends RDACAbstract {
    public final int[][] aic;

    public int getAicOffsetOf(Variable x) {
        int[] t = this.aic[x.num];
        Domain dom = x.dom;
        int bestIndex = dom.first();
        int bestOffset = Integer.MAX_VALUE;
        int idx = dom.next(bestIndex);
        while (idx != -1) {
            if (t[idx] < t[bestIndex]) {
                bestOffset = t[bestIndex] - t[idx];
                bestIndex = idx;
            } else {
                bestOffset = Math.min(bestOffset, t[idx] - t[bestIndex]);
            }
            idx = dom.next(idx);
        }
        return bestOffset;
    }

    public RDAC(Solver solver) {
        super(solver);
        Kit.control(solver.pb.framework == Types.TypeFramework.MAXCSP, () -> "MaxCSP is not indicated in your configuration");
        this.aic = Variable.litterals(solver.pb.variables).intArray();
        this.partitionOfConstraints = new PartitionOfConstraintsMax(solver);
    }

    @Override
    public void init(boolean incremental) {
        if (!incremental) {
            for (int i = 0; i < this.aic.length; ++i) {
                Arrays.fill(this.aic[i], 0);
            }
        }
        super.init(incremental);
    }

    @Override
    protected void updateStructuresFromRemovals() {
        while (this.queue.size() > 0) {
            Variable x = this.queue.pickAndDelete(0);
            for (Constraint ctr : x.ctrs) {
                if (ctr.futvars.size() == 0) continue;
                CtrHard c = (CtrHard)ctr;
                Variable partitionVariable = this.solver.pb.variables[this.partitionOfConstraints.membership[ctr.num]];
                long[] t = this.sumMinCosts[partitionVariable.num];
                for (int j = 0; j < c.scp.length; ++j) {
                    Variable y = c.scp[j];
                    if (y.isAssigned() || y == x) continue;
                    long[] mc = this.minCosts[c.num][j];
                    if (!this.reviser.mustBeAppliedTo(c, y)) continue;
                    Domain dom = y.dom;
                    int a = dom.first();
                    while (a != -1) {
                        if (mc[a] <= 0L && !c.findArcSupportFor(j, a)) {
                            mc[a] = c.cost;
                            int[] nArray = this.aic[y.num];
                            int n = a;
                            nArray[n] = nArray[n] + 1;
                            if (y == partitionVariable) {
                                int n2 = a;
                                t[n2] = t[n2] + (long)c.cost;
                            }
                        }
                        a = dom.next(a);
                    }
                }
            }
        }
    }

    @Override
    public boolean control() {
        if (!super.control()) {
            return false;
        }
        for (Variable x : this.solver.pb.variables) {
            if (x.isAssigned()) continue;
            int idx = x.dom.first();
            while (idx != -1) {
                int cnt = 0;
                for (Constraint c : x.ctrs) {
                    if (this.minCosts[c.num][c.positionOf(x)][idx] <= 0L) continue;
                    ++cnt;
                }
                Kit.control(cnt == this.aic[x.num][idx], () -> "aic badly initialized ");
                idx = x.dom.next(idx);
            }
        }
        return true;
    }

    public final class PartitionOfConstraintsMax
    extends PartitionOfConstraints {
        protected PartitionOfConstraintsMax(Solver solver) {
            super(solver);
        }

        @Override
        protected double evaluate(Constraint ctr, Variable x, boolean incremental) {
            Domain dom;
            int nbInconsistentValues;
            block9: {
                CtrHard c;
                long[] mc;
                int vap;
                block8: {
                    vap = ctr.positionOf(x);
                    mc = RDAC.this.minCosts[ctr.num][vap];
                    c = (CtrHard)ctr;
                    nbInconsistentValues = 0;
                    dom = x.dom;
                    if (incremental) break block8;
                    if (RDAC.this.reviser.mustBeAppliedTo(c, x)) {
                        int a = dom.first();
                        while (a != -1) {
                            mc[a] = c.findArcSupportFor(vap, a) ? 0L : (long)c.cost;
                            if (mc[a] > 0L) {
                                ++nbInconsistentValues;
                                int[] nArray = RDAC.this.aic[x.num];
                                int n = a;
                                nArray[n] = nArray[n] + 1;
                            }
                            a = dom.next(a);
                        }
                    } else {
                        Arrays.fill(mc, 0L);
                    }
                    break block9;
                }
                if (!RDAC.this.reviser.mustBeAppliedTo(c, x)) break block9;
                int a = dom.first();
                while (a != -1) {
                    if (mc[a] > 0L) {
                        ++nbInconsistentValues;
                    } else {
                        mc[a] = c.findArcSupportFor(vap, a) ? 0L : (long)c.cost;
                        if (mc[a] > 0L) {
                            ++nbInconsistentValues;
                            int[] nArray = RDAC.this.aic[x.num];
                            int n = a;
                            nArray[n] = nArray[n] + 1;
                        }
                    }
                    a = dom.next(a);
                }
            }
            return (double)nbInconsistentValues / (double)dom.size();
        }

        @Override
        protected void updateStructures(Constraint ctr, Variable x) {
            CtrHard c = (CtrHard)ctr;
            int vap = c.positionOf(x);
            long[] mc = RDAC.this.minCosts[c.num][vap];
            if (RDAC.this.reviser.mustBeAppliedTo(c, x)) {
                Domain dom = x.dom;
                int a = dom.first();
                while (a != -1) {
                    if (mc[a] <= 0L && !c.findArcSupportFor(vap, a)) {
                        mc[a] = c.cost;
                        int[] nArray = RDAC.this.aic[x.num];
                        int n = a;
                        nArray[n] = nArray[n] + 1;
                    }
                    a = dom.next(a);
                }
            }
        }

        @Override
        public long computeSumMinCostsOf(Variable x, int a) {
            assert (!x.isAssigned());
            long cnt = 0L;
            int cnum = this.first[x.num];
            while (cnum != -1) {
                cnt += RDAC.this.minCosts[cnum][this.ctrs[cnum].positionOf(x)][a];
                cnum = this.next[cnum];
            }
            return cnt;
        }
    }

    public static class OffsetThenDom
    extends HeuristicVariablesDynamic
    implements TagExperimental {
        private CombinatorOfTwoInts combinator;

        public OffsetThenDom(SolverBacktrack solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
            this.combinator = new CombinatorOfTwoInts(solver.pb.stuff.maxDomSize());
        }

        @Override
        public double scoreOf(Variable x) {
            RDAC maxCSP = (RDAC)this.solver.propagation;
            return this.combinator.combinedLongValueFor(maxCSP.getAicOffsetOf(x), x.dom.size());
        }
    }

    public static class DDegOnDomOffset
    extends HeuristicVariablesDynamic
    implements TagExperimental,
    TagMaximize {
        public DDegOnDomOffset(SolverBacktrack solver, boolean antiHeuristic) {
            super(solver, antiHeuristic);
        }

        @Override
        public double scoreOf(Variable x) {
            RDAC maxCSP = (RDAC)this.solver.propagation;
            return (double)maxCSP.getAicOffsetOf(x) * x.ddegOnDom();
        }
    }
}

