/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.pfc;

import constraints.Constraint;
import constraints.CtrHard;
import propagation.soft.pfc.RDAC;
import search.Solver;
import variables.Variable;
import variables.domains.Domain;

public class PRDAC
extends RDAC {
    private long[] offsetOfMinNbDetectedInconsistencies;

    public PRDAC(Solver solver) {
        super(solver);
        this.offsetOfMinNbDetectedInconsistencies = new long[solver.pb.variables.length];
    }

    @Override
    protected long computeMniOf(Variable x, boolean recomputeNbInconsistencies) {
        long[] t = this.sumMinCosts[x.num];
        Domain dom = x.dom;
        long offset = Long.MAX_VALUE;
        int argMin = -1;
        int argMax = -1;
        int a = dom.first();
        while (a != -1) {
            if (recomputeNbInconsistencies) {
                t[a] = this.partitionOfConstraints.computeSumMinCostsOf(x, a);
            }
            if (argMin == -1) {
                argMin = argMax = a;
            } else if (t[a] < t[argMin]) {
                argMin = a;
                offset = t[argMin] - t[a];
            } else {
                if (t[a] > t[argMax]) {
                    argMax = a;
                }
                offset = Math.min(offset, t[a] - t[argMin]);
            }
            a = dom.next(a);
        }
        if (offset == Long.MAX_VALUE) {
            offset = 0L;
        }
        this.argMinSumMinCosts[x.num] = argMin;
        this.offsetOfMinNbDetectedInconsistencies[x.num] = offset;
        this.argMaxSumMinCosts[x.num] = argMax;
        return t[argMin];
    }

    private long compute(Variable x) {
        long[] t = this.sumMinCosts[x.num];
        int bestIndex = this.argMinSumMinCosts[x.num];
        long best = t[bestIndex];
        long bestOffset = Long.MAX_VALUE;
        Domain dom = x.dom;
        int a = dom.first();
        while (a != -1) {
            long offset;
            if (a != bestIndex && (offset = t[a] - best) < bestOffset && (bestOffset = offset) == 0L) {
                return 0L;
            }
            a = dom.next(a);
        }
        return bestOffset;
    }

    @Override
    protected long computeOffset(Variable x, int a) {
        long cnt = 0L;
        Variable y = this.solver.futVars.first();
        while (y != null) {
            Constraint c;
            if (x != y && this.offsetOfMinNbDetectedInconsistencies[y.num] != 0L && (c = x.firstBinaryConstraintWith(y)) != null && this.partitionOfConstraints.membership[c.num] == y.num) {
                int b = this.argMinSumMinCosts[y.num];
                int p = c.positionOf(y);
                if (this.minCosts[c.num][p][b] <= 0L) {
                    int[] tmp = c.tupleManager.localTuple;
                    tmp[p] = b;
                    tmp[p == 1 ? 0 : 1] = a;
                    if (!((CtrHard)c).checkIndexes(tmp)) {
                        cnt += (long)c.cost;
                    }
                }
            }
            y = this.solver.futVars.next(y);
        }
        return cnt;
    }
}

