/*
 * Decompiled with CFR 0.152.
 */
package propagation.soft.pfc;

import propagation.order1.AC;
import propagation.soft.LowerBoundCapability;
import propagation.soft.pfc.PartitionOfConstraints;
import search.Solver;
import utility.Enums;
import utility.Kit;
import utility.operations.Calculator;
import variables.Variable;

public abstract class PFC
extends AC
implements LowerBoundCapability {
    protected PartitionOfConstraints partitionOfConstraints;
    public long[][] sumMinCosts;
    public int[] argMinSumMinCosts;
    protected int[] argMaxSumMinCosts;
    protected long sumMnis;

    @Override
    public final long getLowerBound() {
        return this.partitionOfConstraints.distance;
    }

    public PFC(Solver solver) {
        super(solver);
        Kit.control(this.cp().solving.branching != Enums.EBranching.NON, () -> "Non-binary branching not possible for WCSP or MaxCSP");
        this.sumMinCosts = Variable.litterals(solver.pb.variables).longArray();
        this.argMinSumMinCosts = new int[solver.pb.variables.length];
        this.argMaxSumMinCosts = new int[solver.pb.variables.length];
    }

    protected abstract long computeMniOf(Variable var1, boolean var2);

    protected boolean computeSumMnis(boolean recomputeNbInconsistencies) {
        this.sumMnis = 0L;
        Variable greatestImpactVariable = null;
        long greatestImpact = -1L;
        long ub = this.solver.solManager.bestBound;
        Variable x = this.solver.futVars.first();
        while (x != null) {
            this.sumMnis = Calculator.add(this.sumMnis, this.computeMniOf(x, recomputeNbInconsistencies));
            long impact = this.sumMinCosts[x.num][this.argMinSumMinCosts[x.num]];
            if (impact > greatestImpact) {
                greatestImpactVariable = x;
                greatestImpact = impact;
            }
            if (Calculator.add(this.partitionOfConstraints.distance, this.sumMnis) >= ub) {
                return false;
            }
            x = this.solver.futVars.next(x);
        }
        return true;
    }

    protected long computeOffset(Variable x, int a) {
        return 0L;
    }
}

