/*
 * Decompiled with CFR 0.152.
 */
package propagation.order2.path;

import constraints.Constraint;
import constraints.CtrHard;
import java.util.Arrays;
import problem.Problem;
import variables.Variable;

public class PropagationSetOfValues {
    private int[][][] positions;
    private int capacity = 0;
    private int size;
    private final CtrHard[] ctrs;
    private final Variable[] vars;
    private final int[] idxs;
    private int head;

    public CtrHard firstConstraint() {
        return this.ctrs[this.head];
    }

    public Variable firstVariable() {
        return this.vars[this.head];
    }

    public int firstIndex() {
        return this.idxs[this.head];
    }

    public PropagationSetOfValues(Problem problem) {
        this.positions = new int[problem.constraints.length][][];
        for (int i = 0; i < this.positions.length; ++i) {
            Constraint c = problem.constraints[i];
            if (c.scp.length != 2) continue;
            this.positions[i] = new int[2][];
            for (int j = 0; j < this.positions[i].length; ++j) {
                this.positions[i][j] = new int[c.scp[j].dom.initSize()];
                Arrays.fill(this.positions[i][j], -1);
                this.capacity += c.scp[j].dom.initSize();
            }
        }
        this.ctrs = new CtrHard[this.capacity];
        this.vars = new Variable[this.capacity];
        this.idxs = new int[this.capacity];
    }

    public PropagationSetOfValues add(CtrHard c, Variable x, int a) {
        int firstFreePosition;
        int p = c.positionOf(x);
        if (this.positions[c.num][p][a] != -1) {
            return this;
        }
        this.positions[c.num][p][a] = firstFreePosition = (this.head + this.size) % this.capacity;
        this.ctrs[firstFreePosition] = c;
        this.vars[firstFreePosition] = x;
        this.idxs[firstFreePosition] = a;
        ++this.size;
        return this;
    }

    public void remove(int i) {
        assert (i >= 0 && i < this.size);
        int position = (this.head + i) % this.capacity;
        this.positions[this.ctrs[position].num][this.ctrs[position].positionOf((Variable)this.vars[position])][this.idxs[position]] = -1;
        if (position == this.head) {
            this.head = (this.head + 1) % this.capacity;
        } else {
            int lastPosition = (this.head + this.size - 1) % this.capacity;
            if (position != lastPosition) {
                this.ctrs[position] = this.ctrs[lastPosition];
                this.vars[position] = this.vars[lastPosition];
                this.idxs[position] = this.idxs[lastPosition];
                this.positions[this.ctrs[position].num][this.ctrs[position].positionOf((Variable)this.vars[position])][this.idxs[position]] = position;
            }
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }
}

