/*
 * Decompiled with CFR 0.152.
 */
package propagation.order2.dual;

import constraints.Constraint;
import constraints.CtrHard;
import constraints.hard.CtrExtension;
import interfaces.FilteringSpecific;
import propagation.order2.SecondOrderConsistency;
import search.Solver;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.Variable;
import variables.domains.Domain;

public class SDC2
extends SecondOrderConsistency {
    private int[] lastModifications;
    private int counter;

    public SDC2(Solver solver) {
        super(solver);
        this.lastModifications = new int[solver.pb.variables.length];
    }

    private int removeConservativelyTuplesFrom(Variable x, int a) {
        int before = this.pb().nTuplesRemoved;
        block0: for (Constraint c : x.ctrs) {
            if (c.scp.length != 2 || !(c instanceof CtrExtension)) continue;
            int p = c.positionOf(x);
            int q = p == 0 ? 1 : 0;
            Variable y = c.scp[q];
            int[] tmp = c.tupleManager.localTuple;
            tmp[p] = a;
            Domain dom = y.dom;
            int b = dom.lastRemoved();
            while (b != -1 && !dom.isRemovedAtLevel(b, 0)) {
                tmp[q] = b;
                if (!c.removeTuple(tmp)) continue block0;
                this.lastModifications[y.num] = this.counter;
                b = dom.prevRemoved(b);
            }
        }
        return this.pb().nTuplesRemoved - before;
    }

    protected int performSingletonTest(Variable x, int a) {
        Variable[] variables = this.solver.pb.variables;
        ++this.nSingletonTests;
        int before = this.pb().nValuesRemoved;
        this.solver.assign(x, a);
        boolean consistent = true;
        if (this.counter <= variables.length) {
            consistent = super.runAfterAssignment(x);
        } else {
            for (Constraint c : x.ctrs) {
                if (c instanceof FilteringSpecific) {
                    throw new MissingImplementationException();
                }
                Variable y = Variable.firstDifferentVariableIn(c.scp, x);
                this.reviser.applyTo((CtrHard)c, y);
                if (y.dom.size() != 0) continue;
                consistent = false;
                break;
            }
            int id = x.num;
            int lastCheck = this.counter - variables.length;
            for (int i = 0; i < this.lastModifications.length; ++i) {
                if (i == id || this.lastModifications[i] <= lastCheck) continue;
                this.queue.add(variables[i]);
            }
            this.queue.incrementTimestampsOfEnqueuedVariables();
            boolean bl = consistent = consistent && this.propagate();
        }
        assert (!consistent || this.controlArcConsistency()) : "problem after singleton test: " + x + " = " + a;
        int nbTuplesRemoved = consistent ? this.removeConservativelyTuplesFrom(x, a) : -1;
        this.solver.backtrack(x);
        this.pb().nValuesRemoved = before;
        if (!consistent) {
            ++this.nEffectiveSingletonTests;
            x.dom.removeElementary(a);
        }
        return nbTuplesRemoved;
    }

    private boolean performSingletonTestsOf(Variable x) {
        boolean modified = false;
        Domain dom = x.dom;
        int a = dom.first();
        while (a != -1) {
            if (this.performSingletonTest(x, a) != 0) {
                modified = true;
            }
            a = dom.next(a);
        }
        return modified;
    }

    @Override
    public boolean enforceSecondOrderConsistency() {
        Variable x;
        Variable lastEffectiveVar = x = this.solver.pb.variables[0];
        do {
            ++this.counter;
            if (x.dom.size() > 1) {
                int before = this.pb().nValuesRemoved;
                if (this.performSingletonTestsOf(x)) {
                    this.lastModifications[x.num] = this.counter;
                    if (x.dom.size() == 0) {
                        return false;
                    }
                    if (!super.runAfterRefutation(x)) {
                        return false;
                    }
                    if (this.pb().nValuesRemoved != before) {
                        for (Variable y : this.solver.pb.variables) {
                            this.lastModifications[y.num] = this.counter;
                        }
                    }
                    lastEffectiveVar = x;
                }
                if (this.solver.finished()) {
                    return true;
                }
            }
            x = this.solver.pb.variables[x.num == this.solver.pb.variables.length - 1 ? 0 : x.num + 1];
            if (x.num != 0) continue;
            Kit.log.info("after turn, nbTuplesRemoved=" + this.pb().nTuplesRemoved + " nbValuesRemoved=" + this.pb().nValuesRemoved);
        } while (x != lastEffectiveVar);
        Kit.log.info("finished, nbTuplesRemoved=" + this.pb().nTuplesRemoved + " nbValuesRemoved=" + this.pb().nValuesRemoved);
        return true;
    }
}

