/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.weak;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionSTR1;
import constraints.hard.extension.structures.Table;
import interfaces.TagExperimental;
import propagation.order1.weak.Weak1;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.sets.SetDenseReversible;
import variables.Variable;

public class Weak3
extends Weak1
implements TagExperimental {
    protected boolean onlyOnePass = false;

    public Weak3(Solver solver) {
        super(solver);
    }

    protected boolean tryRefutationOf(Constraint c, int[] tuple) {
        boolean consistent;
        int topStack = ((SolverBacktrack)this.solver).observerVars.top;
        for (int i = 0; i < c.scp.length; ++i) {
            c.scp[i].dom.reduceToElementary(tuple[i]);
        }
        this.solver.restarter.currCutoff = this.cp().propagating.weakCutoff;
        this.solver.doRun();
        boolean bl = consistent = !this.solver.isFullExploration() || this.solver.solManager.nSolutionsFound != 0L;
        if (this.solver.isFullExploration()) {
            this.solver.stoppingType = null;
        }
        for (Variable x : c.scp) {
            x.dom.restoreAtMark();
        }
        ((SolverBacktrack)this.solver).observerVars.top = topStack;
        if (!consistent) {
            ++this.nEffectiveSingletonTests;
        }
        return consistent;
    }

    private int filterConstraint(CtrExtensionSTR1 c) {
        Table table = (Table)c.extStructure();
        for (Variable x : c.scp) {
            x.dom.setMark();
        }
        int cnt = 0;
        ((SolverBacktrack)this.solver).heuristicVars.setPriorityVars(c.scp, c.scp.length);
        SetDenseReversible denseSetOfTuples = c.set;
        int[] dense = denseSetOfTuples.dense;
        int i = 0;
        while (i <= denseSetOfTuples.limit) {
            int[] checkedTuple = table.tuples[dense[i]];
            Kit.log.finest(() -> " try tuple of " + c + " " + Kit.join((Object)checkedTuple, new String[0]));
            boolean consistent = this.tryRefutationOf(c, checkedTuple);
            if (!consistent) {
                Kit.log.finest(() -> "removal of tuple " + Kit.join((Object)checkedTuple, new String[0]));
                ++cnt;
                continue;
            }
            ++i;
        }
        ((SolverBacktrack)this.solver).heuristicVars.resetPriorityVars();
        return cnt;
    }

    @Override
    protected boolean enforceStrongConsistency() {
        boolean modified = true;
        while (modified) {
            modified = false;
            Constraint[] ctrs = this.solver.pb.constraints;
            for (int i = ctrs.length - 1; i >= 0; --i) {
                Constraint c = ctrs[i];
                if (!(c instanceof CtrExtensionSTR1)) continue;
                int nbRemovals = this.filterConstraint((CtrExtensionSTR1)c);
                Kit.log.finest(() -> "   check of " + c + " give " + nbRemovals + " removals of tuples");
                if (nbRemovals > 0) {
                    modified = true;
                }
                if (!this.solver.finished()) continue;
                return true;
            }
            if (this.onlyOnePass) {
                modified = false;
                ((SolverBacktrack)this.solver).heuristicVars.reset();
            }
            Kit.log.finest(() -> "   after pass, nbTuplesRemoved = " + this.pb().nTuplesRemoved + " \n");
        }
        int before = this.pb().nValuesRemoved;
        if (!this.enforceArcConsistency()) {
            return false;
        }
        this.nPreproRemovals = this.pb().nValuesRemoved - before;
        Kit.log.finest(() -> "\n   nbACRemovals = " + this.nPreproRemovals);
        this.cp().restarting.nRunsLimit = 0;
        return true;
    }
}

