/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.singleton;

import org.xcsp.common.Types;
import propagation.order1.singleton.SAC;
import propagation.structures.forSac.Inferrer;
import search.Solver;
import variables.Variable;
import variables.domains.Domain;

public abstract class SACSharing
extends SAC {
    protected Inferrer inferenceManager;

    protected abstract void buildInferenceManager();

    public SACSharing(Solver solver) {
        super(solver);
        this.buildInferenceManager();
    }

    protected final boolean checkSAC(Variable x, int a, Types.TypeOptimization currentOpt) {
        ++this.nSingletonTests;
        this.solver.assign(x, a);
        boolean consistent = this.inferenceManager.exploitInferences(x, a);
        if (consistent) {
            consistent = this.propagate();
            if (consistent) {
                this.inferenceManager.updateInferences(x, a);
            } else {
                ++this.nEffectiveSingletonTests;
            }
        }
        assert (!consistent || this.controlArcConsistency()) : "problem after singleton test: " + x + " = " + a;
        this.solver.backtrack(x);
        return consistent;
    }

    @Override
    protected final int makeSingletonTestsOn(Variable x) {
        int sizeBefore = x.dom.size();
        Domain dom = x.dom;
        if (this.onlyBounds) {
            while (dom.size() > 0 && !this.checkSAC(x, dom.first(), Types.TypeOptimization.MINIMIZE)) {
                dom.removeElementary(dom.first());
            }
            while (dom.size() > 1 && !this.checkSAC(x, dom.last(), Types.TypeOptimization.MAXIMIZE)) {
                dom.removeElementary(dom.last());
            }
        } else {
            int a = dom.first();
            while (a != -1) {
                if (!this.checkSAC(x, a, null)) {
                    dom.removeElementary(a);
                }
                a = dom.next(a);
            }
        }
        return sizeBefore - x.dom.size();
    }

    @Override
    public final boolean runAfterAssignment(Variable x) {
        return this.enforceArcConsistencyAfterAssignment(x);
    }

    @Override
    public final boolean runAfterRefutation(Variable x) {
        return this.enforceArcConsistencyAfterRefutation(x);
    }
}

