/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.singleton;

import propagation.order1.singleton.SACGreedy;
import propagation.structures.forSac.QueueOfCells;
import search.Solver;
import search.backtrack.SolverBacktrack;
import variables.Variable;

public class SAC3
extends SACGreedy {
    protected final QueueOfCells queueOfCells;
    protected final int lastConflictMode;

    public SAC3(Solver solver) {
        super(solver);
        this.queueOfCells = new QueueOfCells((SolverBacktrack)solver, true);
        this.lastConflictMode = 1;
    }

    @Override
    protected boolean manageInconsistentValue(Variable x, int a) {
        if (!super.manageInconsistentValue(x, a)) {
            return false;
        }
        if (this.lastConflictMode == 2) {
            this.queueOfCells.setPriorityOf(x);
        }
        return true;
    }

    @Override
    protected void eraseLastBuiltBranch(int branchSize) {
        if (branchSize > 0) {
            super.eraseLastBuiltBranch(branchSize);
        } else {
            this.queueOfCells.clear();
        }
    }

    protected final boolean buildBranch() {
        QueueOfCells.Cell cell = this.queueOfCells.pickNextCell();
        while (cell != null) {
            Variable x = cell.x;
            int a = cell.a;
            ++this.nSingletonTests;
            if (x.dom.size() == 1) {
                ++this.nFoundSingletons;
            }
            assert (!x.isAssigned() && x.dom.isPresent(a) && this.queue.isEmpty());
            this.solver.assign(x, a);
            if (this.enforceArcConsistencyAfterAssignment(x)) {
                if (this.solver.depth() == this.solver.pb.variables.length && this.stopSACWhenFoundSolution) {
                    this.solver.solManager.handleNewSolution(true);
                }
            } else {
                this.solver.backtrack(x);
                int lastBuiltBranchSize = this.solver.depth() - this.nodeDepth;
                if (lastBuiltBranchSize == 0) {
                    return this.manageInconsistentValue(x, a);
                }
                this.queueOfCells.add(x, a);
                if (!this.maximumBranchExtension || !this.canFindAnotherExtensionInsteadOf(x, a)) {
                    if (this.lastConflictMode <= 0) break;
                    this.queueOfCells.setPriorityTo(x, a);
                    break;
                }
            }
            cell = this.queueOfCells.pickNextCell();
        }
        this.eraseLastBuiltBranch(this.solver.depth() - this.nodeDepth);
        return true;
    }

    @Override
    protected boolean enforceStrongConsistency() {
        this.nodeDepth = this.solver.depth();
        this.sumBranchSizes = 0;
        this.nBranchesBuilt = 0;
        for (int cnt = 0; cnt < this.nPassesLimit; ++cnt) {
            long nBefore = this.nEffectiveSingletonTests;
            this.queueOfCells.fill();
            while (this.queueOfCells.size > 0) {
                this.performingProperSearch = true;
                boolean consistent = this.buildBranch();
                this.performingProperSearch = false;
                if (!consistent) {
                    return false;
                }
                if (!this.stopSACWhenFoundSolution || !this.solver.finished()) continue;
                return true;
            }
            if (this.cp().verbose > 1) {
                this.displayPassInfo(cnt, this.nEffectiveSingletonTests - nBefore, this.nEffectiveSingletonTests - nBefore == 0L);
            }
            if (nBefore == this.nEffectiveSingletonTests) break;
        }
        assert (this.solver.finished() || this.controlArcConsistency() && this.controlSingletonArcConsistency());
        return true;
    }
}

