/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.singleton;

import heuristics.variables.HeuristicVariables;
import heuristics.variables.dynamic.WDegOnDom;
import java.util.stream.IntStream;
import propagation.order1.singleton.SACGreedy;
import search.Solver;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import variables.Variable;

public class ESAC3
extends SACGreedy {
    private Variable lastFailedVar;
    private int lastFailedIdx;
    private Variable currSelectedVar;
    private int currSelectedIdx;
    private int currIndexOfVarHeuristic = -1;
    private HeuristicVariables[] varHeuristics;
    private QueueESAC queueESAC = new QueueESAC();

    public ESAC3(Solver solver) {
        super(solver);
        this.varHeuristics = new HeuristicVariables[]{new WDegOnDom((SolverBacktrack)solver, false)};
        this.shavingEvaluator = this.cp().shaving.ratio != 0.0 ? new SACGreedy.ShavingEvaluator(solver.pb.variables.length, this.cp().shaving.alpha, this.cp().shaving.ratio) : null;
    }

    private void makeSelection() {
        if (this.lastFailedVar == null || this.nBranchesBuilt < this.varHeuristics.length) {
            this.currSelectedVar = this.queueESAC.selectNextVariable();
            this.currSelectedIdx = this.currSelectedVar.dom.first();
        } else {
            this.currSelectedVar = this.queueESAC.pick(this.lastFailedVar);
            this.currSelectedIdx = this.lastFailedVar.dom.isPresent(this.lastFailedIdx) ? this.lastFailedIdx : this.lastFailedVar.dom.first();
        }
        this.lastFailedVar = null;
        assert (!this.currSelectedVar.isAssigned() && this.currSelectedVar.dom.isPresent(this.currSelectedIdx) && this.queue.isEmpty());
    }

    protected boolean buildBranch() {
        this.currIndexOfVarHeuristic = (this.currIndexOfVarHeuristic + 1) % this.varHeuristics.length;
        boolean finished = false;
        while (!finished) {
            this.makeSelection();
            ++this.nSingletonTests;
            this.solver.assign(this.currSelectedVar, this.currSelectedIdx);
            if (this.enforceArcConsistencyAfterAssignment(this.currSelectedVar)) {
                if (this.solver.depth() != this.solver.pb.variables.length) continue;
                this.solver.solManager.handleNewSolution(true);
                finished = true;
                continue;
            }
            this.queueESAC.addLastVariable();
            this.lastFailedVar = this.currSelectedVar;
            this.lastFailedIdx = this.currSelectedIdx;
            this.solver.backtrack(this.currSelectedVar);
            finished = !this.maximumBranchExtension || !this.canFindAnotherExtensionInsteadOf(this.currSelectedVar, this.currSelectedIdx);
        }
        int lastBuiltBranchSize = this.solver.depth() - this.nodeDepth;
        if (lastBuiltBranchSize == 0) {
            return this.manageInconsistentValue(this.currSelectedVar, this.currSelectedIdx);
        }
        this.eraseLastBuiltBranch(lastBuiltBranchSize);
        return true;
    }

    @Override
    protected boolean enforceStrongConsistency() {
        this.nodeDepth = this.solver.depth();
        this.sumBranchSizes = 0;
        this.nBranchesBuilt = 0;
        this.lastFailedVar = null;
        this.queueESAC.initialize();
        long nbEffectiveSingletonTestsBefore = this.nEffectiveSingletonTests;
        while (this.queueESAC.nUncheckedVars > 0) {
            this.performingProperSearch = true;
            boolean consistent = this.buildBranch();
            this.solver.resetNoSolutions();
            this.performingProperSearch = false;
            if (!consistent) {
                return false;
            }
            if (!this.solver.finished()) continue;
            return true;
        }
        if (this.cp().verbose > 1) {
            this.displayPassInfo(0, this.nEffectiveSingletonTests - nbEffectiveSingletonTestsBefore, true);
        }
        return true;
    }

    class QueueESAC {
        private int nUncheckedVars;
        private Variable[] uncheckedVars;
        private HeuristicVariables.BestScoredVariable bestScoredVariable = new HeuristicVariables.BestScoredVariable();

        private QueueESAC() {
            this.uncheckedVars = new Variable[ESAC3.this.solver.pb.variables.length];
        }

        public void initialize() {
            this.nUncheckedVars = 0;
            Variable x = ESAC3.this.solver.futVars.first();
            while (x != null) {
                if (ESAC3.this.shavingEvaluator == null || ESAC3.this.shavingEvaluator.isEligible(x)) {
                    this.uncheckedVars[this.nUncheckedVars++] = x;
                } else {
                    ESAC3.this.shavingEvaluator.updateRatioAfterUntest(x);
                }
                x = ESAC3.this.solver.futVars.next(x);
            }
        }

        public Variable selectNextVariable() {
            this.bestScoredVariable.reset(false);
            if (this.nUncheckedVars == 0) {
                ESAC3.this.solver.futVars.execute(x -> this.bestScoredVariable.update((Variable)x, ESAC3.this.varHeuristics[ESAC3.this.currIndexOfVarHeuristic].scoreOptimizedOf((Variable)x)));
            } else {
                assert (this.controlUncheckedVariables());
                int bestPos = 0;
                for (int i = 0; i < this.nUncheckedVars; ++i) {
                    if (!this.bestScoredVariable.update(this.uncheckedVars[i], ESAC3.this.varHeuristics[ESAC3.this.currIndexOfVarHeuristic].scoreOptimizedOf(this.uncheckedVars[i]))) continue;
                    bestPos = i;
                }
                Kit.swap(this.uncheckedVars, --this.nUncheckedVars, bestPos);
            }
            return this.bestScoredVariable.variable;
        }

        public Variable pick(Variable x) {
            assert (this.uncheckedVars[this.nUncheckedVars - 1] == x) : "should always be the case, because we always swap the selected variable with the one at the last position ";
            return this.uncheckedVars[--this.nUncheckedVars];
        }

        public void addLastVariable() {
            if (this.nUncheckedVars > 0 || this.uncheckedVars[0] == ESAC3.this.currSelectedVar) {
                ++this.nUncheckedVars;
            }
        }

        private boolean controlUncheckedVariables() {
            IntStream.range(0, this.nUncheckedVars).forEach(i -> Kit.control(!this.uncheckedVars[i].isAssigned(), () -> this.uncheckedVars[i] + " is assigned"));
            return true;
        }
    }
}

