/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.partial;

public class PickThresholdManager {
    private int[] nFailedOccurrencesByNbPicks;
    private int[] nSucceedOccurrencesByNbPicks;
    private int[] sample;
    private int sampleCursor;
    private int cycleLength = 10;
    private int cycleCursor;
    private boolean initializationPhase = true;
    private int pickThreshold = Integer.MAX_VALUE;
    private boolean singletonCheckRunning;
    private boolean alwaysLimitPropagationLength = false;
    private int nPicksBefore;

    public boolean mustStopPropagation(int nbPicks) {
        return (this.singletonCheckRunning || this.alwaysLimitPropagationLength) && nbPicks >= this.pickThreshold;
    }

    PickThresholdManager(int initialThreshold, int sampleSize) {
        this.nFailedOccurrencesByNbPicks = new int[initialThreshold];
        this.nSucceedOccurrencesByNbPicks = new int[initialThreshold];
        this.sample = new int[sampleSize];
        this.pickThreshold = initialThreshold - 1;
    }

    public void actBeforeSingletonCheck(int nbPicks) {
        this.singletonCheckRunning = true;
        this.nPicksBefore = nbPicks;
        if (!this.initializationPhase && ++this.cycleCursor == this.cycleLength) {
            this.pickThreshold = Integer.MAX_VALUE;
        }
    }

    private void addData(boolean consistent, int nAchievedPicks) {
        if (!consistent) {
            if (nAchievedPicks >= this.nFailedOccurrencesByNbPicks.length) {
                this.nFailedOccurrencesByNbPicks[0] = this.nFailedOccurrencesByNbPicks[0] + 1;
                this.sample[this.sampleCursor] = Integer.MIN_VALUE;
            } else {
                int n = nAchievedPicks;
                this.nFailedOccurrencesByNbPicks[n] = this.nFailedOccurrencesByNbPicks[n] + 1;
                this.sample[this.sampleCursor] = -nAchievedPicks;
            }
        } else if (nAchievedPicks >= this.nSucceedOccurrencesByNbPicks.length) {
            this.nSucceedOccurrencesByNbPicks[0] = this.nSucceedOccurrencesByNbPicks[0] + 1;
            this.sample[this.sampleCursor] = Integer.MAX_VALUE;
        } else {
            int n = nAchievedPicks;
            this.nSucceedOccurrencesByNbPicks[n] = this.nSucceedOccurrencesByNbPicks[n] + 1;
            this.sample[this.sampleCursor] = nAchievedPicks;
        }
        this.sampleCursor = (this.sampleCursor + 1) % this.sample.length;
    }

    private void computeNewThreshold() {
        int nbCurrentFailedOccurrences = 0;
        int nbCurrentSucceedOccurrences = 0;
        long sumCurrentFailedOccurrences = 0L;
        long sumCurrentSucceedOccurrences = 0L;
        double bestCost = Double.MAX_VALUE;
        int bestNbPicks = 0;
        for (int i = 1; i < this.nFailedOccurrencesByNbPicks.length; ++i) {
            double currentCost;
            double averageCost;
            nbCurrentSucceedOccurrences += this.nSucceedOccurrencesByNbPicks[i];
            sumCurrentSucceedOccurrences += (long)(i * this.nSucceedOccurrencesByNbPicks[i]);
            if (this.nFailedOccurrencesByNbPicks[i] != 0 && (averageCost = (currentCost = (double)((sumCurrentFailedOccurrences += (long)(i * this.nFailedOccurrencesByNbPicks[i])) + sumCurrentSucceedOccurrences + (long)(i * (this.sample.length - (nbCurrentFailedOccurrences += this.nFailedOccurrencesByNbPicks[i]) - nbCurrentSucceedOccurrences)))) / (double)nbCurrentFailedOccurrences) < bestCost) {
                bestNbPicks = i;
                bestCost = averageCost;
            }
            if (nbCurrentFailedOccurrences + nbCurrentSucceedOccurrences == this.sample.length) break;
        }
        this.pickThreshold = bestNbPicks;
        this.display();
    }

    public void actAfterSingletonCheck(int nbPicks, boolean consistent) {
        this.singletonCheckRunning = false;
        if (this.initializationPhase) {
            this.addData(consistent, nbPicks - this.nPicksBefore);
            if (this.sampleCursor == 0) {
                this.initializationPhase = false;
            }
        } else if (this.cycleCursor == this.cycleLength) {
            assert (this.pickThreshold == Integer.MAX_VALUE);
            this.cycleCursor = 0;
            if (this.sample[this.sampleCursor] < 0) {
                if (this.sample[this.sampleCursor] == Integer.MIN_VALUE) {
                    this.nFailedOccurrencesByNbPicks[0] = this.nFailedOccurrencesByNbPicks[0] - 1;
                } else {
                    int n = -this.sample[this.sampleCursor];
                    this.nFailedOccurrencesByNbPicks[n] = this.nFailedOccurrencesByNbPicks[n] - 1;
                }
            } else if (this.sample[this.sampleCursor] == Integer.MAX_VALUE) {
                this.nSucceedOccurrencesByNbPicks[0] = this.nSucceedOccurrencesByNbPicks[0] - 1;
            } else {
                int n = this.sample[this.sampleCursor];
                this.nSucceedOccurrencesByNbPicks[n] = this.nSucceedOccurrencesByNbPicks[n] - 1;
            }
            this.addData(consistent, nbPicks - this.nPicksBefore);
            this.computeNewThreshold();
        }
    }

    private void display() {
    }
}

