/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.partial;

import interfaces.TagExperimental;
import propagation.order1.partial.PickThresholdManager;
import propagation.order1.singleton.SAC;
import search.Solver;
import utility.Kit;
import variables.Variable;

public class ACPartialVariable
extends SAC
implements TagExperimental {
    private PickThresholdManager[] pickThresholdManagers;
    public int[][] effectifFalse;
    public int[][] effectifTrue;
    public boolean displayEffectif = false;

    @Override
    public boolean propagate() {
        int nLocalPicks = 0;
        Variable x = this.queue.var(0);
        boolean collectStats = false;
        while (this.queue.size() != 0) {
            ++nLocalPicks;
            boolean consistent = this.pickAndFilter();
            if (!consistent) {
                if (collectStats) {
                    int[] nArray = this.effectifFalse[x.num];
                    int n = nLocalPicks;
                    nArray[n] = nArray[n] + 1;
                }
                return false;
            }
            if (this.pickThresholdManagers == null || !this.pickThresholdManagers[x.num].mustStopPropagation(nLocalPicks)) continue;
            break;
        }
        if (collectStats) {
            int[] nArray = this.effectifTrue[x.num];
            int n = nLocalPicks;
            nArray[n] = nArray[n] + 1;
        }
        return true;
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        if (this.pickThresholdManagers != null) {
            this.pickThresholdManagers[x.num].actBeforeSingletonCheck(this.queue.nPicks);
        }
        boolean b = super.runAfterAssignment(x);
        if (this.pickThresholdManagers != null) {
            this.pickThresholdManagers[x.num].actAfterSingletonCheck(this.queue.nPicks, b);
        }
        return b;
    }

    public ACPartialVariable(Solver solver) {
        super(solver);
        int length = 250;
        int nVariables = solver.pb.variables.length;
        if (this.cp().shaving.limitedPropagationSamplingSize >= 0) {
            this.pickThresholdManagers = new PickThresholdManager[nVariables];
            for (int i = 0; i < this.pickThresholdManagers.length; ++i) {
                this.pickThresholdManagers[i] = new PickThresholdManager(length, this.cp().shaving.limitedPropagationSamplingSize);
            }
        }
        if (this.displayEffectif) {
            this.effectifTrue = new int[nVariables][length];
            this.effectifFalse = new int[nVariables][length];
        }
    }

    @Override
    protected boolean enforceStrongConsistency() {
        return true;
    }

    public void display() {
        if (this.displayEffectif) {
            System.out.println();
            System.out.println(this.solver.pb.name());
            for (int i = 0; i < this.effectifFalse.length; ++i) {
                if (Kit.sum(this.effectifFalse[i]) == 0L && Kit.sum(this.effectifTrue[i]) == 0L) continue;
                System.out.println("VariableID " + i + " false (nb=" + Kit.sum(this.effectifFalse[i]) + ",avg=" + Kit.computeAveragePositionOf(this.effectifFalse[i]) + ") => " + Kit.join((Object)this.effectifFalse[i], new String[0]));
                System.out.println("                           true (nb=" + Kit.sum(this.effectifTrue[i]) + ",avg=" + Kit.computeAveragePositionOf(this.effectifTrue[i]) + ") => " + Kit.join((Object)this.effectifTrue[i], new String[0]));
            }
        }
    }
}

