/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.partial;

import interfaces.TagExperimental;
import propagation.order1.partial.PickThresholdManager;
import propagation.order1.singleton.SAC;
import search.Solver;
import utility.Kit;
import variables.Variable;

public class ACPartial
extends SAC
implements TagExperimental {
    private PickThresholdManager pickThresholdManager;
    public int[] effectifFalseACPartial;
    public int[] effectifTrueACPartial;
    public boolean displayEffectif = false;

    @Override
    public boolean propagate() {
        int nbLocalPicks = 0;
        boolean collectStats = true;
        while (this.queue.size() != 0) {
            ++nbLocalPicks;
            boolean consistent = this.pickAndFilter();
            if (!consistent) {
                if (collectStats) {
                    System.out.println(nbLocalPicks + " " + false);
                }
                return false;
            }
            if (this.pickThresholdManager == null || !this.pickThresholdManager.mustStopPropagation(nbLocalPicks)) continue;
            break;
        }
        if (collectStats) {
            System.out.println(nbLocalPicks + " " + true);
        }
        return true;
    }

    @Override
    public boolean runAfterAssignment(Variable var) {
        if (this.pickThresholdManager != null) {
            this.pickThresholdManager.actBeforeSingletonCheck(this.queue.nPicks);
        }
        boolean b = super.runAfterAssignment(var);
        if (this.pickThresholdManager != null) {
            this.pickThresholdManager.actAfterSingletonCheck(this.queue.nPicks, b);
        }
        return b;
    }

    public ACPartial(Solver solver) {
        super(solver);
        int length = 250;
        if (this.cp().shaving.limitedPropagationSamplingSize >= 0) {
            this.pickThresholdManager = new PickThresholdManager(length, this.cp().shaving.limitedPropagationSamplingSize);
        }
        if (this.displayEffectif) {
            this.effectifTrueACPartial = new int[length];
            this.effectifFalseACPartial = new int[length];
        }
    }

    @Override
    protected boolean enforceStrongConsistency() {
        return true;
    }

    public void display() {
        if (this.displayEffectif) {
            System.out.println();
            System.out.println(this.solver.pb.name());
            System.out.println("false (nb=" + Kit.sum(this.effectifFalseACPartial) + ",avg=" + Kit.computeAveragePositionOf(this.effectifFalseACPartial) + ") => " + Kit.join((Object)this.effectifFalseACPartial, new String[0]));
            System.out.println("true (nb=" + Kit.sum(this.effectifTrueACPartial) + ",avg=" + Kit.computeAveragePositionOf(this.effectifTrueACPartial) + ") => " + Kit.join((Object)this.effectifTrueACPartial, new String[0]));
        }
    }
}

