/*
 * Decompiled with CFR 0.152.
 */
package propagation.order1.inverse;

import constraints.Constraint;
import constraints.hard.extension.CtrExtensionSTR1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import propagation.order1.inverse.GICAdvanced;
import search.Solver;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public class GIC4
extends GICAdvanced {
    protected int[][] solutions;
    protected int solutionsLimit;
    protected boolean[][] gic;
    private int nValVariables;
    private int[] valVariableNums;
    private int[] lastSizes;
    private int nTurns;
    private int origin;
    private int target;
    public int nVals;
    public int nUnks;
    public int nUnksAfterAC;
    public int nTests;
    public long wck;
    public long nItestsRestor;
    private Variable[] decisionVars;
    private int[] decisonsIdxs;
    private Interval[][] allIntervals;
    private List<Interval> unknown;
    private List<Interval> inTransfer;
    private List<Interval>[] known;
    private int algo;

    public GIC4(Solver solver) {
        super(solver);
        Variable[] variables = solver.pb.variables;
        this.solutions = new int[Variable.nInitValuesFor(variables)][];
        this.solutionsLimit = -1;
        this.gic = Variable.litterals(variables).booleanArray();
        this.valVariableNums = new int[variables.length];
        this.lastSizes = Kit.repeat(-2, variables.length);
        this.algo = solver.rs.cp.experimental.testI3;
    }

    private void handleSolution(int[] solution) {
        for (int j = this.nSupVariables - 1; j >= 0; --j) {
            int num = this.supVariableNums[j];
            int a = solution[num];
            if (this.gic[num][a]) continue;
            int n = num;
            this.nValuesToBeSupported[n] = this.nValuesToBeSupported[n] - 1;
            if (this.nValuesToBeSupported[n] == 0) {
                this.supVariableNums[j] = this.supVariableNums[--this.nSupVariables];
            }
            this.gic[num][a] = true;
        }
    }

    @Override
    protected void handleNewSolution(Variable x, int a) {
        ++this.solutionsLimit;
        if (this.solutions[this.solutionsLimit] == null) {
            this.solutions[this.solutionsLimit] = new int[this.solver.pb.variables.length];
        }
        int[] solution = this.solver.solManager.lastSolution;
        Kit.copy(solution, this.solutions[this.solutionsLimit]);
        this.handleSolution(solution);
    }

    @Override
    protected void intializationAdvanced() {
        this.nSupVariables = 0;
        this.nValVariables = 0;
        if (this.solver.futVars.lastPast() != null) {
            this.valVariableNums[this.nValVariables++] = this.solver.futVars.lastPast().num;
        }
        for (Variable x : this.solver.futVars) {
            int domSize;
            int num = x.num;
            this.nValuesToBeSupported[num] = domSize = x.dom.size();
            if (this.lastSizes[num] != domSize) {
                this.valVariableNums[this.nValVariables++] = num;
            }
            this.supVariableNums[this.nSupVariables++] = num;
            Arrays.fill(this.gic[num], false);
        }
        Variable[] variables = this.solver.pb.variables;
        for (int i = this.solutionsLimit; i >= 0; --i) {
            int[] solution = this.solutions[i];
            boolean valid = true;
            for (int j = this.nValVariables - 1; j >= 0; --j) {
                int num = this.valVariableNums[j];
                if (variables[num].dom.isPresent(solution[num])) continue;
                valid = false;
                break;
            }
            if (valid) {
                this.handleSolution(solution);
                continue;
            }
            Kit.swap(this.solutions, i, this.solutionsLimit--);
        }
    }

    @Override
    protected boolean isInverseAdvanced(Variable x, int a) {
        return this.gic[x.num][a] || this.isInverse(x, a);
    }

    @Override
    public boolean enforceStrongConsistency() {
        boolean consistent = super.enforceStrongConsistency();
        this.restoreAfterDeletingOneDecision();
        this.solver.futVars.execute(x -> {
            this.lastSizes[x.num] = x.dom.size();
        });
        return consistent;
    }

    @Override
    public boolean runAfterAssignment(Variable x) {
        return !this.performingProperSearch && !x.dom.isModifiedAtCurrentDepth() && this.solver.depth() != this.solver.rs.cp.experimental.testI1 ? true : super.runAfterAssignment(x);
    }

    private void buildIntervalsFor(Variable x, boolean direct) {
        int depth = this.solver.depth();
        boolean firstDecision = depth - 1 == this.target;
        Interval[] intervals = this.allIntervals[x.num];
        Domain dom = x.dom;
        int a = dom.lastRemoved();
        while (a != -1 && dom.getRemovedLevelOf(a) == depth) {
            intervals[a] = firstDecision ? new Interval(x, a, depth, this.origin) : new Interval(x, a, depth - 1, direct ? depth - 1 : this.origin);
            a = dom.prevRemoved(a);
        }
    }

    private void updateMaxFor(Variable x) {
        int depth = this.solver.depth();
        Interval[] intervals = this.allIntervals[x.num];
        Domain dom = x.dom;
        int a = dom.lastRemoved();
        while (a != -1 && dom.getRemovedLevelOf(a) == depth) {
            intervals[a].decreaseMax(depth);
            a = dom.prevRemoved(a);
        }
    }

    private int finalizeIntervals() {
        int nbTests = 0;
        int nbUselessTests = 0;
        while (this.unknown.size() > 0) {
            assert (this.inTransfer.size() == 0);
            if (this.algo == 3) {
                Collections.sort(this.unknown);
                int depthBefore = this.solver.depth();
                for (Interval interval : this.unknown) {
                    if (this.inTransfer.contains(interval)) continue;
                    Kit.control(interval.minDepth <= interval.maxDepth, () -> "" + interval);
                    Variable x = interval.var;
                    int a = interval.idx;
                    int nbDecisionsTaken = this.solver.depth() - depthBefore;
                    int nbDecisions = interval.maxDepth - 1 - depthBefore;
                    assert (nbDecisions > 0);
                    for (int i = nbDecisionsTaken; i < nbDecisions; ++i) {
                        this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                        this.enforceArcConsistencyAfterAssignment(this.decisionVars[i]);
                    }
                    boolean inverse = this.isInverse(x, a);
                    ++nbTests;
                    if (!inverse) {
                        ++nbUselessTests;
                    }
                    if (inverse) {
                        int[] solution = this.solutions[this.solutionsLimit];
                        this.solver.futVars.execute(y -> {
                            if (this.allIntervals[y.num][solution[y.num]] != null) {
                                this.allIntervals[y.num][solution[y.num]].increaseMin(interval.maxDepth);
                            }
                        });
                        --this.solutionsLimit;
                        continue;
                    }
                    interval.decreaseMax(interval.maxDepth - 1);
                }
                int nbDecisions = this.solver.depth() - depthBefore;
                for (int i = 0; i < nbDecisions; ++i) {
                    this.solver.backtrack();
                }
                Kit.control(this.solver.depth() == this.target);
            } else {
                for (Interval interval : this.unknown) {
                    boolean inverse;
                    int i;
                    int nbDecisions;
                    if (this.inTransfer.contains(interval)) continue;
                    Kit.control(interval.minDepth <= interval.maxDepth, () -> "" + interval);
                    Variable x = interval.var;
                    int a = interval.idx;
                    assert (this.solver.depth() == this.target);
                    if (this.algo == 1) {
                        nbDecisions = interval.maxDepth - 1 - this.solver.depth();
                        assert (nbDecisions > 0);
                        for (i = 0; i < nbDecisions; ++i) {
                            this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                            this.enforceArcConsistencyAfterAssignment(this.decisionVars[i]);
                        }
                        inverse = this.isInverse(x, a);
                        ++nbTests;
                        if (!inverse) {
                            ++nbUselessTests;
                        }
                        for (int i2 = 0; i2 < nbDecisions; ++i2) {
                            this.solver.backtrack();
                        }
                        if (inverse) {
                            int[] solution = this.solutions[this.solutionsLimit];
                            this.solver.futVars.execute(y -> {
                                if (this.allIntervals[y.num][solution[y.num]] != null) {
                                    this.allIntervals[y.num][solution[y.num]].increaseMin(interval.maxDepth);
                                }
                            });
                            --this.solutionsLimit;
                            continue;
                        }
                        interval.decreaseMax(interval.maxDepth - 1);
                        continue;
                    }
                    nbDecisions = interval.minDepth - this.solver.depth();
                    assert (nbDecisions > 0);
                    for (i = 0; i < nbDecisions; ++i) {
                        this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                        this.enforceArcConsistencyAfterAssignment(this.decisionVars[i]);
                    }
                    inverse = this.isInverse(x, a);
                    ++nbTests;
                    if (inverse) {
                        ++nbUselessTests;
                    }
                    for (int i3 = 0; i3 < nbDecisions; ++i3) {
                        this.solver.backtrack();
                    }
                    if (inverse) {
                        int[] solution = this.solutions[this.solutionsLimit];
                        interval.increaseMin(interval.minDepth + 1);
                        this.solver.futVars.execute(y -> {
                            if (y != interval.var && this.allIntervals[y.num][solution[y.num]] != null) {
                                this.allIntervals[y.num][solution[y.num]].increaseMin(interval.minDepth);
                            }
                        });
                        --this.solutionsLimit;
                        continue;
                    }
                    interval.decreaseMax(interval.minDepth);
                }
            }
            this.unknown.removeAll(this.inTransfer);
            this.inTransfer.clear();
        }
        this.solver.resetNoSolutions();
        Kit.log.info("nbUselessTests=" + nbUselessTests);
        return nbTests;
    }

    private void restoreAfterDeletingOneDecision() {
        this.origin = this.solver.rs.cp.experimental.testI1;
        this.target = this.solver.rs.cp.experimental.testI2;
        if (this.nTurns == 0 && this.origin > 0 && this.solver.depth() == this.origin) {
            ++this.nTurns;
            int nbItestsBefore = this.nITests;
            Kit.Stopwatch stopwatch = new Kit.Stopwatch();
            if (this.algo == 0) {
                int nbDecisionsToReplay = this.origin - this.target - 1;
                this.decisionVars = new Variable[nbDecisionsToReplay];
                this.decisonsIdxs = new int[nbDecisionsToReplay];
                int cnt = 0;
                while (this.solver.futVars.nDiscarded() > 0) {
                    Variable x = this.solver.futVars.lastPast();
                    int a = x.dom.unique();
                    this.solver.backtrack(x);
                    if (cnt == nbDecisionsToReplay) break;
                    this.decisionVars[nbDecisionsToReplay - 1 - cnt] = x;
                    this.decisonsIdxs[nbDecisionsToReplay - 1 - cnt] = a;
                    ++cnt;
                }
                System.out.println("Backtracked to " + this.solver.depth());
                for (int i = 0; i < this.decisionVars.length; ++i) {
                    this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                    this.runAfterAssignment(this.decisionVars[i]);
                }
            } else {
                int i;
                Variable[] variables = this.solver.pb.variables;
                this.allIntervals = new Interval[variables.length][];
                for (int i2 = 0; i2 < this.allIntervals.length; ++i2) {
                    this.allIntervals[i2] = new Interval[variables[i2].dom.initSize()];
                }
                int nbDecisionsToReplay = this.origin - this.target - 1;
                this.decisionVars = new Variable[nbDecisionsToReplay];
                this.decisonsIdxs = new int[nbDecisionsToReplay];
                this.unknown = new ArrayList<Interval>();
                this.inTransfer = new ArrayList<Interval>();
                this.known = new List[this.solver.pb.variables.length + 1];
                for (int i3 = this.target; i3 <= this.origin; ++i3) {
                    this.known[i3] = new ArrayList<Interval>();
                }
                int cnt = 0;
                while (this.solver.futVars.nDiscarded() > 0) {
                    Variable x = this.solver.futVars.lastPast();
                    int a = x.dom.unique();
                    this.buildIntervalsFor(x, true);
                    this.solver.futVars.execute(y -> this.buildIntervalsFor((Variable)y, false));
                    this.solver.backtrack(x);
                    if (cnt == nbDecisionsToReplay) break;
                    this.decisionVars[nbDecisionsToReplay - 1 - cnt] = x;
                    this.decisonsIdxs[nbDecisionsToReplay - 1 - cnt] = a;
                    ++cnt;
                }
                assert (this.controlIntervals());
                this.nVals = Variable.nValidValuesFor(variables);
                this.nUnks = this.unknown.size();
                this.performingProperSearch = true;
                for (i = 0; i < this.decisionVars.length; ++i) {
                    this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                    this.enforceArcConsistencyAfterAssignment(this.decisionVars[i]);
                    this.updateMaxFor(this.decisionVars[i]);
                    this.solver.futVars.execute(y -> this.updateMaxFor((Variable)y));
                }
                for (i = 0; i < this.decisionVars.length; ++i) {
                    this.solver.backtrack();
                }
                this.unknown.removeAll(this.inTransfer);
                this.inTransfer.clear();
                assert (this.controlIntervals());
                System.out.println("After AC, NbUnk = " + this.unknown.size());
                this.nUnksAfterAC = this.unknown.size();
                this.nTests = this.finalizeIntervals();
                System.out.println("After Finalize");
                assert (this.controlIntervals());
                for (i = 0; i < this.decisionVars.length; ++i) {
                    this.solver.assign(this.decisionVars[i], this.decisonsIdxs[i]);
                    for (Interval interval : this.known[this.solver.depth()]) {
                        if (((Interval)interval).var.dom.isPresent(interval.idx)) {
                            ((Interval)interval).var.dom.removeElementary(interval.idx);
                            continue;
                        }
                        assert (((Interval)interval).var.dom.getRemovedLevelOf(interval.idx) == this.solver.depth());
                    }
                    for (Constraint c : this.solver.pb.constraints) {
                        if (!(c instanceof CtrExtensionSTR1)) continue;
                        int nbValuesBefore = this.solver.pb.nValuesRemoved;
                        ((CtrExtensionSTR1)c).runPropagator(null);
                        assert (this.solver.pb.nValuesRemoved == nbValuesBefore);
                    }
                }
                Kit.log.info("nbVals=" + this.nVals + " nbUnks=" + this.nUnks + " nbUnksAfterAc=" + this.nUnksAfterAC + " nbTests=" + this.nTests);
                this.performingProperSearch = false;
            }
            this.nItestsRestor = this.nITests - nbItestsBefore;
            this.wck = stopwatch.getWckTime();
            System.out.println("Wck=" + this.wck + " nbITestsR=" + this.nItestsRestor);
        }
    }

    private boolean controlIntervals() {
        Kit.control(this.inTransfer.size() == 0, () -> "Control cannot be performed with inTransfer not empty");
        int nbIntervals1 = 0;
        for (int i = 0; i < this.allIntervals.length; ++i) {
            for (int j = 0; j < this.allIntervals[i].length; ++j) {
                if (this.allIntervals[i][j] == null) continue;
                ++nbIntervals1;
                if (this.allIntervals[i][j].isFixed()) {
                    Kit.control(this.known[this.allIntervals[i][j].maxDepth].contains(this.allIntervals[i][j]));
                    continue;
                }
                Kit.control(this.unknown.contains(this.allIntervals[i][j]));
            }
        }
        int nbIntervals2 = this.unknown.size();
        for (int i = this.target; i <= this.origin; ++i) {
            nbIntervals2 += this.known[i].size();
        }
        Kit.control(nbIntervals1 == nbIntervals2);
        return true;
    }

    private void display() {
        Kit.log.fine("Unknown : " + Stream.of(this.unknown).map(it -> it.toString()).collect(Collectors.joining(" ")));
        Kit.log.fine("Known : " + IntStream.range(this.target, this.origin + 1).mapToObj(i -> "  level " + i + " : " + Stream.of(this.known[i]).map(it -> it.toString()).collect(Collectors.joining(" "))).collect(Collectors.joining("\n")));
    }

    class Interval
    implements Comparable<Interval> {
        private Variable var;
        private int idx;
        private int minDepth;
        private int maxDepth;

        private Interval(Variable x, int a, int min, int max) {
            this.var = x;
            this.idx = a;
            this.minDepth = min;
            this.maxDepth = max;
            assert (min <= max);
            if (this.minDepth == this.maxDepth) {
                GIC4.this.known[this.minDepth].add(this);
            } else {
                GIC4.this.unknown.add(this);
            }
        }

        private void increaseMin(int min) {
            if (this.minDepth < min) {
                this.minDepth = min;
                if (this.minDepth == this.maxDepth) {
                    GIC4.this.known[this.minDepth].add(this);
                    GIC4.this.inTransfer.add(this);
                }
            }
        }

        private void decreaseMax(int max) {
            if (this.maxDepth > max) {
                this.maxDepth = max;
                if (this.minDepth == this.maxDepth) {
                    GIC4.this.known[this.minDepth].add(this);
                    GIC4.this.inTransfer.add(this);
                }
            }
        }

        private boolean isFixed() {
            return this.minDepth == this.maxDepth;
        }

        public String toString() {
            return this.var + "=" + this.idx + " in [" + this.minDepth + ".." + this.maxDepth + "]";
        }

        @Override
        public int compareTo(Interval interval) {
            return Integer.compare(this.maxDepth, interval.maxDepth);
        }
    }
}

